/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.api.publishing;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fluxzero.common.Guarantee;
import io.fluxzero.common.MessageType;
import io.fluxzero.common.api.Command;
import io.fluxzero.common.api.SerializedMessage;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public final class Append
extends Command {
    private final MessageType messageType;
    private final List<SerializedMessage> messages;
    private final Guarantee guarantee;

    @JsonIgnore
    public int getSize() {
        return this.messages.size();
    }

    @JsonIgnore
    long getBytes() {
        return this.messages.stream().mapToLong(SerializedMessage::getBytes).sum();
    }

    @Override
    public Guarantee getGuarantee() {
        return Optional.ofNullable(this.guarantee).orElse(Guarantee.NONE);
    }

    @Override
    public String routingKey() {
        return this.messageType.name();
    }

    public String toString() {
        return "Append of length " + this.messages.size();
    }

    @Override
    public Metric toMetric() {
        return new Metric(this.getMessageType(), this.getSize(), this.getBytes(), this.getGuarantee());
    }

    @ConstructorProperties(value={"messageType", "messages", "guarantee"})
    @Generated
    public Append(MessageType messageType, List<SerializedMessage> messages, Guarantee guarantee) {
        this.messageType = messageType;
        this.messages = messages;
        this.guarantee = guarantee;
    }

    @Generated
    public MessageType getMessageType() {
        return this.messageType;
    }

    @Generated
    public List<SerializedMessage> getMessages() {
        return this.messages;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Append)) {
            return false;
        }
        Append other = (Append)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MessageType this$messageType = this.getMessageType();
        MessageType other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !((Object)((Object)this$messageType)).equals((Object)other$messageType)) {
            return false;
        }
        List<SerializedMessage> this$messages = this.getMessages();
        List<SerializedMessage> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        Guarantee this$guarantee = this.getGuarantee();
        Guarantee other$guarantee = other.getGuarantee();
        return !(this$guarantee == null ? other$guarantee != null : !((Object)((Object)this$guarantee)).equals((Object)other$guarantee));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Append;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : ((Object)((Object)$messageType)).hashCode());
        List<SerializedMessage> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        Guarantee $guarantee = this.getGuarantee();
        result = result * 59 + ($guarantee == null ? 43 : ((Object)((Object)$guarantee)).hashCode());
        return result;
    }

    public static final class Metric {
        private final MessageType messageType;
        private final int size;
        private final long bytes;
        private final Guarantee guarantee;

        @ConstructorProperties(value={"messageType", "size", "bytes", "guarantee"})
        @Generated
        public Metric(MessageType messageType, int size, long bytes, Guarantee guarantee) {
            this.messageType = messageType;
            this.size = size;
            this.bytes = bytes;
            this.guarantee = guarantee;
        }

        @Generated
        public MessageType getMessageType() {
            return this.messageType;
        }

        @Generated
        public int getSize() {
            return this.size;
        }

        @Generated
        public long getBytes() {
            return this.bytes;
        }

        @Generated
        public Guarantee getGuarantee() {
            return this.guarantee;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metric)) {
                return false;
            }
            Metric other = (Metric)o;
            if (this.getSize() != other.getSize()) {
                return false;
            }
            if (this.getBytes() != other.getBytes()) {
                return false;
            }
            MessageType this$messageType = this.getMessageType();
            MessageType other$messageType = other.getMessageType();
            if (this$messageType == null ? other$messageType != null : !((Object)((Object)this$messageType)).equals((Object)other$messageType)) {
                return false;
            }
            Guarantee this$guarantee = this.getGuarantee();
            Guarantee other$guarantee = other.getGuarantee();
            return !(this$guarantee == null ? other$guarantee != null : !((Object)((Object)this$guarantee)).equals((Object)other$guarantee));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSize();
            long $bytes = this.getBytes();
            result = result * 59 + (int)($bytes >>> 32 ^ $bytes);
            MessageType $messageType = this.getMessageType();
            result = result * 59 + ($messageType == null ? 43 : ((Object)((Object)$messageType)).hashCode());
            Guarantee $guarantee = this.getGuarantee();
            result = result * 59 + ($guarantee == null ? 43 : ((Object)((Object)$guarantee)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Append.Metric(messageType=" + String.valueOf((Object)this.getMessageType()) + ", size=" + this.getSize() + ", bytes=" + this.getBytes() + ", guarantee=" + String.valueOf((Object)this.getGuarantee()) + ")";
        }
    }
}

