/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.tracking;

import io.fluxzero.common.ConsistentHashing;
import io.fluxzero.common.TimingUtils;
import io.fluxzero.common.api.SerializedMessage;
import io.fluxzero.common.api.tracking.MessageBatch;
import java.util.Comparator;
import java.util.function.Predicate;

public interface Tracker
extends Comparable<Tracker> {
    public static final Comparator<Tracker> comparator = Comparator.comparing(Tracker::getConsumerName).thenComparing(Tracker::getTrackerId);

    public String getConsumerName();

    public String getClientId();

    public String getTrackerId();

    public Long getLastTrackerIndex();

    public int getMaxSize();

    public long getDeadline();

    public long maxTimeout();

    public Long getPurgeDelay();

    default public boolean isFilterMessageTarget() {
        return false;
    }

    public boolean ignoreSegment();

    public boolean clientControlledIndex();

    default public boolean singleTracker() {
        return false;
    }

    default public Predicate<String> getTypeFilter() {
        return s -> true;
    }

    public void send(MessageBatch var1);

    default public void sendEmptyBatch(MessageBatch batch) {
        this.send(batch);
    }

    public Tracker withLastTrackerIndex(Long var1);

    default public boolean canHandle(SerializedMessage message, int[] segmentRange) {
        return this.isValidTarget(message, segmentRange) && this.isValidType(message);
    }

    default public boolean hasMissedDeadline() {
        return TimingUtils.isMissedDeadline(this.getDeadline());
    }

    private boolean isValidTarget(SerializedMessage message, int[] segmentRange) {
        String target = message.getTarget();
        if (this.isFilterMessageTarget() && target != null) {
            if (target.equals(this.getTrackerId())) {
                return true;
            }
            if (!target.equals(this.getClientId())) {
                return false;
            }
        }
        return this.contains(message, segmentRange);
    }

    private boolean contains(SerializedMessage message, int[] segmentRange) {
        if (this.singleTracker()) {
            return segmentRange[0] == 0 && segmentRange[0] != segmentRange[1];
        }
        if (this.ignoreSegment()) {
            return true;
        }
        return ConsistentHashing.fallsInRange(message.getSegment(), segmentRange);
    }

    private boolean isValidType(SerializedMessage message) {
        return message.getData().getType() == null || this.getTypeFilter().test(message.getData().getType());
    }

    @Override
    default public int compareTo(Tracker o) {
        return comparator.compare(this, o);
    }
}

