/*
 * Decompiled with CFR 0.152.
 */
package io.fluxzero.common.search;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fluxzero.common.ObjectUtils;
import io.fluxzero.common.SearchUtils;
import io.fluxzero.common.api.search.FacetEntry;
import io.fluxzero.common.api.search.SearchDocuments;
import io.fluxzero.common.api.search.SortableEntry;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public final class Document {
    public static Function<Document, ?> identityFunction = d -> String.format("%s_%s", d.getCollection(), d.getId());
    @NonNull
    private final String id;
    private final String type;
    private final int revision;
    private final String collection;
    private final Instant timestamp;
    private final Instant end;
    private final Map<Entry, List<Path>> entries;
    @JsonIgnore
    private final Supplier<String> summary;
    private final Set<FacetEntry> facets;
    private final Set<SortableEntry> sortables;

    public Optional<Entry> getEntryAtPath(String queryPath) {
        return this.getMatchingEntries(Path.pathPredicate(queryPath)).findFirst();
    }

    public Stream<Entry> getMatchingEntries(Predicate<Path> pathPredicate) {
        return this.entries.entrySet().stream().filter(e -> ((List)e.getValue()).stream().anyMatch(pathPredicate)).map(Map.Entry::getKey);
    }

    public Stream<SortableEntry> getSortableEntries(Predicate<Path> pathPredicate) {
        return this.sortables.stream().filter(e -> pathPredicate.test(e.getPath()));
    }

    public Document filterPaths(Predicate<Path> pathFilter) {
        LinkedHashMap<Entry, List<Path>> result = new LinkedHashMap<Entry, List<Path>>();
        for (Map.Entry<Entry, List<Path>> e : this.entries.entrySet()) {
            List<Path> filtered = e.getValue().stream().filter(pathFilter).toList();
            if (filtered.isEmpty()) continue;
            result.put(e.getKey(), filtered);
        }
        return this.toBuilder().entries(result).build();
    }

    public Instant getEnd() {
        return this.end == null || this.timestamp == null || this.end.isAfter(this.timestamp) ? this.end : this.timestamp;
    }

    public static Comparator<Document> createComparator(SearchDocuments searchDocuments) {
        return searchDocuments.getSorting().stream().map(s -> {
            switch (s) {
                case "-timestamp": {
                    return Comparator.comparing(Document::getTimestamp, Comparator.nullsFirst(Comparator.naturalOrder())).reversed();
                }
                case "timestamp": {
                    return Comparator.comparing(Document::getTimestamp, Comparator.nullsFirst(Comparator.naturalOrder()));
                }
                case "-end": {
                    return Comparator.comparing(Document::getEnd, Comparator.nullsLast(Comparator.naturalOrder())).reversed();
                }
                case "end": {
                    return Comparator.comparing(Document::getEnd, Comparator.nullsLast(Comparator.naturalOrder()));
                }
            }
            boolean reversed = s.startsWith("-");
            String queryPath = reversed ? s.substring(1) : s;
            Predicate<Path> pathPredicate = Path.pathPredicate(queryPath);
            Comparator<Document> valueComparator = Comparator.nullsLast(Comparator.comparing(d -> {
                Stream<SortableEntry> matchingEntries = d.getSortableEntries(pathPredicate);
                return (reversed ? matchingEntries.max(Comparator.naturalOrder()) : matchingEntries.min(Comparator.naturalOrder())).orElse(null);
            }, Comparator.nullsLast(Comparator.naturalOrder())));
            return reversed ? valueComparator.reversed() : valueComparator;
        }).reduce(Comparator::thenComparing).orElseGet(() -> Comparator.comparing(Document::getTimestamp, Comparator.nullsLast(Comparator.naturalOrder())).reversed());
    }

    @Generated
    private static Set<FacetEntry> $default$facets() {
        return Collections.emptySet();
    }

    @Generated
    private static Set<SortableEntry> $default$sortables() {
        return Collections.emptySet();
    }

    @Generated
    public static DocumentBuilder builder() {
        return new DocumentBuilder();
    }

    @Generated
    public DocumentBuilder toBuilder() {
        return new DocumentBuilder().id(this.id).type(this.type).revision(this.revision).collection(this.collection).timestamp(this.timestamp).end(this.end).entries(this.entries).summary(this.summary).facets(this.facets).sortables(this.sortables);
    }

    @NonNull
    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public int getRevision() {
        return this.revision;
    }

    @Generated
    public String getCollection() {
        return this.collection;
    }

    @Generated
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public Map<Entry, List<Path>> getEntries() {
        return this.entries;
    }

    @Generated
    public Supplier<String> getSummary() {
        return this.summary;
    }

    @Generated
    public Set<FacetEntry> getFacets() {
        return this.facets;
    }

    @Generated
    public Set<SortableEntry> getSortables() {
        return this.sortables;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Document)) {
            return false;
        }
        Document other = (Document)o;
        if (this.getRevision() != other.getRevision()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$collection = this.getCollection();
        String other$collection = other.getCollection();
        if (this$collection == null ? other$collection != null : !this$collection.equals(other$collection)) {
            return false;
        }
        Instant this$timestamp = this.getTimestamp();
        Instant other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Instant this$end = this.getEnd();
        Instant other$end = other.getEnd();
        if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
            return false;
        }
        Map<Entry, List<Path>> this$entries = this.getEntries();
        Map<Entry, List<Path>> other$entries = other.getEntries();
        if (this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries)) {
            return false;
        }
        Set<FacetEntry> this$facets = this.getFacets();
        Set<FacetEntry> other$facets = other.getFacets();
        if (this$facets == null ? other$facets != null : !((Object)this$facets).equals(other$facets)) {
            return false;
        }
        Set<SortableEntry> this$sortables = this.getSortables();
        Set<SortableEntry> other$sortables = other.getSortables();
        return !(this$sortables == null ? other$sortables != null : !((Object)this$sortables).equals(other$sortables));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRevision();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $collection = this.getCollection();
        result = result * 59 + ($collection == null ? 43 : $collection.hashCode());
        Instant $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Instant $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        Map<Entry, List<Path>> $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        Set<FacetEntry> $facets = this.getFacets();
        result = result * 59 + ($facets == null ? 43 : ((Object)$facets).hashCode());
        Set<SortableEntry> $sortables = this.getSortables();
        result = result * 59 + ($sortables == null ? 43 : ((Object)$sortables).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Document(id=" + this.getId() + ", type=" + this.getType() + ", revision=" + this.getRevision() + ", collection=" + this.getCollection() + ", timestamp=" + String.valueOf(this.getTimestamp()) + ", end=" + String.valueOf(this.getEnd()) + ", entries=" + String.valueOf(this.getEntries()) + ", facets=" + String.valueOf(this.getFacets()) + ", sortables=" + String.valueOf(this.getSortables()) + ")";
    }

    @ConstructorProperties(value={"id", "type", "revision", "collection", "timestamp", "end", "entries", "summary", "facets", "sortables"})
    @Generated
    public Document(@NonNull String id, String type, int revision, String collection, Instant timestamp, Instant end, Map<Entry, List<Path>> entries, Supplier<String> summary, Set<FacetEntry> facets, Set<SortableEntry> sortables) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
        this.type = type;
        this.revision = revision;
        this.collection = collection;
        this.timestamp = timestamp;
        this.end = end;
        this.entries = entries;
        this.summary = summary;
        this.facets = facets;
        this.sortables = sortables;
    }

    public static final class Path {
        public static Path EMPTY_PATH = new Path("");
        private static final Pattern splitPattern = Pattern.compile("(?<!\\\\)/");
        private static final Function<String, String[]> splitFunction = ObjectUtils.memoize(in -> splitPattern.split((CharSequence)in));
        private static final Function<String, String> shortValueFunction = ObjectUtils.memoize(in -> Arrays.stream(splitPattern.split((CharSequence)in)).filter(p -> !SearchUtils.isInteger(p)).map(SearchUtils::unescapeFieldName).collect(Collectors.joining("/")));
        private final String value;
        @JsonIgnore
        private final AtomicReference<Object> shortValue = new AtomicReference();
        @JsonIgnore
        private final AtomicReference<Object> longValue = new AtomicReference();

        public static Stream<String> split(String path) {
            return Arrays.stream(splitFunction.apply(path));
        }

        public static boolean isLongPath(String queryPath) {
            return Path.split(queryPath).anyMatch(SearchUtils::isInteger);
        }

        public static Predicate<Path> pathPredicate(String queryPath) {
            if (queryPath == null) {
                return p -> true;
            }
            queryPath = SearchUtils.normalizePath(queryPath);
            Predicate<String> predicate = SearchUtils.getGlobMatcher(queryPath);
            return Path.isLongPath(queryPath) ? p -> predicate.test(p.getLongValue()) : p -> predicate.test(p.getShortValue());
        }

        @ConstructorProperties(value={"value"})
        @Generated
        public Path(String value) {
            this.value = value;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Path)) {
                return false;
            }
            Path other = (Path)o;
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Document.Path(value=" + this.getValue() + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        public String getShortValue() {
            Object $value = this.shortValue.get();
            if ($value == null) {
                AtomicReference<Object> atomicReference = this.shortValue;
                synchronized (atomicReference) {
                    $value = this.shortValue.get();
                    if ($value == null) {
                        String actualValue = shortValueFunction.apply(this.getValue());
                        $value = actualValue == null ? this.shortValue : actualValue;
                        this.shortValue.set($value);
                    }
                }
            }
            return (String)($value == this.shortValue ? null : $value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        public String getLongValue() {
            Object $value = this.longValue.get();
            if ($value == null) {
                AtomicReference<Object> atomicReference = this.longValue;
                synchronized (atomicReference) {
                    $value = this.longValue.get();
                    if ($value == null) {
                        String actualValue = Arrays.stream(splitPattern.split(this.getValue())).map(SearchUtils::unescapeFieldName).collect(Collectors.joining("/"));
                        $value = actualValue == null ? this.longValue : actualValue;
                        this.longValue.set($value);
                    }
                }
            }
            return (String)($value == this.longValue ? null : $value);
        }
    }

    public static final class Entry
    implements Comparable<Entry> {
        private final EntryType type;
        private final String value;
        @JsonIgnore
        private final AtomicReference<Object> asPhrase = new AtomicReference();
        @JsonIgnore
        private final AtomicReference<Object> asNumber = new AtomicReference();

        @Override
        public int compareTo(@NonNull Entry o) {
            if (o == null) {
                throw new NullPointerException("o is marked non-null but is null");
            }
            if (this.type == EntryType.NUMERIC && this.type == o.getType()) {
                return this.asNumber().compareTo(o.asNumber());
            }
            return this.getValue().compareToIgnoreCase(o.getValue());
        }

        @Generated
        public EntryType getType() {
            return this.type;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            EntryType this$type = this.getType();
            EntryType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            EntryType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Document.Entry(type=" + String.valueOf((Object)this.getType()) + ", value=" + this.getValue() + ")";
        }

        @ConstructorProperties(value={"type", "value"})
        @Generated
        public Entry(EntryType type, String value) {
            this.type = type;
            this.value = value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        public String asPhrase() {
            Object $value = this.asPhrase.get();
            if ($value == null) {
                AtomicReference<Object> atomicReference = this.asPhrase;
                synchronized (atomicReference) {
                    $value = this.asPhrase.get();
                    if ($value == null) {
                        String actualValue = this.getType() == EntryType.TEXT ? SearchUtils.normalize(this.getValue()) : this.getValue();
                        $value = actualValue == null ? this.asPhrase : actualValue;
                        this.asPhrase.set($value);
                    }
                }
            }
            return (String)($value == this.asPhrase ? null : $value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        public BigDecimal asNumber() {
            Object $value = this.asNumber.get();
            if ($value == null) {
                AtomicReference<Object> atomicReference = this.asNumber;
                synchronized (atomicReference) {
                    $value = this.asNumber.get();
                    if ($value == null) {
                        BigDecimal actualValue = this.getType() == EntryType.NUMERIC ? new BigDecimal(this.getValue()) : null;
                        $value = actualValue == null ? this.asNumber : actualValue;
                        this.asNumber.set($value);
                    }
                }
            }
            return (BigDecimal)($value == this.asNumber ? null : $value);
        }
    }

    @Generated
    public static class DocumentBuilder {
        @Generated
        private String id;
        @Generated
        private String type;
        @Generated
        private int revision;
        @Generated
        private String collection;
        @Generated
        private Instant timestamp;
        @Generated
        private Instant end;
        @Generated
        private Map<Entry, List<Path>> entries;
        @Generated
        private Supplier<String> summary;
        @Generated
        private boolean facets$set;
        @Generated
        private Set<FacetEntry> facets$value;
        @Generated
        private boolean sortables$set;
        @Generated
        private Set<SortableEntry> sortables$value;

        @Generated
        DocumentBuilder() {
        }

        @Generated
        public DocumentBuilder id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        @Generated
        public DocumentBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public DocumentBuilder revision(int revision) {
            this.revision = revision;
            return this;
        }

        @Generated
        public DocumentBuilder collection(String collection) {
            this.collection = collection;
            return this;
        }

        @Generated
        public DocumentBuilder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Generated
        public DocumentBuilder end(Instant end) {
            this.end = end;
            return this;
        }

        @Generated
        public DocumentBuilder entries(Map<Entry, List<Path>> entries) {
            this.entries = entries;
            return this;
        }

        @JsonIgnore
        @Generated
        public DocumentBuilder summary(Supplier<String> summary) {
            this.summary = summary;
            return this;
        }

        @Generated
        public DocumentBuilder facets(Set<FacetEntry> facets) {
            this.facets$value = facets;
            this.facets$set = true;
            return this;
        }

        @Generated
        public DocumentBuilder sortables(Set<SortableEntry> sortables) {
            this.sortables$value = sortables;
            this.sortables$set = true;
            return this;
        }

        @Generated
        public Document build() {
            Set<FacetEntry> facets$value = this.facets$value;
            if (!this.facets$set) {
                facets$value = Document.$default$facets();
            }
            Set<SortableEntry> sortables$value = this.sortables$value;
            if (!this.sortables$set) {
                sortables$value = Document.$default$sortables();
            }
            return new Document(this.id, this.type, this.revision, this.collection, this.timestamp, this.end, this.entries, this.summary, facets$value, sortables$value);
        }

        @Generated
        public String toString() {
            return "Document.DocumentBuilder(id=" + this.id + ", type=" + this.type + ", revision=" + this.revision + ", collection=" + this.collection + ", timestamp=" + String.valueOf(this.timestamp) + ", end=" + String.valueOf(this.end) + ", entries=" + String.valueOf(this.entries) + ", summary=" + String.valueOf(this.summary) + ", facets$value=" + String.valueOf(this.facets$value) + ", sortables$value=" + String.valueOf(this.sortables$value) + ")";
        }
    }

    public static enum EntryType {
        TEXT(0),
        NUMERIC(1),
        BOOLEAN(2),
        NULL(3),
        EMPTY_ARRAY(4),
        EMPTY_OBJECT(5);

        private final byte index;

        private EntryType(int index) {
            this.index = (byte)index;
        }

        public byte serialize() {
            return this.index;
        }

        public static EntryType deserialize(byte b) {
            return switch (b) {
                case 0 -> TEXT;
                case 1 -> NUMERIC;
                case 2 -> BOOLEAN;
                case 3 -> NULL;
                case 4 -> EMPTY_ARRAY;
                case 5 -> EMPTY_OBJECT;
                default -> throw new IllegalArgumentException("Cannot convert to EntryType: " + b);
            };
        }
    }
}

