/*
 * Decompiled with CFR 0.152.
 */
package io.flowinquiry.testcontainers.ai;

import io.flowinquiry.testcontainers.ContainerType;
import io.flowinquiry.testcontainers.SpringAwareContainerProvider;
import io.flowinquiry.testcontainers.ai.EnableOllamaContainer;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.ollama.OllamaContainer;

public class OllamaContainerProvider
extends SpringAwareContainerProvider<EnableOllamaContainer, OllamaContainer> {
    private static final Logger log = LoggerFactory.getLogger(OllamaContainerProvider.class);

    public ContainerType getContainerType() {
        return ContainerType.OLLAMA;
    }

    protected OllamaContainer createContainer() {
        return new OllamaContainer(this.dockerImage + ":" + this.version);
    }

    public void start() {
        super.start();
        try {
            log.info("Starting pull model {}", (Object)((EnableOllamaContainer)this.enableContainerAnnotation).model());
            ((OllamaContainer)this.container).execInContainer(new String[]{"ollama", "pull", ((EnableOllamaContainer)this.enableContainerAnnotation).model()});
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void applyTo(ConfigurableEnvironment environment) {
        Properties props = new Properties();
        props.put("spring.ai.ollama.base-url", ((OllamaContainer)this.container).getEndpoint());
        props.put("spring.ai.ollama.init.pull-model-strategy", "when_missing");
        props.put("spring.ai.ollama.chat.model", ((EnableOllamaContainer)this.enableContainerAnnotation).model());
        props.put("spring.ai.ollama.chat.options.temperature", ((EnableOllamaContainer)this.enableContainerAnnotation).options().temperature());
        props.put("spring.ai.ollama.chat.options.topp", ((EnableOllamaContainer)this.enableContainerAnnotation).options().topP());
        environment.getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("testcontainers", props));
    }
}

