/*
 * Decompiled with CFR 0.152.
 */
package io.fliqa.client.interledger.utils;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public final class Assert {
    private Assert() {
    }

    public static void isTrue(boolean value, String message) {
        if (!value) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <E extends Throwable> void isTrue(boolean value, Supplier<E> exceptionSupplier) throws E {
        if (!value) {
            throw (Throwable)exceptionSupplier.get();
        }
    }

    public static void isFalse(boolean value, String message) {
        if (value) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <E extends Throwable> void isFalse(boolean value, Supplier<E> exceptionSupplier) throws E {
        if (value) {
            throw (Throwable)exceptionSupplier.get();
        }
    }

    public static void notNull(Object value, String message) {
        if (value == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <E extends Throwable> void notNull(Object value, Supplier<E> exceptionSupplier) throws E {
        if (value == null) {
            throw (Throwable)exceptionSupplier.get();
        }
    }

    public static void notNullOrEmpty(String value, String message) {
        if (value == null || value.isBlank()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <E extends Throwable> void notNullOrEmpty(String value, Supplier<E> exceptionSupplier) throws E {
        if (value == null || value.isBlank()) {
            throw (Throwable)exceptionSupplier.get();
        }
    }

    public static <K, V> void notNullOrEmpty(Map<K, V> value, String message) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <E extends Throwable, T> void notNullOrEmpty(List<T> value, Supplier<E> exceptionSupplier) throws E {
        if (value == null || value.isEmpty()) {
            throw (Throwable)exceptionSupplier.get();
        }
    }

    public static <E extends Throwable, T> void notNullOrEmpty(Set<T> value, Supplier<E> exceptionSupplier) throws E {
        if (value == null || value.isEmpty()) {
            throw (Throwable)exceptionSupplier.get();
        }
    }
}

