/*
 * Decompiled with CFR 0.152.
 */
package io.fliqa.client.interledger.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class InterledgerAmount {
    public static final int DEFAULT_AMOUNT_SCALE = 2;
    @JsonProperty(value="assetCode", required=true)
    public String assetCode;
    @JsonProperty(value="assetScale", required=true)
    public int assetScale;
    @JsonProperty(value="value", required=true)
    public String amount;

    public BigDecimal asBigDecimal() {
        return new BigDecimal(this.amount).movePointLeft(this.assetScale);
    }

    public static InterledgerAmount build(BigDecimal amount, String assetCode) {
        return InterledgerAmount.build(amount, assetCode, 2);
    }

    public static InterledgerAmount build(BigDecimal amount, String assetCode, int scale) {
        if (amount == null) {
            throw new IllegalArgumentException("amount cannot be null or empty.");
        }
        if (assetCode == null || assetCode.isBlank()) {
            throw new IllegalArgumentException("assetCode cannot be null or empty.");
        }
        if (assetCode.length() != 3) {
            throw new IllegalArgumentException(String.format("assetCode must be 3 characters long / ISO4217 currency code, but was: '%s'.", assetCode));
        }
        InterledgerAmount out = new InterledgerAmount();
        out.assetCode = assetCode;
        out.amount = InterledgerAmount.toInterledgerAmount(amount, scale);
        out.assetScale = scale;
        return out;
    }

    public static String toInterledgerAmount(BigDecimal amount, int amountScale) {
        BigDecimal out = amount.setScale(2, RoundingMode.HALF_UP).scaleByPowerOfTen(amountScale);
        DecimalFormat decimalFormat = new DecimalFormat("#");
        return decimalFormat.format(out);
    }

    public static String toInterledgerAmount(BigDecimal amount) {
        return InterledgerAmount.toInterledgerAmount(amount, 2);
    }

    public String toString() {
        return "InterledgerAmount{assetCode='" + this.assetCode + "', assetScale=" + this.assetScale + ", amount='" + this.amount + "'}";
    }
}

