/*
 * Decompiled with CFR 0.152.
 */
package io.fliqa.client.interledger.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fliqa.client.interledger.model.AccessAction;
import io.fliqa.client.interledger.model.AccessInteract;
import io.fliqa.client.interledger.model.AccessItem;
import io.fliqa.client.interledger.model.AccessItemType;
import io.fliqa.client.interledger.model.AccessToken;
import io.fliqa.client.interledger.model.InteractFinish;
import io.fliqa.client.interledger.model.InterledgerAmount;
import io.fliqa.client.interledger.model.WalletAddress;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class GrantAccessRequest {
    @JsonProperty(value="client")
    public WalletAddress client;
    @JsonProperty(value="access_token")
    public AccessToken accessToken;
    @JsonProperty(value="interact")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public AccessInteract interact;
    private static final String REDIRECT = "redirect";

    public GrantAccessRequest(WalletAddress client) {
        this.client = client;
    }

    public static GrantAccessRequest build(WalletAddress clientWallet, AccessItemType accessType, Set<AccessAction> accessActions) {
        GrantAccessRequest request = new GrantAccessRequest(clientWallet);
        request.accessToken = new AccessToken();
        AccessItem accessItem = new AccessItem();
        accessItem.accessType = accessType;
        accessItem.actions = accessActions;
        request.accessToken.access = new LinkedHashSet<AccessItem>();
        request.accessToken.access.add(accessItem);
        return request;
    }

    public static GrantAccessRequest outgoing(WalletAddress clientWallet, AccessItemType accessType, Set<AccessAction> accessActions, URI identifier, InterledgerAmount debitAmount) {
        GrantAccessRequest request = GrantAccessRequest.build(clientWallet, accessType, accessActions);
        Optional found = request.accessToken.access.stream().findFirst();
        found.ifPresent(accessItem -> accessItem.accessOutgoing(identifier, debitAmount));
        return request;
    }

    public GrantAccessRequest redirectInteract(URI returnUrl, String nonce) {
        this.interact = new AccessInteract();
        this.interact.start = List.of(REDIRECT);
        if (returnUrl != null) {
            this.interact.finish = new InteractFinish();
            this.interact.finish.method = REDIRECT;
            this.interact.finish.uri = returnUrl;
            this.interact.finish.nonce = nonce;
        }
        return this;
    }
}

