/*
 * Decompiled with CFR 0.152.
 */
package io.fliqa.client.interledger.logging;

import io.fliqa.client.interledger.utils.Assert;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import org.slf4j.Logger;

public class HttpLogger {
    private static final String LOG_SPACE = "    ";
    private static final String LOG_BODY = "body: ";
    private static final String LOG_NO_BODY = "<no body>";
    private final Logger LOGGER;

    public HttpLogger(Logger logger) {
        Assert.notNull((Object)logger, "Logger must not be null");
        this.LOGGER = logger;
    }

    public void logRequest(HttpRequest req) {
        Assert.notNull((Object)req, "HTTP request must not be null");
        StringBuilder logMessage = new StringBuilder();
        logMessage.append("HTTP Request:  ").append(req.method()).append(" ").append(req.uri());
        if (this.LOGGER.isTraceEnabled()) {
            HttpLogger.logHeaders(req.headers(), logMessage);
            if (req.bodyPublisher().isPresent()) {
                Consumer<String> bodyConsumer = body -> {
                    if (body != null && !body.isBlank()) {
                        logMessage.append(System.lineSeparator()).append(LOG_SPACE).append(LOG_BODY).append((String)body);
                    }
                    this.LOGGER.trace(logMessage.toString());
                };
                req.bodyPublisher().get().subscribe(new HttpBodySubscriber(bodyConsumer));
            } else {
                logMessage.append(System.lineSeparator()).append(LOG_SPACE).append(LOG_NO_BODY);
                this.LOGGER.trace(logMessage.toString());
            }
        } else {
            this.LOGGER.debug(logMessage.toString());
        }
    }

    private static void logHeaders(HttpHeaders headers, StringBuilder logMessage) {
        headers.map().forEach((name, values) -> {
            if (!":status".equalsIgnoreCase((String)name)) {
                logMessage.append(System.lineSeparator()).append(LOG_SPACE).append((String)name).append(": ").append(String.join((CharSequence)", ", values));
            }
        });
    }

    public void logResponse(HttpResponse<String> res) {
        Assert.notNull(res, "HTTP response must not be null");
        StringBuilder logMessage = new StringBuilder();
        logMessage.append("HTTP Response: ").append(res.statusCode()).append(" ").append(res.uri());
        if (this.LOGGER.isTraceEnabled()) {
            HttpLogger.logHeaders(res.headers(), logMessage);
            String body = res.body() != null ? res.body() : LOG_NO_BODY;
            logMessage.append(System.lineSeparator()).append(LOG_SPACE).append(LOG_BODY).append(body);
            this.LOGGER.trace(logMessage.toString());
        } else {
            this.LOGGER.debug(logMessage.toString());
        }
    }

    protected static class HttpBodySubscriber
    implements Flow.Subscriber<ByteBuffer> {
        private final Consumer<String> consumer;

        public HttpBodySubscriber(Consumer<String> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            subscription.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(ByteBuffer item) {
            this.consumer.accept(new String(item.array(), StandardCharsets.UTF_8));
        }

        @Override
        public void onError(Throwable throwable) {
        }

        @Override
        public void onComplete() {
        }
    }
}

