/*
 * Decompiled with CFR 0.152.
 */
package io.fliqa.client.interledger.exception;

import io.fliqa.client.interledger.model.ApiError;
import java.net.http.HttpHeaders;
import java.net.http.HttpResponse;

public class InterledgerClientException
extends Exception {
    private static final long serialVersionUID = 1L;
    private int code = 0;
    private HttpHeaders responseHeaders = null;
    private String responseBody = null;

    public InterledgerClientException(Throwable throwable) {
        super(throwable);
    }

    public InterledgerClientException(String message) {
        super(message);
    }

    public InterledgerClientException(String message, Throwable throwable, int code, HttpHeaders responseHeaders, String responseBody) {
        super(message, throwable);
        this.code = code;
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
    }

    public InterledgerClientException(String message, int code, HttpHeaders responseHeaders, String responseBody) {
        this(message, null, code, responseHeaders, responseBody);
    }

    public InterledgerClientException(String message, Throwable throwable, int code, HttpHeaders responseHeaders) {
        this(message, throwable, code, responseHeaders, null);
    }

    public InterledgerClientException(int code, HttpHeaders responseHeaders, String responseBody) {
        this(null, null, code, responseHeaders, responseBody);
    }

    public InterledgerClientException(int code, String message) {
        super(message);
        this.code = code;
    }

    public InterledgerClientException(int code, String message, HttpHeaders responseHeaders, String responseBody) {
        this(code, message);
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
    }

    public int getCode() {
        return this.code;
    }

    public HttpHeaders getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public static InterledgerClientException getApiException(ApiError error, HttpResponse<String> response) {
        String message = InterledgerClientException.formatExceptionMessage(error, response.statusCode());
        String body = response.body() == null ? "[no body]" : response.body();
        return new InterledgerClientException(response.statusCode(), message, response.headers(), body);
    }

    private static String formatExceptionMessage(ApiError error, int statusCode) {
        String code = error.code == null || error.code.isBlank() ? ">no error code<" : error.code;
        String description = error.description == null || error.description.isBlank() ? ">no error description<" : error.description;
        return "[" + statusCode + "] (" + code + ") " + description;
    }
}

