/*
 * Decompiled with CFR 0.152.
 */
package io.fliqa.client.interledger;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.deser.InstantDeserializer;
import io.fliqa.client.interledger.exception.InterledgerClientException;
import io.fliqa.client.interledger.model.ApiError;
import io.fliqa.client.interledger.serializer.InstantSerializer;
import java.time.Instant;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterledgerObjectMapper {
    private static final Set<String> COMMON_ERRORS = Set.of("could not get wallet address", "unauthorized", "forbidden");
    private final ObjectMapper mapper = InterledgerObjectMapper.get();
    private final ObjectMapper unwrapMapper = InterledgerObjectMapper.getUnwrapMapper();
    private static final Logger LOGGER = LoggerFactory.getLogger(InterledgerObjectMapper.class);

    public static ObjectMapper get() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        SimpleModule module = new SimpleModule();
        module.addSerializer(Instant.class, (JsonSerializer)new InstantSerializer());
        module.addDeserializer(Instant.class, (JsonDeserializer)InstantDeserializer.INSTANT);
        mapper.registerModule((Module)module);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }

    private static ObjectMapper getUnwrapMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(DeserializationFeature.UNWRAP_ROOT_VALUE);
        return mapper;
    }

    public String writeValueAsString(Object value) throws InterledgerClientException {
        try {
            return this.mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new InterledgerClientException(String.format("Failed to serialize value: '%s' to JSON.", value), e, 500, null, value != null ? value.toString() : null);
        }
    }

    public <T> T readValue(String content, Class<T> valueType) throws InterledgerClientException {
        try {
            return (T)this.mapper.readValue(content, valueType);
        }
        catch (JsonProcessingException e) {
            throw new InterledgerClientException(String.format("Failed to deserialize response to: '%s'.", valueType.getName()), e, 500, null, content);
        }
    }

    public ApiError readError(String content, int httpResponseCode) throws InterledgerClientException {
        if (COMMON_ERRORS.contains(content.toLowerCase())) {
            throw new InterledgerClientException(content, httpResponseCode, null, content);
        }
        try {
            return (ApiError)this.unwrapMapper.readValue(content, ApiError.class);
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Failed to deserialize response: '{}' to: '{}'.", (Object)content, (Object)ApiError.class.getName());
            throw new InterledgerClientException(content, httpResponseCode, null, content);
        }
    }
}

