/*
 * Decompiled with CFR 0.152.
 */
package org.boon.etcd.examples;

import java.net.URI;
import org.boon.Boon;
import org.boon.core.Handler;
import org.boon.core.Sys;
import org.boon.etcd.ClientBuilder;
import org.boon.etcd.Etcd;
import org.boon.etcd.RedirectResponse;
import org.boon.etcd.Response;

public class ExampleAsyncMain {
    public static void main(String ... args) {
        Handler<Response> handler = new Handler<Response>(){

            public void handle(Response event) {
                if (event.node() != null) {
                    Boon.puts((Object[])new Object[]{event.action(), event.node().key(), event});
                } else {
                    Boon.puts((Object[])new Object[]{event});
                }
            }
        };
        Etcd client = ClientBuilder.builder().hosts(URI.create("http://localhost:4001"), URI.create("http://localhost:4002"), URI.create("http://localhost:4003")).createClient();
        client.get(handler, "foo");
        client.listSorted(handler, "queue");
        Sys.sleep((long)1000L);
        client.set(new Handler<Response>((Handler)handler){
            final /* synthetic */ Handler val$handler;
            {
                this.val$handler = handler;
            }

            public void handle(Response event) {
                if (event instanceof RedirectResponse) {
                    URI location = ((RedirectResponse)event).location();
                    Etcd client = ClientBuilder.builder().hosts(location).createClient();
                    client.set((Handler<Response>)this.val$handler, "foo", "Rick found the other server");
                } else {
                    this.val$handler.handle((Object)event);
                }
            }
        }, "foo", "Rick Was here");
        Sys.sleep((long)3000L);
        client.get(handler, "foo");
        Sys.sleep((long)1000L);
        client.delete(handler, "foo");
        Sys.sleep((long)1000L);
        client.setTemp(handler, "tempKey", "tempValue", 5);
        Sys.sleep((long)1000L);
        client.get(handler, "tempKey");
        Sys.sleep((long)1000L);
        client.get(handler, "tempKey");
        Sys.sleep((long)1000L);
        client.get(handler, "tempKey");
        Sys.sleep((long)4000L);
        client.get(handler, "tempKey");
        Sys.sleep((long)1000L);
        client.get(handler, "tempKey");
        Sys.sleep((long)1000L);
        Boon.puts((Object[])new Object[]{"WAITING ON KEY"});
        client.wait(handler, "waitOnKey");
        Sys.sleep((long)10000L);
        client.createDir(handler, "conf");
        Sys.sleep((long)1000L);
        client.createDir(handler, "conf/foo1");
        client.createDir(handler, "conf/foo2");
        client.createDir(handler, "conf/foo3");
        Boon.puts((Object[])new Object[]{"LIST RECURSIVE"});
        client.listRecursive(handler, "");
        Sys.sleep((long)3000L);
        client.deleteDir(handler, "conf");
        Sys.sleep((long)1000L);
        client.deleteDirRecursively(handler, "conf");
        Sys.sleep((long)1000L);
        client.listRecursive(handler, "");
        Sys.sleep((long)1000L);
        client.createDir(handler, "queue");
        Sys.sleep((long)1000L);
        client.createDir(handler, "queue/queueSubDir");
        Sys.sleep((long)1000L);
        client.addToDir(handler, "queue", "job1", "myjob");
        Sys.sleep((long)1000L);
        client.set(handler, "queue/job1/mom", "mom");
        Sys.sleep((long)1000L);
        client.addToDir(handler, "queue", "job29", "myjob");
        Sys.sleep((long)1000L);
        client.addToDir(handler, "queue", "job3", "job3");
        Sys.sleep((long)1000L);
        Sys.sleep((long)1000L);
        client.listSorted(handler, "queue");
        Sys.sleep((long)1000L);
    }
}

