/*
 * Decompiled with CFR 0.152.
 */
package org.boon.etcd;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.boon.Exceptions;
import org.boon.Str;

public class Request {
    private static final String URI_STUB = "/v2/keys/";
    private static final String UTF_8 = StandardCharsets.UTF_8.displayName();
    private boolean wait;
    private long waitIndex;
    private boolean recursive;
    private boolean sorted;
    private String key;
    private long ttl;
    private boolean dir;
    private boolean consistent;
    private String value;
    private String method = "GET";
    private String host;
    private int port;
    private boolean prevExist;
    private String prevValue;
    private long prevIndex;
    private boolean emptyTTL;

    public static Request request() {
        return new Request();
    }

    public boolean isWait() {
        return this.wait;
    }

    public Request wait(boolean wait) {
        this.wait = wait;
        return this;
    }

    public long waitIndex() {
        return this.waitIndex;
    }

    public Request waitIndex(long waitIndex) {
        this.waitIndex = waitIndex;
        return this;
    }

    public boolean recursive() {
        return this.recursive;
    }

    public Request recursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    public boolean consistent() {
        return this.consistent;
    }

    public Request consistent(boolean consistent) {
        this.consistent = consistent;
        return this;
    }

    public boolean sorted() {
        return this.sorted;
    }

    public Request sorted(boolean sorted) {
        this.sorted = sorted;
        return this;
    }

    public String key() {
        return this.key;
    }

    public Request key(String key) {
        this.key = key;
        return this;
    }

    public long ttl() {
        return this.ttl;
    }

    public Request ttl(long ttl) {
        this.ttl = ttl;
        return this;
    }

    public long prevIndex() {
        return this.prevIndex;
    }

    public Request prevIndex(long prevIndex) {
        this.prevIndex = prevIndex;
        return this;
    }

    public boolean prevExist() {
        return this.prevExist;
    }

    public Request prevExist(boolean prevExist) {
        this.prevExist = prevExist;
        return this;
    }

    public boolean dir() {
        return this.dir;
    }

    public Request dir(boolean dir) {
        this.dir = dir;
        return this;
    }

    public String value() {
        return this.value;
    }

    public Request value(String value) {
        this.value = value;
        return this;
    }

    public String prevValue() {
        return this.prevValue;
    }

    public Request prevValue(String prevValue) {
        this.prevValue = prevValue;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public Request methodGET() {
        this.method = "GET";
        return this;
    }

    public Request methodPUT() {
        this.method = "PUT";
        return this;
    }

    public Request methodPOST() {
        this.method = "POST";
        return this;
    }

    public Request methodDELETE() {
        this.method = "DELETE";
        return this;
    }

    public String uri() {
        StringBuilder builder = new StringBuilder(80);
        builder.append(URI_STUB).append(this.key);
        if (this.method.equals("GET") || this.method.equals("DELETE")) {
            builder.append("?");
            this.paramBody(builder);
        }
        return builder.toString();
    }

    public String paramBody() {
        StringBuilder builder = new StringBuilder(80);
        this.paramBody(builder);
        return builder.toString();
    }

    private void paramBody(StringBuilder builder) {
        boolean first = true;
        if (!Str.isEmpty((String)this.prevValue)) {
            builder.append("prevValue=").append(this.encode(this.prevValue));
            first = false;
        }
        if (!Str.isEmpty((String)this.value)) {
            if (!first) {
                builder.append("&");
            }
            builder.append("value=").append(this.encode(this.value));
            first = false;
        }
        if (this.ttl > 0L) {
            if (!first) {
                builder.append("&");
            }
            builder.append("ttl=").append(this.ttl);
            first = false;
        }
        if (this.waitIndex > 0L) {
            if (!first) {
                builder.append("&");
            }
            builder.append("waitIndex=").append(this.waitIndex);
            first = false;
        }
        if (this.prevIndex > 0L) {
            if (!first) {
                builder.append("&");
            }
            builder.append("prevIndex=").append(this.prevIndex);
            first = false;
        }
        if (this.wait) {
            if (!first) {
                builder.append("&");
            }
            builder.append("wait=true");
            first = false;
        }
        if (this.recursive) {
            if (!first) {
                builder.append("&");
            }
            builder.append("recursive=true");
            first = false;
        }
        if (this.sorted) {
            if (!first) {
                builder.append("&");
            }
            builder.append("sorted=true");
            first = false;
        }
        if (this.emptyTTL) {
            if (!first) {
                builder.append("&");
            }
            builder.append("ttl=");
            first = false;
        }
        if (this.prevExist) {
            if (!first) {
                builder.append("&");
            }
            builder.append("prevExist=true");
            first = false;
        }
        if (this.dir) {
            if (!first) {
                builder.append("&");
            }
            builder.append("dir=true");
            first = false;
        }
        if (this.consistent) {
            if (!first) {
                builder.append("&");
            }
            builder.append("consistent=true");
            first = false;
        }
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            Exceptions.handle((Exception)e);
            return "";
        }
    }

    public String host() {
        return this.host;
    }

    public Request host(String host) {
        this.host = host;
        return this;
    }

    public int port() {
        return this.port;
    }

    public Request port(int port) {
        this.port = port;
        return this;
    }

    public String toString() {
        if (this.method.equals("GET")) {
            return Str.add((String[])new String[]{"http://", this.host, ":" + this.port, this.uri()});
        }
        return Str.add((String[])new String[]{"http://", this.host, ":" + this.port, "::", this.method, this.uri(), "\nREQUEST_BODY\n\t", this.paramBody()});
    }

    public Request emptyTTL() {
        this.emptyTTL = true;
        return this;
    }
}

