/*
 * Decompiled with CFR 0.152.
 */
package org.boon.etcd;

import java.net.URI;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.boon.Lists;
import org.boon.etcd.Etcd;
import org.boon.etcd.EtcdClient;

public class ClientBuilder {
    private boolean useSSL;
    private int poolSize = 20;
    private int timeOutInMilliseconds = 5000;
    private String sslTrustStorePath;
    private String sslTrustStorePassword;
    private String sslKeyStorePath;
    private String sslKeyStorePassword;
    private SSLContext sslContext;
    private boolean followLeader = true;
    private URI[] hosts;
    private boolean sslAuthRequired;
    private boolean sslTrustAll;

    public boolean useSSL() {
        return this.useSSL;
    }

    public void useSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public int poolSize() {
        return this.poolSize;
    }

    public ClientBuilder poolSize(int poolSize) {
        this.poolSize = poolSize;
        return this;
    }

    public int timeOutInMilliseconds() {
        return this.timeOutInMilliseconds;
    }

    public ClientBuilder timeOutInMilliseconds(int timeOutInMilliseconds) {
        this.timeOutInMilliseconds = timeOutInMilliseconds;
        return this;
    }

    public String sslTrustStorePath() {
        return this.sslTrustStorePath;
    }

    public ClientBuilder sslTrustStorePath(String sslTrustStorePath) {
        this.sslTrustStorePath = sslTrustStorePath;
        return this;
    }

    public String sslTrustStorePassword() {
        return this.sslTrustStorePassword;
    }

    public ClientBuilder sslTrustStorePassword(String sslTrustStorePassword) {
        this.sslTrustStorePassword = sslTrustStorePassword;
        return this;
    }

    public String sslKeyStorePath() {
        return this.sslKeyStorePath;
    }

    public ClientBuilder sslKeyStorePath(String sslKeyStorePath) {
        this.sslKeyStorePath = sslKeyStorePath;
        return this;
    }

    public String sslKeyStorePassword() {
        return this.sslKeyStorePassword;
    }

    public ClientBuilder sslKeyStorePassword(String sslKeyStorePassword) {
        this.sslKeyStorePassword = sslKeyStorePassword;
        return this;
    }

    public boolean sslAuthRequired() {
        return this.sslAuthRequired;
    }

    public ClientBuilder sslAuthRequired(boolean sslAuthRequired) {
        this.sslAuthRequired = sslAuthRequired;
        return this;
    }

    public boolean sslTrustAll() {
        return this.sslTrustAll;
    }

    public ClientBuilder sslTrustAll(boolean sslTrustAll) {
        this.sslTrustAll = sslTrustAll;
        return this;
    }

    public List<URI> hosts() {
        return Lists.list((Object[])this.hosts);
    }

    public ClientBuilder hosts(URI ... hosts) {
        this.hosts = hosts;
        return this;
    }

    public SSLContext sslContext() {
        return this.sslContext;
    }

    public ClientBuilder sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public Etcd createClient() {
        return new EtcdClient(null, this);
    }

    public static ClientBuilder builder() {
        return new ClientBuilder();
    }

    public boolean followLeader() {
        return this.followLeader;
    }

    public ClientBuilder followLeader(boolean followLeader) {
        this.followLeader = followLeader;
        return this;
    }
}

