/*
 * Decompiled with CFR 0.152.
 */
package io.exemplary.guice;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.exemplary.guice.Modules;
import io.exemplary.guice.TestInterceptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.Ignore;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

public class TestRunner
extends BlockJUnit4ClassRunner {
    private static final Map<String, Injector> injectors = new ConcurrentHashMap<String, Injector>();
    private static final Map<String, TestInterceptor.Wrapper> interceptors = new ConcurrentHashMap<String, TestInterceptor.Wrapper>();
    private final Injector injector;
    private final TestInterceptor.Wrapper testInterceptors;

    public TestRunner(Class<?> classToRun) throws InitializationError {
        super(classToRun);
        this.injector = this.getInjector(classToRun);
        this.testInterceptors = this.getInterceptors(classToRun);
        for (TestInterceptor interceptor : this.testInterceptors.getInterceptors()) {
            interceptor.beforeClassCreation(classToRun);
        }
    }

    final Injector getInjector(Class<?> classToRun) throws InitializationError {
        Modules annotation = this.getModulesAnnotation(classToRun);
        String key = this.getKey(annotation);
        Injector injector = injectors.get(key);
        if (injector == null) {
            injector = Guice.createInjector(this.getModules(annotation));
            injectors.put(key, injector);
        }
        return injector;
    }

    final Modules getModulesAnnotation(Class<?> classToRun) throws InitializationError {
        Modules annotation = classToRun.getAnnotation(Modules.class);
        if (annotation != null) {
            return annotation;
        }
        throw new InitializationError("Impossible to find @Modules annotation. Did you forget to add it with @RunWith annotation.");
    }

    final String getKey(Modules annotation) throws InitializationError {
        Class<? extends Module>[] classes = annotation.value();
        if (classes.length == 0) {
            throw new InitializationError("The @Modules annotation doesn't list any Guice modules.");
        }
        return Arrays.toString(this.getModuleClasses(annotation));
    }

    final Class<? extends Module>[] getModuleClasses(Modules annotation) {
        LinkedHashSet<Class<? extends Module>> set = new LinkedHashSet<Class<? extends Module>>();
        for (Class<? extends Module> clazz : annotation.value()) {
            set.add(clazz);
        }
        Class[] classes = set.toArray(new Class[set.size()]);
        Arrays.sort(classes, new Comparator<Class<? extends Module>>(){

            @Override
            public int compare(Class<? extends Module> o1, Class<? extends Module> o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return classes;
    }

    List<Module> getModules(Modules annotation) throws InitializationError {
        Class<? extends Module>[] moduleClasses = this.getModuleClasses(annotation);
        ArrayList<Module> modules = new ArrayList<Module>(moduleClasses.length);
        for (int i = 0; i < moduleClasses.length; ++i) {
            Class<? extends Module> moduleClass = moduleClasses[i];
            try {
                modules.add(moduleClasses[i].newInstance());
                continue;
            }
            catch (Exception e) {
                throw new InitializationError("Impossible to instantiate the " + moduleClass.getName() + " Guice Module.");
            }
        }
        return modules;
    }

    final TestInterceptor.Wrapper getInterceptors(Class<?> classToRun) throws InitializationError {
        Modules annotation = this.getModulesAnnotation(classToRun);
        String key = this.getKey(annotation);
        TestInterceptor.Wrapper testInterceptors = interceptors.get(key);
        if (testInterceptors == null) {
            testInterceptors = new TestInterceptor.Wrapper();
            testInterceptors.addInterceptorsFromModules(this.injector);
            interceptors.put(key, testInterceptors);
        }
        testInterceptors.setInterceptors(this.injector);
        return testInterceptors;
    }

    public final Object createTest() {
        return this.injector.getInstance(this.getTestClass().getJavaClass());
    }

    protected final void validateZeroArgConstructor(List<Throwable> errors) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void runChild(FrameworkMethod method, RunNotifier notifier) {
        EachTestNotifier eachNotifier = this.makeNotifier(method, notifier);
        if (method.getAnnotation(Ignore.class) != null) {
            eachNotifier.fireTestIgnored();
            return;
        }
        for (TestInterceptor interceptor : this.testInterceptors.getInterceptors()) {
            interceptor.beforeTestRuns(method.getMethod());
        }
        eachNotifier.fireTestStarted();
        try {
            this.methodBlock(method).evaluate();
        }
        catch (AssumptionViolatedException e) {
            eachNotifier.addFailedAssumption(e);
        }
        catch (Throwable e) {
            eachNotifier.addFailure(e);
        }
        finally {
            eachNotifier.fireTestFinished();
        }
        for (TestInterceptor interceptor : this.testInterceptors.getInterceptors()) {
            interceptor.afterTestRuns(method.getMethod());
        }
    }

    private EachTestNotifier makeNotifier(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        return new EachTestNotifier(notifier, description);
    }
}

