/*
 * Decompiled with CFR 0.152.
 */
package io.exemplary.guice;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.spi.InstanceBinding;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class TestInterceptor {
    public void beforeClassCreation(Class<?> classToRun) {
    }

    public void beforeTestRuns(Method method) {
    }

    public void afterTestRuns(Method method) {
    }

    static class Wrapper {
        private Set<Class<? extends TestInterceptor>> interceptorClasses = new LinkedHashSet<Class<? extends TestInterceptor>>();
        private Set<TestInterceptor> interceptors = new LinkedHashSet<TestInterceptor>();

        Wrapper() {
        }

        void addInterceptor(Class<? extends TestInterceptor> interceptor) {
            this.interceptorClasses.add(interceptor);
        }

        void addInterceptorsFromModules(Injector injector) {
            for (Map.Entry entry : injector.getBindings().entrySet()) {
                Object instance;
                Key key = (Key)entry.getKey();
                Binding binding = (Binding)entry.getValue();
                if (!(binding instanceof InstanceBinding) || !this.isAWrapperBindingKey(key) || !((instance = ((InstanceBinding)binding).getInstance()) instanceof Wrapper)) continue;
                this.interceptorClasses.addAll(((Wrapper)instance).interceptorClasses);
            }
        }

        private boolean isAWrapperBindingKey(Key<?> key) {
            return key.getTypeLiteral().getRawType().equals(Wrapper.class);
        }

        Set<TestInterceptor> getInterceptors() {
            return this.interceptors;
        }

        void setInterceptors(Injector injector) {
            this.interceptors.clear();
            for (Class<? extends TestInterceptor> interceptorClass : this.interceptorClasses) {
                TestInterceptor interceptor = (TestInterceptor)injector.getInstance(interceptorClass);
                this.interceptors.add(interceptor);
            }
        }
    }
}

