/*
 * Decompiled with CFR 0.152.
 */
package io.exemplary.guice;

import com.google.inject.Module;
import io.exemplary.guice.Modules;
import io.exemplary.guice.Story;
import io.exemplary.guice.StoryInterceptor;
import io.exemplary.guice.TestRunner;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

public final class StoryRunner
extends TestRunner {
    private static Map<String, StoryInterceptor.Module> storyModules = new ConcurrentHashMap<String, StoryInterceptor.Module>();

    public StoryRunner(Class<?> classToRun) throws InitializationError {
        super(classToRun);
        Modules annotation = this.getModulesAnnotation(classToRun);
        this.getStoryModule(annotation).clearInstances();
    }

    @Override
    List<Module> getModules(Modules annotation) throws InitializationError {
        List<Module> modules = super.getModules(annotation);
        modules.add((Module)this.getStoryModule(annotation));
        return modules;
    }

    private StoryInterceptor.Module getStoryModule(Modules annotation) throws InitializationError {
        String key = this.getKey(annotation);
        if (!storyModules.containsKey(key)) {
            storyModules.put(key, new StoryInterceptor.Module());
        }
        return storyModules.get(key);
    }

    protected final List<FrameworkMethod> computeTestMethods() {
        return this.getTestClass().getAnnotatedMethods(Story.class);
    }

    protected final void validateTestMethods(List<Throwable> errors) {
        this.validatePublicVoidNoArgMethods(Story.class, false, errors);
    }
}

