/*
 * Decompiled with CFR 0.152.
 */
package io.exemplary.guice;

import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.matcher.Matchers;
import io.exemplary.guice.AbstractStoryModule;
import io.exemplary.guice.Expected;
import io.exemplary.guice.Story;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.junit.runner.RunWith;

class StoryInterceptor
implements MethodInterceptor {
    @Inject
    private Injector injector;
    private AbstractStoryModule.StoryPrinter printer;
    private AbstractStoryModule.StoryConverter converter;
    private static final String FINALIZE = "finalize";

    StoryInterceptor() {
    }

    private AbstractStoryModule.StoryPrinter printer() {
        if (this.printer == null) {
            try {
                this.printer = (AbstractStoryModule.StoryPrinter)this.injector.getInstance(AbstractStoryModule.StoryPrinter.class);
            }
            catch (ConfigurationException e) {
                this.printer = (AbstractStoryModule.StoryPrinter)this.injector.getInstance(AbstractStoryModule.StoryPrinter.Default.class);
            }
        }
        return this.printer;
    }

    private AbstractStoryModule.StoryConverter converter() {
        if (this.converter == null) {
            try {
                this.converter = (AbstractStoryModule.StoryConverter)this.injector.getInstance(AbstractStoryModule.StoryConverter.class);
            }
            catch (ConfigurationException e) {
                this.converter = (AbstractStoryModule.StoryConverter)this.injector.getInstance(AbstractStoryModule.StoryConverter.Default.class);
            }
        }
        return this.converter;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!this.isFinalizeMethod(invocation)) {
            Story story = invocation.getMethod().getAnnotation(Story.class);
            if (story != null) {
                return this.invokeStory(invocation);
            }
            return this.invokeStep(invocation);
        }
        return invocation.proceed();
    }

    private boolean isFinalizeMethod(MethodInvocation invocation) {
        return FINALIZE.equalsIgnoreCase(invocation.getMethod().getName());
    }

    private Object invokeStory(MethodInvocation invocation) throws Throwable {
        this.printer().onStoryBegins(this.classToString(invocation), this.methodToString(invocation));
        Object object = invocation.proceed();
        this.printer().onStoryEnds(this.classToString(invocation), this.methodToString(invocation));
        return object;
    }

    private Object invokeStep(MethodInvocation invocation) throws Throwable {
        this.printer().onStepBegins(this.classToString(invocation), this.methodToString(invocation));
        Expected expected = invocation.getMethod().getAnnotation(Expected.class);
        Object result = null;
        if (expected == null) {
            result = invocation.proceed();
        } else {
            boolean succeed = false;
            try {
                result = invocation.proceed();
                succeed = true;
            }
            catch (Throwable throwable) {
                this.verifyException(expected, throwable);
            }
            if (succeed) {
                throw new Exception("Expected exception " + expected.value().getName());
            }
        }
        this.printer().onStepEnds(this.classToString(invocation), this.methodToString(invocation));
        return result;
    }

    private void verifyException(Expected expected, Throwable actual) throws Exception {
        String expectedMessage = expected.message();
        String actualMessage = actual.getMessage();
        if (!expected.value().isAssignableFrom(actual.getClass())) {
            throw new Exception("Unexpected exception, expected<" + expected.value().getName() + "> but was <" + actual.getClass().getName() + ">", actual);
        }
        if (!(expectedMessage.isEmpty() || actualMessage != null && actualMessage.matches(expectedMessage))) {
            throw new Exception("Unexpected message exception, expected match with <" + expected.message() + "> but was <" + actual.getMessage() + ">", actual);
        }
    }

    private String classToString(MethodInvocation invocation) {
        return this.converter().convertClass(invocation.getMethod().getDeclaringClass());
    }

    private String methodToString(MethodInvocation invocation) {
        Method method = invocation.getMethod();
        Object[] arguments = invocation.getArguments();
        return this.converter().convertMethod(method, arguments);
    }

    public static class Module
    extends AbstractStoryModule {
        private StoryInterceptor interceptor;

        @Override
        protected void configureStory() {
            this.interceptor = new StoryInterceptor();
            this.requestInjection(this.interceptor);
            this.bindInterceptor(Matchers.annotatedWith(RunWith.class), Matchers.any(), new MethodInterceptor[]{this.interceptor});
        }

        void clearInstances() {
            this.interceptor.printer = null;
            this.interceptor.converter = null;
        }
    }
}

