/*
 * Decompiled with CFR 0.152.
 */
package io.exemplary.guice;

import com.google.inject.Inject;
import io.exemplary.guice.Tell;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface MethodConverter {
    public String convert(String var1, Method var2, Object[] var3);

    public static class SetFirstLetterUpperCase
    implements MethodConverter {
        @Override
        public String convert(String message, Method method, Object[] arguments) {
            return message.substring(0, 1).toUpperCase() + message.substring(1);
        }
    }

    public static class RemoveMultiSpacesAndTrim
    implements MethodConverter {
        private static final String REGEX_MULTI_SPACES = "\\s+";
        private static final String SPACE = " ";

        @Override
        public String convert(String message, Method method, Object[] arguments) {
            return message.trim().replaceAll(REGEX_MULTI_SPACES, SPACE);
        }
    }

    public static class ReplaceArguments
    implements MethodConverter {
        private static final String REGEX_VARIABLE = "(\\$\\d+)(.*)";
        private static final String REGEX_VARIABLE_NUMBER = "$1";
        private static final String REGEX_VARIABLE_POST = " $2";
        static final String ARGUMENT_OUT_OF_BOUND = "<out_of_bound_argument>";
        private static final String SPACE = " ";
        static final String FIELD_NOT_FOUND = "<field_not_found>";
        static final String ARGUMENT_NULL = "<empty>";
        static final String COMMA_SEPARATOR = ", ";
        static final String AND_SEPARATOR = " and ";

        @Override
        public String convert(String message, Method method, Object[] arguments) {
            String[] words = message.split(SPACE);
            StringBuffer buffer = new StringBuffer();
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
            for (String word : words) {
                if (word.matches(REGEX_VARIABLE)) {
                    String number = word.replaceAll(REGEX_VARIABLE, REGEX_VARIABLE_NUMBER).substring(1);
                    String post = word.replaceAll(REGEX_VARIABLE, REGEX_VARIABLE_POST);
                    int index = Integer.parseInt(number) - 1;
                    if (index < arguments.length) {
                        Object argument = arguments[index];
                        Tell tell = this.isAnnotationPresent(method, index);
                        word = tell != null ? this.format(tell, argument, dateFormat) + post : this.format(argument, dateFormat) + post;
                    } else {
                        word = ARGUMENT_OUT_OF_BOUND + post;
                    }
                }
                buffer.append(SPACE).append(word);
            }
            return buffer.toString().substring(1);
        }

        private Tell isAnnotationPresent(Method method, int index) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = method.getParameterAnnotations()[index]) {
                if (!(annotation instanceof Tell)) continue;
                return (Tell)annotation;
            }
            return null;
        }

        private String format(Tell tell, Object argument, SimpleDateFormat dateFormat) {
            String result = tell.value();
            Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}");
            Matcher matcher = pattern.matcher(tell.value());
            while (matcher.find()) {
                String fieldName = matcher.group(1);
                try {
                    Field field = argument.getClass().getDeclaredField(fieldName);
                    field.setAccessible(true);
                    String value = this.format(field.get(argument), dateFormat);
                    result = result.replaceAll("\\$\\{" + fieldName + "\\}", value);
                }
                catch (Exception e) {
                    result = result.replaceAll("\\$\\{" + fieldName + "\\}", FIELD_NOT_FOUND);
                }
            }
            return result;
        }

        private String format(Object argument, SimpleDateFormat dateFormat) {
            if (argument == null) {
                return ARGUMENT_NULL;
            }
            if (argument instanceof Date) {
                return dateFormat.format(argument);
            }
            if (argument instanceof String) {
                return "\"" + argument + "\"";
            }
            if (argument instanceof Collection) {
                return this.collectionToString((Collection)argument, dateFormat);
            }
            if (argument.getClass().isArray()) {
                return this.arrayToString(argument, dateFormat);
            }
            return argument.toString();
        }

        private String collectionToString(Collection<?> collection, SimpleDateFormat dateFormat) {
            StringBuilder result = new StringBuilder();
            Iterator<?> iterator = collection.iterator();
            while (iterator.hasNext()) {
                String item = this.format(iterator.next(), dateFormat);
                if (result.length() == 0) {
                    result.append(item);
                    continue;
                }
                if (iterator.hasNext()) {
                    result.append(COMMA_SEPARATOR).append(item);
                    continue;
                }
                result.append(AND_SEPARATOR).append(item);
            }
            return result.toString();
        }

        private String arrayToString(Object array, SimpleDateFormat dateFormat) {
            ArrayList<Object> collection = new ArrayList<Object>();
            for (int i = 0; i < Array.getLength(array); ++i) {
                collection.add(Array.get(array, i));
            }
            return this.collectionToString(collection, dateFormat);
        }
    }

    public static class ReplaceDoubleUnderscoreWithCommaSpace
    implements MethodConverter {
        private static final String REGEX_DOUBLE_UNDER_SCORE = "__";
        private static final String COMMA = ", ";

        @Override
        public String convert(String message, Method method, Object[] arguments) {
            return message.replaceAll(REGEX_DOUBLE_UNDER_SCORE, COMMA);
        }
    }

    public static class ReplaceUnderscoreAndDollarWithSpace
    implements MethodConverter {
        private static final String REGEX_UNDER_SCORE = "_";
        private static final String REGEX_DOLLAR = "\\$";
        private static final String SPACE = " ";

        @Override
        public String convert(String message, Method method, Object[] arguments) {
            return message.replaceAll(REGEX_UNDER_SCORE, SPACE).replaceAll(REGEX_DOLLAR, " \\$");
        }
    }

    public static class ReplaceCamelCaseWithSpace
    implements MethodConverter {
        private static final String REGEX_CAMEL_CASE = "(?<!_)([A-Z])";
        private static final String SPACE = " ";

        @Override
        public String convert(String message, Method method, Object[] arguments) {
            Matcher m = Pattern.compile(REGEX_CAMEL_CASE).matcher(message);
            StringBuffer buffer = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(buffer, SPACE + m.group().toLowerCase());
            }
            m.appendTail(buffer);
            return buffer.toString();
        }
    }

    public static class Global
    implements MethodConverter {
        private static final Logger logger = LoggerFactory.getLogger(Global.class);
        @Inject
        private ReplaceCamelCaseWithSpace camelCase;
        @Inject
        private ReplaceUnderscoreAndDollarWithSpace underscoreAndDollar;
        @Inject
        private ReplaceDoubleUnderscoreWithCommaSpace doubleUnderscore;
        @Inject
        private ReplaceArguments arguments;
        @Inject
        private RemoveMultiSpacesAndTrim multiSpaces;
        @Inject
        private SetFirstLetterUpperCase firstLetterUpperCase;

        @Override
        public String convert(String message, Method method, Object[] args) {
            String convertion = message;
            try {
                convertion = this.camelCase.convert(convertion, method, args);
                convertion = this.doubleUnderscore.convert(convertion, method, args);
                convertion = this.underscoreAndDollar.convert(convertion, method, args);
                convertion = this.arguments.convert(convertion, method, args);
                convertion = this.multiSpaces.convert(convertion, method, args);
                convertion = this.firstLetterUpperCase.convert(convertion, method, args);
            }
            catch (Exception e) {
                logger.error("Impossiple to convert \"" + message + "\" to a message", (Throwable)e);
            }
            return convertion;
        }
    }
}

