/*
 * Decompiled with CFR 0.152.
 */
package io.exemplary.guice;

import com.google.inject.Inject;
import io.exemplary.guice.AbstractTestModule;
import io.exemplary.guice.MethodConverter;
import io.exemplary.guice.Story;
import java.lang.reflect.Method;
import org.slf4j.LoggerFactory;

public abstract class AbstractStoryModule
extends AbstractTestModule {
    protected abstract void configureStory();

    @Override
    protected final void configureTest() {
        this.configureStory();
    }

    protected final void bindStoryPrinter(Class<? extends StoryPrinter> storyPrinter) {
        this.bind(StoryPrinter.class).to(storyPrinter);
    }

    protected final void bindStoryConverter(Class<? extends StoryConverter> storyConverter) {
        this.bind(StoryConverter.class).to(storyConverter);
    }

    public static interface StoryConverter {
        public String convertClass(Class<?> var1);

        public String convertMethod(Method var1, Object[] var2);

        public static class Default
        implements StoryConverter {
            @Inject
            private MethodConverter.Global toMessage;

            @Override
            public String convertClass(Class<?> clazz) {
                return clazz.getSimpleName();
            }

            @Override
            public String convertMethod(Method method, Object[] arguments) {
                String message = this.toMessage(method, arguments);
                Story story = method.getAnnotation(Story.class);
                if (story != null) {
                    message = "Story \"" + message + "\"";
                    if (!story.id().isEmpty()) {
                        message = message + " [" + story.id() + "]";
                    }
                }
                return message;
            }

            protected final String toMessage(Method method, Object[] arguments) {
                return this.toMessage.convert(method.getName(), method, arguments);
            }
        }
    }

    public static interface StoryPrinter {
        public void onStoryBegins(String var1, String var2);

        public void onStepBegins(String var1, String var2);

        public void onStepEnds(String var1, String var2);

        public void onStoryEnds(String var1, String var2);

        public static class Default
        implements StoryPrinter {
            private static final String PREFIX = "story.";
            private static final String SPACE = "  ";
            private static final String TITLE = "TitleSpace";
            private static final String BY = "by ";

            @Override
            public void onStoryBegins(String className, String story) {
                this.log(TITLE, "");
                this.log(className, SPACE + story);
                this.log(className, "  by " + className);
                this.log(TITLE, "");
            }

            @Override
            public void onStepBegins(String className, String step) {
                this.log(className, step);
            }

            @Override
            public void onStepEnds(String className, String step) {
            }

            @Override
            public void onStoryEnds(String className, String story) {
            }

            private void log(String className, String message) {
                LoggerFactory.getLogger((String)(PREFIX + className)).info(message);
            }
        }
    }
}

