/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.driver.requestResponse.schema;

import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.api.requestResponse.schema.CatalogSchemaDecorator;
import io.evitadb.api.requestResponse.schema.CatalogSchemaEditor;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.builder.InternalCatalogSchemaBuilder;
import io.evitadb.api.requestResponse.schema.dto.CatalogSchema;
import io.evitadb.api.requestResponse.schema.dto.EntitySchemaProvider;
import io.evitadb.api.requestResponse.schema.mutation.LocalCatalogSchemaMutation;
import io.evitadb.exception.EvitaInvalidUsageException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;

public class ClientCatalogSchemaDecorator
extends CatalogSchemaDecorator {
    private static final long serialVersionUID = -4594732354632495741L;
    @Nonnull
    private final EntitySchemaProvider entitySchemaAccessor;

    public ClientCatalogSchemaDecorator(@Nonnull CatalogSchema delegate, @Nonnull EntitySchemaProvider entitySchemaAccessor) {
        super(delegate);
        this.entitySchemaAccessor = entitySchemaAccessor;
    }

    @Nonnull
    public CatalogSchemaEditor.CatalogSchemaBuilder openForWrite() {
        return new InternalCatalogSchemaBuilder((CatalogSchemaContract)this);
    }

    @Nonnull
    public CatalogSchemaEditor.CatalogSchemaBuilder openForWriteWithMutations(LocalCatalogSchemaMutation ... schemaMutations) {
        return new InternalCatalogSchemaBuilder((CatalogSchemaContract)this, Arrays.asList(schemaMutations));
    }

    @Nonnull
    public CatalogSchemaEditor.CatalogSchemaBuilder openForWriteWithMutations(@Nonnull Collection<LocalCatalogSchemaMutation> schemaMutations) {
        return new InternalCatalogSchemaBuilder((CatalogSchemaContract)this, schemaMutations);
    }

    @Nonnull
    public Collection<EntitySchemaContract> getEntitySchemas() {
        return this.entitySchemaAccessor.getEntitySchemas();
    }

    @Nonnull
    public Optional<EntitySchemaContract> getEntitySchema(@Nonnull String entityType) {
        return this.entitySchemaAccessor.getEntitySchema(entityType);
    }

    @Nonnull
    public EntitySchemaContract getEntitySchemaOrThrowException(@Nonnull String entityType) {
        return this.getEntitySchema(entityType).orElseThrow(() -> new EvitaInvalidUsageException("Schema for entity with name `" + entityType + "` was not found!"));
    }
}

