/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.driver.interceptor;

import io.evitadb.exception.InvalidEvitaVersionException;
import io.evitadb.utils.VersionUtils;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class ClientSessionInterceptor
implements ClientInterceptor {
    private final String clientId;
    private final VersionUtils.SemVer version;

    public ClientSessionInterceptor(@Nonnull String clientId, @Nullable VersionUtils.SemVer clientVersion) {
        this.clientId = clientId;
        this.version = clientVersion;
    }

    public ClientSessionInterceptor() {
        VersionUtils.SemVer version;
        this.clientId = null;
        try {
            version = VersionUtils.SemVer.fromString((String)VersionUtils.readVersion());
        }
        catch (InvalidEvitaVersionException ignored) {
            version = null;
        }
        this.version = version;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(channel.newCall(methodDescriptor, callOptions)){

            public void start(ClientCall.Listener<RespT> listener, Metadata metadata) {
                String sessionId;
                if (ClientSessionInterceptor.this.clientId != null) {
                    metadata.put(Metadata.Key.of((String)"clientId", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)ClientSessionInterceptor.this.clientId);
                }
                if ((sessionId = SessionIdHolder.getSessionId()) != null) {
                    metadata.put(Metadata.Key.of((String)"sessionId", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)SessionIdHolder.getSessionId());
                }
                if (ClientSessionInterceptor.this.version != null) {
                    metadata.put(Metadata.Key.of((String)"clientVersion", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)ClientSessionInterceptor.this.version.toString());
                }
                super.start(listener, metadata);
            }
        };
    }

    public static class SessionIdHolder {
        private static final ThreadLocal<String> SESSION_DESCRIPTOR = new ThreadLocal();

        public static <T> T executeInSession(@Nonnull String sessionId, @Nonnull Supplier<T> lambda) {
            SessionIdHolder.setSessionId(sessionId);
            try {
                T t = lambda.get();
                return t;
            }
            finally {
                SessionIdHolder.reset();
            }
        }

        public static void executeInSession(@Nonnull String sessionId, @Nonnull Runnable lambda) {
            SessionIdHolder.setSessionId(sessionId);
            try {
                lambda.run();
            }
            finally {
                SessionIdHolder.reset();
            }
        }

        public static void setSessionId(@Nonnull String sessionId) {
            SESSION_DESCRIPTOR.set(sessionId);
        }

        public static void reset() {
            SESSION_DESCRIPTOR.remove();
        }

        public static String getSessionId() {
            return SESSION_DESCRIPTOR.get();
        }

        @Generated
        private SessionIdHolder() {
        }
    }
}

