/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.driver.config;

import io.evitadb.dataType.data.ReflectionCachingBehaviour;
import io.evitadb.externalApi.grpc.certificate.ClientCertificateManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public record EvitaClientConfiguration(@Nonnull String clientId, @Nonnull String host, int port, int systemApiPort, boolean useGeneratedCertificate, boolean trustCertificate, boolean tlsEnabled, boolean mtlsEnabled, @Nullable Path serverCertificatePath, @Nullable Path certificateFileName, @Nullable Path certificateKeyFileName, @Nullable String certificateKeyPassword, @Nullable Path certificateFolderPath, @Nullable String trustStorePassword, @Nonnull ReflectionCachingBehaviour reflectionLookupBehaviour, long timeout, @Nonnull TimeUnit timeoutUnit, @Nullable Object openTelemetryInstance, boolean retry, int trackedTaskLimit) {
    private static final int DEFAULT_PORT = 5555;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated(since="2024.11", forRemoval=true)
    @Nullable
    public Path rootCaCertificatePath() {
        return this.serverCertificatePath;
    }

    public static class Builder {
        private String clientId;
        private String host = "localhost";
        private int port = 5555;
        private int systemApiPort = 5555;
        private boolean useGeneratedCertificate = true;
        private boolean trustCertificate = false;
        private boolean tlsEnabled = true;
        private boolean mtlsEnabled = false;
        private Path serverCertificatePath = null;
        private Path certificatePath = null;
        private Path certificateKeyPath = null;
        private String certificateKeyPassword = null;
        private long timeout = 5L;
        private TimeUnit timeoutUnit = TimeUnit.SECONDS;
        private Path certificateFolderPath = ClientCertificateManager.getDefaultClientCertificateFolderPath();
        private String trustStorePassword = "trustStorePassword";
        private ReflectionCachingBehaviour reflectionCachingBehaviour = ReflectionCachingBehaviour.CACHE;
        @Nullable
        private Object openTelemetryInstance = null;
        private boolean retry = false;
        private int trackedTaskLimit = 100;

        Builder() {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                this.clientId = "gRPC client at " + inetAddress.getHostName();
            }
            catch (UnknownHostException e) {
                this.clientId = "Generic gRPC client";
            }
        }

        @Nonnull
        public Builder clientId(@Nonnull String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Nonnull
        public Builder host(@Nonnull String host) {
            this.host = host;
            return this;
        }

        @Nonnull
        public Builder port(int port) {
            this.port = port;
            return this;
        }

        @Nonnull
        public Builder systemApiPort(int systemApiPort) {
            this.systemApiPort = systemApiPort;
            return this;
        }

        @Nonnull
        public Builder useGeneratedCertificate(boolean useGeneratedCertificate) {
            this.useGeneratedCertificate = useGeneratedCertificate;
            return this;
        }

        @Nonnull
        public Builder trustCertificate(boolean trustCertificate) {
            this.trustCertificate = trustCertificate;
            return this;
        }

        @Deprecated(since="2024.11", forRemoval=true)
        @Nonnull
        public Builder rootCaCertificatePath(@Nonnull Path rootCaCertificatePath) {
            this.serverCertificatePath = rootCaCertificatePath;
            return this;
        }

        @Nonnull
        public Builder serverCertificatePath(@Nonnull Path rootCaCertificatePath) {
            this.serverCertificatePath = rootCaCertificatePath;
            return this;
        }

        @Nonnull
        public Builder reflectionCachingBehaviour(@Nonnull ReflectionCachingBehaviour reflectionCachingBehaviour) {
            this.reflectionCachingBehaviour = reflectionCachingBehaviour;
            return this;
        }

        @Nonnull
        public Builder certificateFolderPath(@Nonnull Path certificateFolderPath) {
            this.certificateFolderPath = certificateFolderPath;
            return this;
        }

        @Deprecated(since="2024.11", forRemoval=true)
        @Nonnull
        public Builder timeoutUnit(long timeout, @Nonnull TimeUnit unit) {
            return this.timeout(timeout, unit);
        }

        @Nonnull
        public Builder timeout(long timeout, @Nonnull TimeUnit unit) {
            this.timeout = timeout;
            this.timeoutUnit = unit;
            return this;
        }

        @Nonnull
        public Builder tlsEnabled(boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
            return this;
        }

        @Nonnull
        public Builder mtlsEnabled(boolean mtlsEnabled) {
            this.mtlsEnabled = mtlsEnabled;
            return this;
        }

        @Nonnull
        public Builder certificateFileName(@Nonnull Path certificateFileName) {
            this.certificatePath = certificateFileName;
            return this;
        }

        @Nonnull
        public Builder certificateKeyFileName(@Nonnull Path certificateKeyFileName) {
            this.certificateKeyPath = certificateKeyFileName;
            return this;
        }

        @Nonnull
        public Builder certificateKeyPassword(@Nonnull String certificateKeyPassword) {
            this.certificateKeyPassword = certificateKeyPassword;
            return this;
        }

        @Nonnull
        public Builder trustStorePassword(@Nonnull String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        @Nonnull
        public Builder openTelemetryInstance(@Nullable Object openTelemetryInstance) {
            this.openTelemetryInstance = openTelemetryInstance;
            return this;
        }

        @Nonnull
        public Builder trackedTaskLimit(int trackedTaskLimit) {
            this.trackedTaskLimit = trackedTaskLimit;
            return this;
        }

        @Nonnull
        public Builder retry(boolean retry) {
            this.retry = retry;
            return this;
        }

        public EvitaClientConfiguration build() {
            return new EvitaClientConfiguration(this.clientId, this.host, this.port, this.systemApiPort, this.useGeneratedCertificate, this.trustCertificate, this.tlsEnabled, this.mtlsEnabled, this.serverCertificatePath, this.certificatePath, this.certificateKeyPath, this.certificateKeyPassword, this.certificateFolderPath, this.trustStorePassword, this.reflectionCachingBehaviour, this.timeout, this.timeoutUnit, this.openTelemetryInstance, this.retry, this.trackedTaskLimit);
        }

        @Generated
        public String toString() {
            return "EvitaClientConfiguration.Builder(clientId=" + this.clientId + ", host=" + this.host + ", port=" + this.port + ", systemApiPort=" + this.systemApiPort + ", useGeneratedCertificate=" + this.useGeneratedCertificate + ", trustCertificate=" + this.trustCertificate + ", tlsEnabled=" + this.tlsEnabled + ", mtlsEnabled=" + this.mtlsEnabled + ", serverCertificatePath=" + String.valueOf(this.serverCertificatePath) + ", certificatePath=" + String.valueOf(this.certificatePath) + ", certificateKeyPath=" + String.valueOf(this.certificateKeyPath) + ", certificateKeyPassword=" + this.certificateKeyPassword + ", timeout=" + this.timeout + ", timeoutUnit=" + String.valueOf((Object)this.timeoutUnit) + ", certificateFolderPath=" + String.valueOf(this.certificateFolderPath) + ", trustStorePassword=" + this.trustStorePassword + ", reflectionCachingBehaviour=" + String.valueOf(this.reflectionCachingBehaviour) + ", openTelemetryInstance=" + String.valueOf(this.openTelemetryInstance) + ", retry=" + this.retry + ", trackedTaskLimit=" + this.trackedTaskLimit + ")";
        }
    }
}

