/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.driver;

import io.evitadb.api.exception.CollectionNotFoundException;
import io.evitadb.api.proxy.ProxyFactory;
import io.evitadb.api.proxy.impl.UnsatisfiedDependencyFactory;
import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaDecorator;
import io.evitadb.api.requestResponse.schema.SealedCatalogSchema;
import io.evitadb.api.requestResponse.schema.SealedEntitySchema;
import io.evitadb.api.requestResponse.schema.dto.CatalogSchema;
import io.evitadb.api.requestResponse.schema.dto.EntitySchema;
import io.evitadb.api.requestResponse.schema.dto.EntitySchemaProvider;
import io.evitadb.api.requestResponse.schema.mutation.CatalogSchemaMutation;
import io.evitadb.api.requestResponse.schema.mutation.SchemaMutation;
import io.evitadb.api.requestResponse.schema.mutation.catalog.ModifyCatalogSchemaMutation;
import io.evitadb.api.requestResponse.schema.mutation.catalog.ModifyEntitySchemaMutation;
import io.evitadb.driver.requestResponse.schema.ClientCatalogSchemaDecorator;
import io.evitadb.utils.Assert;
import io.evitadb.utils.ClassUtils;
import io.evitadb.utils.CollectionUtils;
import io.evitadb.utils.ReflectionLookup;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

class EvitaEntitySchemaCache {
    @Nonnull
    private final String catalogName;
    private final AtomicLong lastKnownCatalogVersion = new AtomicLong(0L);
    private final AtomicInteger lastKnownCatalogSchemaVersion = new AtomicInteger(0);
    private final Map<SchemaCacheKey, SchemaWrapper> cachedSchemas = new ConcurrentHashMap<SchemaCacheKey, SchemaWrapper>(64);
    private final AtomicReference<SchemaIndexWrapper> schemaIndex = new AtomicReference();
    private final AtomicLong lastObsoleteCheck = new AtomicLong();
    private final ProxyFactory proxyFactory;

    public EvitaEntitySchemaCache(@Nonnull String catalogName, @Nonnull ReflectionLookup reflectionLookup) {
        this.catalogName = catalogName;
        this.proxyFactory = (ProxyFactory)ClassUtils.whenPresentOnClasspath((String)"one.edee.oss.proxycian.bytebuddy.ByteBuddyProxyGenerator", () -> (ProxyFactory)Class.forName("io.evitadb.api.proxy.impl.ProxycianFactory").getConstructor(ReflectionLookup.class).newInstance(reflectionLookup)).orElse(UnsatisfiedDependencyFactory.INSTANCE);
    }

    public void updateLastKnownCatalogVersion(long version) {
        this.lastKnownCatalogVersion.set(version);
    }

    public void updateLastKnownCatalogVersion(long version, int catalogSchemaVersion) {
        this.lastKnownCatalogVersion.set(version);
        this.lastKnownCatalogSchemaVersion.set(catalogSchemaVersion);
    }

    public long getLastKnownCatalogVersion() {
        return this.lastKnownCatalogVersion.get();
    }

    public void analyzeMutations(SchemaMutation ... schemaMutation) {
        for (SchemaMutation mutation : schemaMutation) {
            if (mutation instanceof ModifyEntitySchemaMutation) {
                ModifyEntitySchemaMutation entitySchemaMutation = (ModifyEntitySchemaMutation)mutation;
                this.removeLatestEntitySchema(entitySchemaMutation.getEntityType());
                continue;
            }
            if (mutation instanceof ModifyCatalogSchemaMutation) {
                ModifyCatalogSchemaMutation entityRelatedMutation = (ModifyCatalogSchemaMutation)mutation;
                this.analyzeMutations((SchemaMutation[])entityRelatedMutation.getSchemaMutations());
                continue;
            }
            if (!(mutation instanceof CatalogSchemaMutation)) continue;
            this.removeLatestCatalogSchema();
        }
    }

    @Nonnull
    public SealedCatalogSchema getLatestCatalogSchema(@Nonnull Supplier<CatalogSchema> schemaAccessor, @Nonnull EntitySchemaProvider entitySchemaAccessor) {
        long now = System.currentTimeMillis();
        this.executeObsoleteCheck(now);
        SchemaWrapper schemaWrapper = this.cachedSchemas.get(LatestCatalogSchema.INSTANCE);
        if (schemaWrapper == null || schemaWrapper.getCatalogSchema().version() < this.lastKnownCatalogSchemaVersion.get()) {
            CatalogSchema schemaRelevantToSession = schemaAccessor.get();
            SchemaWrapper newCachedValue = new SchemaWrapper(schemaRelevantToSession, now);
            this.setLatestCatalogSchemaInternal(newCachedValue);
            return new ClientCatalogSchemaDecorator(schemaRelevantToSession, entitySchemaAccessor);
        }
        schemaWrapper.used();
        return new ClientCatalogSchemaDecorator(schemaWrapper.getCatalogSchema(), entitySchemaAccessor);
    }

    public void setLatestCatalogSchema(@Nonnull CatalogSchema catalogSchema) {
        this.setLatestCatalogSchemaInternal(new SchemaWrapper(catalogSchema, System.currentTimeMillis()));
    }

    public void removeLatestCatalogSchema() {
        this.schemaIndex.set(null);
        this.cachedSchemas.remove(LatestCatalogSchema.INSTANCE);
    }

    @Nonnull
    public Optional<EntitySchema> getEntitySchema(@Nonnull String entityType, int version, @Nonnull Function<String, Optional<EntitySchema>> schemaAccessor) {
        return this.fetchEntitySchema(new EntitySchemaWithVersion(entityType, version), schemaWrapper -> schemaWrapper == null || schemaWrapper.getEntitySchema().version() != version, schemaAccessor);
    }

    @Nonnull
    public SealedEntitySchema getEntitySchemaOrThrowException(@Nonnull String entityType, int version, @Nonnull Function<String, Optional<EntitySchema>> schemaAccessor, @Nonnull Supplier<CatalogSchemaContract> catalogSchemaSupplier) {
        return (SealedEntitySchema)this.getEntitySchema(entityType, version, schemaAccessor).map(it -> {
            this.getLatestEntitySchema(entityType, schemaAccessor, catalogSchemaSupplier).ifPresent(latestSchema -> {
                if (latestSchema.version() < version) {
                    this.removeLatestEntitySchema(entityType);
                }
            });
            return new EntitySchemaDecorator(catalogSchemaSupplier, it);
        }).orElseThrow(() -> new CollectionNotFoundException(entityType));
    }

    @Nonnull
    public Optional<SealedEntitySchema> getLatestEntitySchema(@Nonnull String entityType, @Nonnull Function<String, Optional<EntitySchema>> schemaAccessor, @Nonnull Supplier<CatalogSchemaContract> catalogSchemaSupplier) {
        return this.fetchEntitySchema(new LatestEntitySchema(entityType), Objects::isNull, schemaAccessor).map(it -> new EntitySchemaDecorator(catalogSchemaSupplier, it));
    }

    public void setLatestEntitySchema(@Nonnull EntitySchema entitySchema) {
        this.setLatestEntitySchemaInternal(new LatestEntitySchema(entitySchema.getName()), new SchemaWrapper(entitySchema, System.currentTimeMillis()));
    }

    public void removeLatestEntitySchema(@Nonnull String entityType) {
        this.schemaIndex.set(null);
        this.cachedSchemas.remove(new LatestEntitySchema(entityType));
    }

    @Nonnull
    public Map<String, EntitySchemaContract> getLatestEntitySchemaIndex(@Nonnull Supplier<Collection<String>> entitySchemaNamesAccessor, @Nonnull Function<String, Optional<EntitySchema>> schemaAccessor, @Nonnull Supplier<CatalogSchemaContract> catalogSchemaSupplier) {
        long now = System.currentTimeMillis();
        this.executeObsoleteCheck(now);
        SchemaIndexWrapper schemaIndexWrapper = this.schemaIndex.get();
        if (schemaIndexWrapper == null || schemaIndexWrapper.isObsolete(now)) {
            Collection<String> entitySchemaNames = entitySchemaNamesAccessor.get();
            HashMap newIndex = CollectionUtils.createHashMap((int)entitySchemaNames.size());
            for (String entitySchemaName : entitySchemaNames) {
                this.getLatestEntitySchema(entitySchemaName, schemaAccessor, catalogSchemaSupplier).ifPresent(it -> newIndex.put(it.getName(), it));
            }
            schemaIndexWrapper = new SchemaIndexWrapper(newIndex, now);
            this.schemaIndex.set(schemaIndexWrapper);
        }
        return schemaIndexWrapper.getIndex();
    }

    @Nonnull
    private Optional<EntitySchema> fetchEntitySchema(@Nonnull EntitySchemaCacheKey cacheKey, @Nonnull Predicate<SchemaWrapper> shouldReFetch, @Nonnull Function<String, Optional<EntitySchema>> schemaAccessor) {
        long now = System.currentTimeMillis();
        this.executeObsoleteCheck(now);
        SchemaWrapper schemaWrapper = this.cachedSchemas.get(cacheKey);
        if (shouldReFetch.test(schemaWrapper)) {
            Optional<EntitySchema> schemaRelevantToSession = schemaAccessor.apply(cacheKey.entityType());
            schemaRelevantToSession.ifPresent(it -> {
                SchemaWrapper newCachedValue = new SchemaWrapper((EntitySchema)it, now);
                this.cachedSchemas.put(new EntitySchemaWithVersion(cacheKey.entityType(), it.version()), newCachedValue);
                this.setLatestEntitySchemaInternal(cacheKey, newCachedValue);
            });
            return schemaRelevantToSession;
        }
        schemaWrapper.used();
        return Optional.of(schemaWrapper.getEntitySchema());
    }

    private void executeObsoleteCheck(long now) {
        long lastCheck = this.lastObsoleteCheck.get();
        if (lastCheck + 60000L < now && this.lastObsoleteCheck.compareAndSet(lastCheck, now)) {
            this.cachedSchemas.values().removeIf(entitySchemaWrapper -> entitySchemaWrapper.isObsolete(now));
        }
    }

    private void setLatestCatalogSchemaInternal(@Nonnull SchemaWrapper newCachedValue) {
        SchemaWrapper previousValue = this.cachedSchemas.putIfAbsent(LatestCatalogSchema.INSTANCE, newCachedValue);
        if (previousValue != null && previousValue.getCatalogSchema().version() < newCachedValue.getCatalogSchema().version()) {
            this.cachedSchemas.put(LatestCatalogSchema.INSTANCE, newCachedValue);
        }
    }

    private void setLatestEntitySchemaInternal(@Nonnull EntitySchemaCacheKey cacheKey, @Nonnull SchemaWrapper newCachedValue) {
        LatestEntitySchema latestEntitySchema = new LatestEntitySchema(cacheKey.entityType());
        SchemaWrapper previousValue = this.cachedSchemas.putIfAbsent(latestEntitySchema, newCachedValue);
        if (previousValue != null && previousValue.getEntitySchema().version() < newCachedValue.getEntitySchema().version()) {
            this.cachedSchemas.put(latestEntitySchema, newCachedValue);
        }
    }

    @Nonnull
    @Generated
    public String getCatalogName() {
        return this.catalogName;
    }

    @Generated
    public ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    record LatestCatalogSchema() implements SchemaCacheKey
    {
        public static final LatestCatalogSchema INSTANCE = new LatestCatalogSchema();
    }

    static class SchemaWrapper {
        private static final long OBSOLETE_INTERVAL = 14400000L;
        @Nullable
        private final CatalogSchema catalogSchema;
        @Nullable
        private final EntitySchema entitySchema;
        private final long fetched;
        private long lastUsed;

        SchemaWrapper(@Nonnull CatalogSchema catalogSchema, long fetched) {
            this.catalogSchema = catalogSchema;
            this.entitySchema = null;
            this.fetched = fetched;
            this.lastUsed = fetched;
        }

        SchemaWrapper(@Nonnull EntitySchema entitySchema, long fetched) {
            this.catalogSchema = null;
            this.entitySchema = entitySchema;
            this.fetched = fetched;
            this.lastUsed = fetched;
        }

        @Nonnull
        public CatalogSchema getCatalogSchema() {
            Assert.isPremiseValid((this.catalogSchema != null ? 1 : 0) != 0, (String)"Catalog schema is not present in the wrapper.");
            return this.catalogSchema;
        }

        @Nonnull
        public EntitySchema getEntitySchema() {
            Assert.isPremiseValid((this.entitySchema != null ? 1 : 0) != 0, (String)"Entity schema is not present in the wrapper.");
            return this.entitySchema;
        }

        void used() {
            this.lastUsed = System.currentTimeMillis();
        }

        boolean isObsolete(long now) {
            return now - 14400000L > this.lastUsed;
        }

        @Generated
        public long getFetched() {
            return this.fetched;
        }
    }

    record EntitySchemaWithVersion(@Nonnull String entityType, int version) implements EntitySchemaCacheKey
    {
    }

    private static interface EntitySchemaCacheKey
    extends SchemaCacheKey {
        @Nonnull
        public String entityType();
    }

    record LatestEntitySchema(@Nonnull String entityType) implements EntitySchemaCacheKey
    {
    }

    static class SchemaIndexWrapper {
        private static final long OBSOLETE_INTERVAL = 1440000L;
        @Nonnull
        private final Map<String, EntitySchemaContract> index;
        private final long fetched;

        SchemaIndexWrapper(@Nonnull Map<String, EntitySchemaContract> index, long fetched) {
            this.index = index;
            this.fetched = fetched;
        }

        boolean isObsolete(long now) {
            return now - 1440000L > this.fetched;
        }

        @Nonnull
        @Generated
        public Map<String, EntitySchemaContract> getIndex() {
            return this.index;
        }

        @Generated
        public long getFetched() {
            return this.fetched;
        }
    }

    private static interface SchemaCacheKey {
    }
}

