/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.driver;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Empty;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.linecorp.armeria.client.grpc.GrpcClientBuilder;
import io.evitadb.api.CatalogState;
import io.evitadb.api.CommitProgress;
import io.evitadb.api.CommitProgressRecord;
import io.evitadb.api.EvitaSessionContract;
import io.evitadb.api.GoLiveProgress;
import io.evitadb.api.GoLiveProgressRecord;
import io.evitadb.api.SchemaPostProcessor;
import io.evitadb.api.SchemaPostProcessorCapturingResult;
import io.evitadb.api.SessionTraits;
import io.evitadb.api.TransactionContract;
import io.evitadb.api.exception.CollectionNotFoundException;
import io.evitadb.api.exception.EntityAlreadyRemovedException;
import io.evitadb.api.exception.EntityClassInvalidException;
import io.evitadb.api.exception.InstanceTerminatedException;
import io.evitadb.api.exception.SchemaAlteringException;
import io.evitadb.api.exception.TemporalDataNotAvailableException;
import io.evitadb.api.exception.TransactionException;
import io.evitadb.api.exception.TransactionNotSupportedException;
import io.evitadb.api.exception.UnexpectedResultCountException;
import io.evitadb.api.exception.UnexpectedResultException;
import io.evitadb.api.exception.UnexpectedTransactionStateException;
import io.evitadb.api.file.FileForFetch;
import io.evitadb.api.proxy.ProxyFactory;
import io.evitadb.api.proxy.SealedEntityProxy;
import io.evitadb.api.proxy.SealedEntityReferenceProxy;
import io.evitadb.api.query.Constraint;
import io.evitadb.api.query.FilterConstraint;
import io.evitadb.api.query.HeadConstraint;
import io.evitadb.api.query.Query;
import io.evitadb.api.query.QueryConstraints;
import io.evitadb.api.query.RequireConstraint;
import io.evitadb.api.query.filter.FilterBy;
import io.evitadb.api.query.order.OrderBy;
import io.evitadb.api.query.require.EntityContentRequire;
import io.evitadb.api.query.require.EntityFetch;
import io.evitadb.api.query.require.Require;
import io.evitadb.api.query.require.SeparateEntityContentRequireContainer;
import io.evitadb.api.query.visitor.FinderVisitor;
import io.evitadb.api.query.visitor.PrettyPrintingVisitor;
import io.evitadb.api.requestResponse.EvitaEntityReferenceResponse;
import io.evitadb.api.requestResponse.EvitaEntityResponse;
import io.evitadb.api.requestResponse.EvitaRequest;
import io.evitadb.api.requestResponse.EvitaResponse;
import io.evitadb.api.requestResponse.EvitaResponseExtraResult;
import io.evitadb.api.requestResponse.cdc.ChangeCatalogCapture;
import io.evitadb.api.requestResponse.cdc.ChangeCatalogCaptureRequest;
import io.evitadb.api.requestResponse.data.DeletedHierarchy;
import io.evitadb.api.requestResponse.data.EntityClassifier;
import io.evitadb.api.requestResponse.data.EntityContract;
import io.evitadb.api.requestResponse.data.EntityEditor;
import io.evitadb.api.requestResponse.data.EntityReferenceContract;
import io.evitadb.api.requestResponse.data.InstanceEditor;
import io.evitadb.api.requestResponse.data.SealedEntity;
import io.evitadb.api.requestResponse.data.mutation.EntityMutation;
import io.evitadb.api.requestResponse.data.mutation.EntityUpsertMutation;
import io.evitadb.api.requestResponse.data.structure.EntityReference;
import io.evitadb.api.requestResponse.data.structure.InitialEntityBuilder;
import io.evitadb.api.requestResponse.schema.CatalogEvolutionMode;
import io.evitadb.api.requestResponse.schema.CatalogSchemaEditor;
import io.evitadb.api.requestResponse.schema.ClassSchemaAnalyzer;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaDecorator;
import io.evitadb.api.requestResponse.schema.EntitySchemaEditor;
import io.evitadb.api.requestResponse.schema.SealedCatalogSchema;
import io.evitadb.api.requestResponse.schema.SealedEntitySchema;
import io.evitadb.api.requestResponse.schema.dto.CatalogSchema;
import io.evitadb.api.requestResponse.schema.dto.EntitySchema;
import io.evitadb.api.requestResponse.schema.dto.EntitySchemaProvider;
import io.evitadb.api.requestResponse.schema.mutation.LocalCatalogSchemaMutation;
import io.evitadb.api.requestResponse.schema.mutation.SchemaMutation;
import io.evitadb.api.requestResponse.schema.mutation.catalog.ModifyEntitySchemaMutation;
import io.evitadb.api.requestResponse.system.CatalogVersion;
import io.evitadb.api.task.Task;
import io.evitadb.dataType.DataChunk;
import io.evitadb.dataType.Scope;
import io.evitadb.driver.AsyncCallFunction;
import io.evitadb.driver.EvitaClient;
import io.evitadb.driver.EvitaClientManagement;
import io.evitadb.driver.EvitaClientTransaction;
import io.evitadb.driver.EvitaEntitySchemaCache;
import io.evitadb.driver.Timeout;
import io.evitadb.driver.exception.EvitaClientServerCallException;
import io.evitadb.driver.exception.EvitaClientTimedOutException;
import io.evitadb.driver.interceptor.ClientSessionInterceptor;
import io.evitadb.driver.requestResponse.schema.ClientCatalogSchemaDecorator;
import io.evitadb.exception.EvitaInvalidUsageException;
import io.evitadb.exception.GenericEvitaInternalError;
import io.evitadb.externalApi.grpc.dataType.EvitaDataTypesConverter;
import io.evitadb.externalApi.grpc.generated.EvitaSessionServiceGrpc;
import io.evitadb.externalApi.grpc.generated.GetMutationsHistoryResponse;
import io.evitadb.externalApi.grpc.generated.GrpcArchiveEntityRequest;
import io.evitadb.externalApi.grpc.generated.GrpcArchiveEntityResponse;
import io.evitadb.externalApi.grpc.generated.GrpcBackupCatalogRequest;
import io.evitadb.externalApi.grpc.generated.GrpcBackupCatalogResponse;
import io.evitadb.externalApi.grpc.generated.GrpcBinaryEntity;
import io.evitadb.externalApi.grpc.generated.GrpcCatalogSchema;
import io.evitadb.externalApi.grpc.generated.GrpcCatalogSchemaResponse;
import io.evitadb.externalApi.grpc.generated.GrpcCatalogVersionAtRequest;
import io.evitadb.externalApi.grpc.generated.GrpcCatalogVersionAtResponse;
import io.evitadb.externalApi.grpc.generated.GrpcCloseRequest;
import io.evitadb.externalApi.grpc.generated.GrpcCloseResponse;
import io.evitadb.externalApi.grpc.generated.GrpcCloseWithProgressRequest;
import io.evitadb.externalApi.grpc.generated.GrpcCloseWithProgressResponse;
import io.evitadb.externalApi.grpc.generated.GrpcDefineEntitySchemaRequest;
import io.evitadb.externalApi.grpc.generated.GrpcDefineEntitySchemaResponse;
import io.evitadb.externalApi.grpc.generated.GrpcDeleteCollectionRequest;
import io.evitadb.externalApi.grpc.generated.GrpcDeleteCollectionResponse;
import io.evitadb.externalApi.grpc.generated.GrpcDeleteEntitiesRequest;
import io.evitadb.externalApi.grpc.generated.GrpcDeleteEntitiesResponse;
import io.evitadb.externalApi.grpc.generated.GrpcDeleteEntityAndItsHierarchyResponse;
import io.evitadb.externalApi.grpc.generated.GrpcDeleteEntityRequest;
import io.evitadb.externalApi.grpc.generated.GrpcDeleteEntityResponse;
import io.evitadb.externalApi.grpc.generated.GrpcEntityCollectionSizeRequest;
import io.evitadb.externalApi.grpc.generated.GrpcEntityCollectionSizeResponse;
import io.evitadb.externalApi.grpc.generated.GrpcEntityMutation;
import io.evitadb.externalApi.grpc.generated.GrpcEntityReference;
import io.evitadb.externalApi.grpc.generated.GrpcEntityRequest;
import io.evitadb.externalApi.grpc.generated.GrpcEntityResponse;
import io.evitadb.externalApi.grpc.generated.GrpcEntitySchema;
import io.evitadb.externalApi.grpc.generated.GrpcEntitySchemaRequest;
import io.evitadb.externalApi.grpc.generated.GrpcEntitySchemaResponse;
import io.evitadb.externalApi.grpc.generated.GrpcEntityTypesResponse;
import io.evitadb.externalApi.grpc.generated.GrpcExtraResults;
import io.evitadb.externalApi.grpc.generated.GrpcFullBackupCatalogResponse;
import io.evitadb.externalApi.grpc.generated.GrpcGetCatalogSchemaRequest;
import io.evitadb.externalApi.grpc.generated.GrpcGoLiveAndCloseWithProgressResponse;
import io.evitadb.externalApi.grpc.generated.GrpcLocalCatalogSchemaMutation;
import io.evitadb.externalApi.grpc.generated.GrpcModifyEntitySchemaMutation;
import io.evitadb.externalApi.grpc.generated.GrpcOffsetDateTime;
import io.evitadb.externalApi.grpc.generated.GrpcQueryListResponse;
import io.evitadb.externalApi.grpc.generated.GrpcQueryOneResponse;
import io.evitadb.externalApi.grpc.generated.GrpcQueryRequest;
import io.evitadb.externalApi.grpc.generated.GrpcQueryResponse;
import io.evitadb.externalApi.grpc.generated.GrpcRenameCollectionRequest;
import io.evitadb.externalApi.grpc.generated.GrpcRenameCollectionResponse;
import io.evitadb.externalApi.grpc.generated.GrpcReplaceCollectionRequest;
import io.evitadb.externalApi.grpc.generated.GrpcReplaceCollectionResponse;
import io.evitadb.externalApi.grpc.generated.GrpcRestoreEntityRequest;
import io.evitadb.externalApi.grpc.generated.GrpcRestoreEntityResponse;
import io.evitadb.externalApi.grpc.generated.GrpcSealedEntity;
import io.evitadb.externalApi.grpc.generated.GrpcTaskStatus;
import io.evitadb.externalApi.grpc.generated.GrpcTransactionPhase;
import io.evitadb.externalApi.grpc.generated.GrpcTransactionResponse;
import io.evitadb.externalApi.grpc.generated.GrpcUpdateAndFetchCatalogSchemaResponse;
import io.evitadb.externalApi.grpc.generated.GrpcUpdateAndFetchEntitySchemaResponse;
import io.evitadb.externalApi.grpc.generated.GrpcUpdateCatalogSchemaRequest;
import io.evitadb.externalApi.grpc.generated.GrpcUpdateCatalogSchemaResponse;
import io.evitadb.externalApi.grpc.generated.GrpcUpdateEntitySchemaRequest;
import io.evitadb.externalApi.grpc.generated.GrpcUpdateEntitySchemaResponse;
import io.evitadb.externalApi.grpc.generated.GrpcUpsertEntityRequest;
import io.evitadb.externalApi.grpc.generated.GrpcUpsertEntityResponse;
import io.evitadb.externalApi.grpc.generated.GrpcUuid;
import io.evitadb.externalApi.grpc.query.QueryConverter;
import io.evitadb.externalApi.grpc.requestResponse.EvitaEnumConverter;
import io.evitadb.externalApi.grpc.requestResponse.ResponseConverter;
import io.evitadb.externalApi.grpc.requestResponse.cdc.ChangeCaptureConverter;
import io.evitadb.externalApi.grpc.requestResponse.data.EntityConverter;
import io.evitadb.externalApi.grpc.requestResponse.data.mutation.DelegatingEntityMutationConverter;
import io.evitadb.externalApi.grpc.requestResponse.schema.CatalogSchemaConverter;
import io.evitadb.externalApi.grpc.requestResponse.schema.EntitySchemaConverter;
import io.evitadb.externalApi.grpc.requestResponse.schema.mutation.DelegatingLocalCatalogSchemaMutationConverter;
import io.evitadb.externalApi.grpc.requestResponse.schema.mutation.catalog.ModifyEntitySchemaMutationConverter;
import io.evitadb.utils.Assert;
import io.evitadb.utils.ReflectionLookup;
import io.grpc.ClientCall;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class EvitaClientSession
implements EvitaSessionContract {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EvitaClientSession.class);
    private static final Scope[] LIVE_SCOPE_ONLY = new Scope[]{Scope.LIVE};
    private final EvitaClient evita;
    private final EvitaClientManagement management;
    private final ReflectionLookup reflectionLookup;
    private final EvitaEntitySchemaCache schemaCache;
    private final EvitaSessionServiceGrpc.EvitaSessionServiceFutureStub evitaSessionServiceFutureStub;
    private final EvitaSessionServiceGrpc.EvitaSessionServiceStub evitaSessionServiceStub;
    private final String catalogName;
    private final CatalogState catalogState;
    private final UUID sessionId;
    private final UUID catalogId;
    private final SessionTraits sessionTraits;
    private final TransactionContract.CommitBehavior commitBehaviour;
    private CommitProgressRecord commitProgress;
    private final Consumer<EvitaClientSession> onTerminationCallback;
    private final AtomicReference<EvitaClientTransaction> transactionAccessor = new AtomicReference();
    private final ProxyFactory proxyFactory;
    private final ClientEntitySchemaAccessor clientEntitySchemaAccessor = new ClientEntitySchemaAccessor();
    private final LinkedList<Timeout> callTimeout = new LinkedList();
    private CompletableFuture<CommitProgress.CommitVersions> closedFuture;
    private long lastCall;

    private static <S extends Serializable> Query assertRequestMakesSenseAndEntityTypeIsPresent(@Nonnull Query query, @Nonnull Class<S> expectedType, @Nonnull ReflectionLookup reflectionLookup) {
        block4: {
            block5: {
                if (!EntityContract.class.isAssignableFrom(expectedType)) break block4;
                if (query.getRequire() == null) break block5;
                if (!FinderVisitor.findConstraints((Constraint)query.getRequire(), EntityFetch.class::isInstance, SeparateEntityContentRequireContainer.class::isInstance).isEmpty()) break block4;
            }
            throw new EvitaInvalidUsageException("Method call expects `" + String.valueOf(expectedType) + "` in result, yet it doesn't define `entityFetch` in the requirements. This would imply that only entity references will be returned by the server!");
        }
        if (query.getCollection() == null) {
            return ClassSchemaAnalyzer.extractEntityTypeFromClass(expectedType, (ReflectionLookup)reflectionLookup).or(() -> Optional.ofNullable(query.getCollection()).map(io.evitadb.api.query.head.Collection::getEntityType)).map(entityType -> Query.query((HeadConstraint)QueryConstraints.collection((String)entityType), (FilterBy)query.getFilterBy(), (OrderBy)query.getOrderBy(), (Require)query.getRequire()).normalizeQuery()).orElseGet(() -> ((Query)query).normalizeQuery());
        }
        return query.normalizeQuery();
    }

    @Nonnull
    private static <T extends Serializable> EntityReference toEntityReference(@Nonnull T entity) {
        EntityReference entityReference;
        if (entity instanceof EntityClassifier) {
            EntityClassifier entityClassifier = (EntityClassifier)entity;
            entityReference = new EntityReference(entityClassifier.getType(), Objects.requireNonNull(entityClassifier.getPrimaryKey()).intValue());
        } else if (entity instanceof SealedEntityProxy) {
            SealedEntityProxy sealedEntityProxy = (SealedEntityProxy)entity;
            entityReference = new EntityReference(sealedEntityProxy.entity().getType(), Objects.requireNonNull(sealedEntityProxy.entity().getPrimaryKey()).intValue());
        } else {
            throw new EvitaInvalidUsageException("Unsupported entity type `" + String.valueOf(entity.getClass()) + "`! The class doesn't implement EntityClassifier nor represents a SealedEntityProxy!", "Unsupported entity type!");
        }
        return entityReference;
    }

    public EvitaClientSession(@Nonnull EvitaClient evita, @Nonnull EvitaClientManagement management, @Nonnull EvitaEntitySchemaCache schemaCache, @Nonnull GrpcClientBuilder grpcClientBuilder, @Nonnull String catalogName, @Nonnull CatalogState catalogState, @Nonnull UUID catalogId, @Nonnull UUID sessionId, @Nonnull TransactionContract.CommitBehavior commitBehaviour, @Nonnull SessionTraits sessionTraits, @Nonnull Consumer<EvitaClientSession> onTerminationCallback, @Nonnull Timeout timeout) {
        this.evita = evita;
        this.management = management;
        this.reflectionLookup = evita.getReflectionLookup();
        this.proxyFactory = schemaCache.getProxyFactory();
        this.schemaCache = schemaCache;
        this.evitaSessionServiceFutureStub = (EvitaSessionServiceGrpc.EvitaSessionServiceFutureStub)grpcClientBuilder.build(EvitaSessionServiceGrpc.EvitaSessionServiceFutureStub.class);
        this.evitaSessionServiceStub = (EvitaSessionServiceGrpc.EvitaSessionServiceStub)grpcClientBuilder.build(EvitaSessionServiceGrpc.EvitaSessionServiceStub.class);
        this.catalogName = catalogName;
        this.catalogState = catalogState;
        this.commitBehaviour = commitBehaviour;
        this.catalogId = catalogId;
        this.sessionId = sessionId;
        this.sessionTraits = sessionTraits;
        this.onTerminationCallback = onTerminationCallback;
        this.callTimeout.add(timeout);
    }

    @Nonnull
    public UUID getId() {
        return this.sessionId;
    }

    @Nonnull
    public UUID getCatalogId() {
        return this.catalogId;
    }

    @Nonnull
    public SealedCatalogSchema getCatalogSchema() {
        this.assertActive();
        return this.schemaCache.getLatestCatalogSchema(this::fetchCatalogSchema, this.clientEntitySchemaAccessor);
    }

    @Nonnull
    public String getCatalogName() {
        return this.catalogName;
    }

    @Nonnull
    public CatalogState getCatalogState() {
        return this.catalogState;
    }

    public long getCatalogVersion() {
        this.assertActive();
        return this.schemaCache.getLastKnownCatalogVersion();
    }

    public boolean isActive() {
        return this.closedFuture == null;
    }

    @Nonnull
    public GoLiveProgress goLiveAndCloseWithProgress(final @Nullable IntConsumer progressObserver) {
        this.assertActive();
        final GoLiveProgressRecord goLiveProgress = new GoLiveProgressRecord(progressObserver);
        this.executeWithAsyncEvitaSessionService(evitaSessionService -> {
            StreamObserver<GrpcGoLiveAndCloseWithProgressResponse> observer = new StreamObserver<GrpcGoLiveAndCloseWithProgressResponse>(){
                private long catalogVersion = -1L;
                private int catalogSchemaVersion = -1;

                public void onNext(GrpcGoLiveAndCloseWithProgressResponse grpcResponse) {
                    goLiveProgress.updatePercentCompleted(grpcResponse.getProgressInPercent());
                    this.catalogVersion = grpcResponse.getCatalogVersion();
                    this.catalogSchemaVersion = grpcResponse.getCatalogSchemaVersion();
                    if (progressObserver != null) {
                        progressObserver.accept(grpcResponse.getProgressInPercent());
                    }
                }

                public void onError(Throwable throwable) {
                    goLiveProgress.completeExceptionally(throwable);
                }

                public void onCompleted() {
                    goLiveProgress.complete(new CommitProgress.CommitVersions(this.catalogVersion, this.catalogSchemaVersion));
                    if (this.catalogVersion > -1L && this.catalogSchemaVersion > -1) {
                        EvitaClientSession.this.schemaCache.updateLastKnownCatalogVersion(this.catalogVersion, this.catalogSchemaVersion);
                    }
                }
            };
            evitaSessionService.goLiveAndCloseWithProgress(Empty.newBuilder().build(), (StreamObserver)observer);
            return null;
        });
        return goLiveProgress;
    }

    @Nonnull
    public CompletionStage<CommitProgress.CommitVersions> closeNow(@Nonnull TransactionContract.CommitBehavior commitBehaviour) {
        if (this.isActive()) {
            final CompletableFuture<CommitProgress.CommitVersions> result = this.closeInternally();
            this.executeWithAsyncEvitaSessionService(evitaSessionService -> {
                StreamObserver<GrpcCloseResponse> observer = new StreamObserver<GrpcCloseResponse>(){

                    public void onNext(GrpcCloseResponse grpcResponse) {
                        result.complete(new CommitProgress.CommitVersions(grpcResponse.getCatalogVersion(), grpcResponse.getCatalogSchemaVersion()));
                        EvitaClientSession.this.schemaCache.updateLastKnownCatalogVersion(grpcResponse.getCatalogVersion(), grpcResponse.getCatalogSchemaVersion());
                    }

                    public void onError(Throwable throwable) {
                        result.completeExceptionally(throwable);
                    }

                    public void onCompleted() {
                    }
                };
                evitaSessionService.close(GrpcCloseRequest.newBuilder().setCatalogName(this.catalogName).setCommitBehaviour(EvitaEnumConverter.toGrpcCommitBehavior((TransactionContract.CommitBehavior)commitBehaviour)).build(), (StreamObserver)observer);
                return null;
            });
        }
        return this.closedFuture;
    }

    @Nonnull
    public CommitProgress closeNowWithProgress() {
        if (this.isActive()) {
            final CompletableFuture<CommitProgress.CommitVersions> result = this.closeInternally();
            this.commitProgress = new CommitProgressRecord();
            this.commitProgress.on(this.commitBehaviour).thenAccept(result::complete);
            this.executeWithAsyncEvitaSessionService(evitaSessionService -> {
                StreamObserver<GrpcCloseWithProgressResponse> observer = new StreamObserver<GrpcCloseWithProgressResponse>(){

                    public void onNext(GrpcCloseWithProgressResponse grpcResponse) {
                        CommitProgress.CommitVersions commitVersions = new CommitProgress.CommitVersions(grpcResponse.getCatalogVersion(), grpcResponse.getCatalogSchemaVersion());
                        GrpcTransactionPhase finishedPhase = grpcResponse.getFinishedPhase();
                        switch (finishedPhase) {
                            case CONFLICTS_RESOLVED: {
                                EvitaClientSession.this.commitProgress.complete(TransactionContract.CommitBehavior.WAIT_FOR_CONFLICT_RESOLUTION, commitVersions);
                                break;
                            }
                            case WAL_PERSISTED: {
                                EvitaClientSession.this.commitProgress.complete(TransactionContract.CommitBehavior.WAIT_FOR_WAL_PERSISTENCE, commitVersions);
                                break;
                            }
                            case CHANGES_VISIBLE: {
                                EvitaClientSession.this.schemaCache.updateLastKnownCatalogVersion(grpcResponse.getCatalogVersion(), grpcResponse.getCatalogSchemaVersion());
                                EvitaClientSession.this.commitProgress.complete(TransactionContract.CommitBehavior.WAIT_FOR_CHANGES_VISIBLE, commitVersions);
                            }
                        }
                    }

                    public void onError(Throwable throwable) {
                        result.completeExceptionally(throwable);
                    }

                    public void onCompleted() {
                    }
                };
                evitaSessionService.closeWithProgress(GrpcCloseWithProgressRequest.newBuilder().setCatalogName(this.catalogName).build(), (StreamObserver)observer);
                return null;
            });
        }
        return this.commitProgress;
    }

    @Nonnull
    public EntitySchemaEditor.EntitySchemaBuilder defineEntitySchema(@Nonnull String entityType) {
        this.assertActive();
        SealedEntitySchema newEntitySchema = (SealedEntitySchema)this.executeInTransactionIfPossible(session -> {
            GrpcDefineEntitySchemaRequest request = GrpcDefineEntitySchemaRequest.newBuilder().setEntityType(entityType).build();
            GrpcDefineEntitySchemaResponse response = (GrpcDefineEntitySchemaResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.defineEntitySchema(request));
            EntitySchema theSchema = EntitySchemaConverter.convert((GrpcEntitySchema)response.getEntitySchema());
            this.schemaCache.setLatestEntitySchema(theSchema);
            return new EntitySchemaDecorator(this::getCatalogSchema, theSchema);
        });
        return newEntitySchema.openForWrite();
    }

    @Nonnull
    public SealedEntitySchema defineEntitySchemaFromModelClass(@Nonnull Class<?> modelClass) {
        this.assertActive();
        return this.executeInTransactionIfPossible(session -> {
            ClassSchemaAnalyzer classSchemaAnalyzer = new ClassSchemaAnalyzer(modelClass, this.reflectionLookup);
            CatalogSchemaEditor.CatalogSchemaBuilder catalogBuilder = session.getCatalogSchema().openForWrite();
            ClassSchemaAnalyzer.AnalysisResult analysisResult = classSchemaAnalyzer.analyze((EvitaSessionContract)this, catalogBuilder);
            this.updateCatalogSchema(analysisResult.mutations());
            return this.getEntitySchemaOrThrowException(analysisResult.entityType());
        });
    }

    @Nonnull
    public SealedEntitySchema defineEntitySchemaFromModelClass(@Nonnull Class<?> modelClass, @Nonnull SchemaPostProcessor postProcessor) {
        this.assertActive();
        return this.executeInTransactionIfPossible(session -> {
            ClassSchemaAnalyzer classSchemaAnalyzer = new ClassSchemaAnalyzer(modelClass, this.reflectionLookup, postProcessor);
            CatalogSchemaEditor.CatalogSchemaBuilder catalogBuilder = session.getCatalogSchema().openForWrite();
            ClassSchemaAnalyzer.AnalysisResult analysisResult = classSchemaAnalyzer.analyze((EvitaSessionContract)this, catalogBuilder);
            if (postProcessor instanceof SchemaPostProcessorCapturingResult) {
                SchemaPostProcessorCapturingResult capturingResult = (SchemaPostProcessorCapturingResult)postProcessor;
                capturingResult.captureResult(analysisResult.mutations());
            }
            this.updateCatalogSchema(analysisResult.mutations());
            return this.getEntitySchemaOrThrowException(analysisResult.entityType());
        });
    }

    @Nonnull
    public Optional<SealedEntitySchema> getEntitySchema(@Nonnull String entityType) {
        this.assertActive();
        return this.schemaCache.getLatestEntitySchema(entityType, this::fetchEntitySchema, this::getCatalogSchema);
    }

    @Nonnull
    public Optional<SealedEntitySchema> getEntitySchema(@Nonnull Class<?> modelClass) throws EntityClassInvalidException {
        return this.getEntitySchema((String)ClassSchemaAnalyzer.extractEntityTypeFromClass(modelClass, (ReflectionLookup)this.reflectionLookup).orElseThrow(() -> new CollectionNotFoundException(modelClass)));
    }

    @Nonnull
    public SealedEntitySchema getEntitySchemaOrThrowException(@Nonnull String entityType) throws CollectionNotFoundException {
        this.assertActive();
        return this.getEntitySchema(entityType).orElseThrow(() -> new CollectionNotFoundException(entityType));
    }

    @Nonnull
    public SealedEntitySchema getEntitySchemaOrThrowException(@Nonnull Class<?> modelClass) throws CollectionNotFoundException, EntityClassInvalidException {
        return this.getEntitySchemaOrThrowException((String)ClassSchemaAnalyzer.extractEntityTypeFromClass(modelClass, (ReflectionLookup)this.reflectionLookup).orElseThrow(() -> new CollectionNotFoundException(modelClass)));
    }

    @Nonnull
    public Set<String> getAllEntityTypes() {
        this.assertActive();
        GrpcEntityTypesResponse grpcResponse = (GrpcEntityTypesResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.getAllEntityTypes(Empty.newBuilder().build()));
        return new LinkedHashSet<String>((Collection<String>)grpcResponse.getEntityTypesList());
    }

    @Nonnull
    public <S extends Serializable> Optional<S> queryOne(@Nonnull Query query, @Nonnull Class<S> expectedType) throws UnexpectedResultException, UnexpectedResultCountException, InstanceTerminatedException {
        EvitaRequest evitaRequest = new EvitaRequest(query, OffsetDateTime.now(), expectedType, (String)ClassSchemaAnalyzer.extractEntityTypeFromClass(expectedType, (ReflectionLookup)this.reflectionLookup).orElse(null));
        return this.queryOneInternal(query, expectedType, evitaRequest, this::createEntityProxy);
    }

    @Nonnull
    public <S extends Serializable> List<S> queryList(@Nonnull Query query, @Nonnull Class<S> expectedType) throws UnexpectedResultException, InstanceTerminatedException {
        EvitaRequest evitaRequest = new EvitaRequest(query, OffsetDateTime.now(), expectedType, (String)ClassSchemaAnalyzer.extractEntityTypeFromClass(expectedType, (ReflectionLookup)this.reflectionLookup).orElse(null));
        return this.queryListInternal(query, expectedType, evitaRequest, this::createEntityProxy);
    }

    @Nonnull
    public <S extends Serializable, T extends EvitaResponse<S>> T query(@Nonnull Query query, @Nonnull Class<S> expectedType) throws UnexpectedResultException, InstanceTerminatedException {
        DataChunk recordPage;
        int[] primaryKeys;
        this.assertActive();
        Query finalQuery = EvitaClientSession.assertRequestMakesSenseAndEntityTypeIsPresent(query, expectedType, this.reflectionLookup);
        PrettyPrintingVisitor.StringWithParameters stringWithParameters = finalQuery.toStringWithParameterExtraction();
        GrpcQueryResponse grpcResponse = (GrpcQueryResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.query(GrpcQueryRequest.newBuilder().setQuery(stringWithParameters.query()).addAllPositionalQueryParams(stringWithParameters.parameters().stream().map(QueryConverter::convertQueryParam).toList()).build()));
        if (EntityReferenceContract.class.isAssignableFrom(expectedType)) {
            int[] primaryKeys2 = grpcResponse.getRecordPage().getEntityReferencesList().stream().mapToInt(GrpcEntityReference::getPrimaryKey).toArray();
            DataChunk recordPage2 = ResponseConverter.convertToDataChunk((GrpcQueryResponse)grpcResponse, grpcRecordPage -> EntityConverter.toEntityReferences((List)grpcRecordPage.getEntityReferencesList()));
            return (T)new EvitaEntityReferenceResponse(finalQuery, recordPage2, primaryKeys2, this.getEvitaResponseExtraResults(grpcResponse, new EvitaRequest(finalQuery, OffsetDateTime.now(), EntityReference.class, null)));
        }
        String expectedEntityType = Optional.ofNullable(finalQuery.getCollection()).map(io.evitadb.api.query.head.Collection::getEntityType).orElse(null);
        if (grpcResponse.getRecordPage().getBinaryEntitiesList().isEmpty()) {
            primaryKeys = grpcResponse.getRecordPage().getSealedEntitiesList().stream().mapToInt(GrpcSealedEntity::getPrimaryKey).toArray();
            recordPage = ResponseConverter.convertToDataChunk((GrpcQueryResponse)grpcResponse, grpcRecordPage -> EntityConverter.toEntities((List)grpcRecordPage.getSealedEntitiesList(), (EvitaRequest)new EvitaRequest(finalQuery, OffsetDateTime.now(), expectedType, expectedEntityType), (entityType, schemaVersion) -> this.schemaCache.getEntitySchemaOrThrowException((String)entityType, (int)schemaVersion, this::fetchEntitySchema, this::getCatalogSchema), (Class)expectedType, this::createEntityProxy));
        } else {
            primaryKeys = grpcResponse.getRecordPage().getBinaryEntitiesList().stream().mapToInt(GrpcBinaryEntity::getPrimaryKey).toArray();
            recordPage = ResponseConverter.convertToDataChunk((GrpcQueryResponse)grpcResponse, grpcRecordPage -> grpcRecordPage.getBinaryEntitiesList().stream().map(EntityConverter::parseBinaryEntity).map(it -> (Serializable)it).toList());
        }
        return (T)new EvitaEntityResponse(finalQuery, recordPage, primaryKeys, this.getEvitaResponseExtraResults(grpcResponse, new EvitaRequest(finalQuery, OffsetDateTime.now(), expectedType, expectedEntityType)));
    }

    @Nonnull
    public Optional<SealedEntity> getEntity(@Nonnull String entityType, int primaryKey, EntityContentRequire ... require) {
        return this.getEntity(entityType, primaryKey, LIVE_SCOPE_ONLY, require);
    }

    @Nonnull
    public Optional<SealedEntity> getEntity(@Nonnull String entityType, int primaryKey, @Nonnull Scope[] scopes, EntityContentRequire ... require) {
        Assert.isTrue((scopes.length > 0 ? 1 : 0) != 0, (String)"At least one scope must be provided!");
        EvitaRequest evitaRequest = new EvitaRequest(Query.query((HeadConstraint)QueryConstraints.collection((String)entityType), (FilterBy)QueryConstraints.filterBy((FilterConstraint[])new FilterConstraint[]{QueryConstraints.entityPrimaryKeyInSet((Integer[])new Integer[]{primaryKey}), QueryConstraints.scope((Scope[])scopes)}), (Require)QueryConstraints.require((RequireConstraint[])new RequireConstraint[]{QueryConstraints.entityFetch((EntityContentRequire[])require)})), OffsetDateTime.now(), SealedEntity.class, null);
        return this.getEntityInternal(entityType, SealedEntity.class, EntityConverter.SEALED_ENTITY_TYPE_CONVERTER, primaryKey, evitaRequest, (RequireConstraint[])require);
    }

    @Nonnull
    public <T extends Serializable> Optional<T> getEntity(@Nonnull Class<T> expectedType, int primaryKey, @Nonnull Scope[] scope, EntityContentRequire ... require) throws EntityClassInvalidException {
        String entityType = (String)ClassSchemaAnalyzer.extractEntityTypeFromClass(expectedType, (ReflectionLookup)this.reflectionLookup).orElseThrow(() -> new CollectionNotFoundException(expectedType));
        EvitaRequest evitaRequest = new EvitaRequest(Query.query((HeadConstraint)QueryConstraints.collection((String)entityType), (FilterBy)QueryConstraints.filterBy((FilterConstraint[])new FilterConstraint[]{QueryConstraints.scope((Scope[])scope)}), (Require)QueryConstraints.require((RequireConstraint[])new RequireConstraint[]{QueryConstraints.entityFetch((EntityContentRequire[])require)})), OffsetDateTime.now(), expectedType, entityType);
        return this.getEntityInternal(entityType, expectedType, this::createEntityProxy, primaryKey, evitaRequest, (RequireConstraint[])require);
    }

    @Nonnull
    public <T extends Serializable> T enrichEntity(@Nonnull T partiallyLoadedEntity, EntityContentRequire ... require) {
        Class clazz;
        this.assertActive();
        EntityReference entityReference = EvitaClientSession.toEntityReference(partiallyLoadedEntity);
        if (partiallyLoadedEntity instanceof SealedEntityProxy) {
            SealedEntityProxy sealedEntityProxy = (SealedEntityProxy)partiallyLoadedEntity;
            clazz = sealedEntityProxy.getProxyClass();
        } else {
            clazz = partiallyLoadedEntity.getClass();
        }
        Class expectedType = clazz;
        EvitaRequest evitaRequest = new EvitaRequest(Query.query((HeadConstraint)QueryConstraints.collection((String)entityReference.type()), (Require)QueryConstraints.require((RequireConstraint[])new RequireConstraint[]{QueryConstraints.entityFetch((EntityContentRequire[])require)})), OffsetDateTime.now(), expectedType, (String)ClassSchemaAnalyzer.extractEntityTypeFromClass((Class)expectedType, (ReflectionLookup)this.reflectionLookup).orElse(null));
        return (T)((Serializable)this.getEntityInternal(entityReference.type(), expectedType, this::createEntityProxy, entityReference.primaryKey(), evitaRequest, (RequireConstraint[])require).orElseThrow(() -> new EntityAlreadyRemovedException(entityReference.type(), entityReference.primaryKey())));
    }

    @Nonnull
    public <T extends Serializable> T enrichOrLimitEntity(@Nonnull T partiallyLoadedEntity, EntityContentRequire ... require) {
        Class clazz;
        this.assertActive();
        EntityReference entityReference = EvitaClientSession.toEntityReference(partiallyLoadedEntity);
        if (partiallyLoadedEntity instanceof SealedEntityProxy) {
            SealedEntityProxy sealedEntityProxy = (SealedEntityProxy)partiallyLoadedEntity;
            clazz = sealedEntityProxy.getProxyClass();
        } else {
            clazz = partiallyLoadedEntity.getClass();
        }
        Class expectedType = clazz;
        EvitaRequest evitaRequest = new EvitaRequest(Query.query((HeadConstraint)QueryConstraints.collection((String)entityReference.type()), (Require)QueryConstraints.require((RequireConstraint[])new RequireConstraint[]{QueryConstraints.entityFetch((EntityContentRequire[])require)})), OffsetDateTime.now(), expectedType, (String)ClassSchemaAnalyzer.extractEntityTypeFromClass((Class)expectedType, (ReflectionLookup)this.reflectionLookup).orElse(null));
        return (T)((Serializable)this.getEntityInternal(entityReference.type(), expectedType, this::createEntityProxy, entityReference.primaryKey(), evitaRequest, (RequireConstraint[])require).orElseThrow(() -> new EntityAlreadyRemovedException(entityReference.type(), entityReference.primaryKey())));
    }

    public int updateCatalogSchema(LocalCatalogSchemaMutation ... schemaMutation) throws SchemaAlteringException {
        this.assertActive();
        return this.executeInTransactionIfPossible(session -> {
            List<GrpcLocalCatalogSchemaMutation> grpcSchemaMutations = Arrays.stream(schemaMutation).map(arg_0 -> ((DelegatingLocalCatalogSchemaMutationConverter)DelegatingLocalCatalogSchemaMutationConverter.INSTANCE).convert(arg_0)).toList();
            GrpcUpdateCatalogSchemaRequest request = GrpcUpdateCatalogSchemaRequest.newBuilder().addAllSchemaMutations(grpcSchemaMutations).build();
            GrpcUpdateCatalogSchemaResponse response = (GrpcUpdateCatalogSchemaResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.updateCatalogSchema(request));
            this.schemaCache.analyzeMutations((SchemaMutation[])schemaMutation);
            return response.getVersion();
        });
    }

    @Nonnull
    public SealedCatalogSchema updateAndFetchCatalogSchema(LocalCatalogSchemaMutation ... schemaMutation) throws SchemaAlteringException {
        this.assertActive();
        return this.executeInTransactionIfPossible(session -> {
            List<GrpcLocalCatalogSchemaMutation> grpcSchemaMutations = Arrays.stream(schemaMutation).map(arg_0 -> ((DelegatingLocalCatalogSchemaMutationConverter)DelegatingLocalCatalogSchemaMutationConverter.INSTANCE).convert(arg_0)).toList();
            GrpcUpdateCatalogSchemaRequest request = GrpcUpdateCatalogSchemaRequest.newBuilder().addAllSchemaMutations(grpcSchemaMutations).build();
            GrpcUpdateAndFetchCatalogSchemaResponse response = (GrpcUpdateAndFetchCatalogSchemaResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.updateAndFetchCatalogSchema(request));
            CatalogSchema updatedCatalogSchema = CatalogSchemaConverter.convert((GrpcCatalogSchema)response.getCatalogSchema(), (EntitySchemaProvider)this.clientEntitySchemaAccessor);
            ClientCatalogSchemaDecorator updatedSchema = new ClientCatalogSchemaDecorator(updatedCatalogSchema, this.clientEntitySchemaAccessor);
            this.schemaCache.analyzeMutations((SchemaMutation[])schemaMutation);
            this.schemaCache.setLatestCatalogSchema(updatedCatalogSchema);
            return updatedSchema;
        });
    }

    public int updateEntitySchema(@Nonnull ModifyEntitySchemaMutation schemaMutation) throws SchemaAlteringException {
        this.assertActive();
        return this.executeInTransactionIfPossible(session -> {
            GrpcModifyEntitySchemaMutation grpcSchemaMutation = ModifyEntitySchemaMutationConverter.INSTANCE.convert(schemaMutation);
            GrpcUpdateEntitySchemaRequest request = GrpcUpdateEntitySchemaRequest.newBuilder().setSchemaMutation(grpcSchemaMutation).build();
            GrpcUpdateEntitySchemaResponse response = (GrpcUpdateEntitySchemaResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.updateEntitySchema(request));
            this.schemaCache.analyzeMutations(new SchemaMutation[]{schemaMutation});
            return response.getVersion();
        });
    }

    @Nonnull
    public SealedEntitySchema updateAndFetchEntitySchema(@Nonnull ModifyEntitySchemaMutation schemaMutation) throws SchemaAlteringException {
        this.assertActive();
        return (SealedEntitySchema)this.executeInTransactionIfPossible(session -> {
            GrpcModifyEntitySchemaMutation grpcSchemaMutation = ModifyEntitySchemaMutationConverter.INSTANCE.convert(schemaMutation);
            GrpcUpdateEntitySchemaRequest request = GrpcUpdateEntitySchemaRequest.newBuilder().setSchemaMutation(grpcSchemaMutation).build();
            GrpcUpdateAndFetchEntitySchemaResponse response = (GrpcUpdateAndFetchEntitySchemaResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.updateAndFetchEntitySchema(request));
            EntitySchema updatedSchema = EntitySchemaConverter.convert((GrpcEntitySchema)response.getEntitySchema());
            this.schemaCache.analyzeMutations(new SchemaMutation[]{schemaMutation});
            this.schemaCache.setLatestEntitySchema(updatedSchema);
            return new EntitySchemaDecorator(this::getCatalogSchema, updatedSchema);
        });
    }

    public boolean deleteCollection(@Nonnull String entityType) {
        this.assertActive();
        return this.executeInTransactionIfPossible(evitaSessionContract -> {
            GrpcDeleteCollectionResponse grpcResponse = (GrpcDeleteCollectionResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.deleteCollection(GrpcDeleteCollectionRequest.newBuilder().setEntityType(entityType).build()));
            this.schemaCache.removeLatestEntitySchema(entityType);
            return grpcResponse.getDeleted();
        });
    }

    public boolean deleteCollection(@Nonnull Class<?> modelClass) throws EntityClassInvalidException {
        return this.deleteCollection((String)ClassSchemaAnalyzer.extractEntityTypeFromClass(modelClass, (ReflectionLookup)this.reflectionLookup).orElseThrow(() -> new CollectionNotFoundException(modelClass)));
    }

    public boolean renameCollection(@Nonnull String entityType, @Nonnull String newName) {
        this.assertActive();
        return this.executeInTransactionIfPossible(evitaSessionContract -> {
            GrpcRenameCollectionResponse grpcResponse = (GrpcRenameCollectionResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.renameCollection(GrpcRenameCollectionRequest.newBuilder().setEntityType(entityType).setNewName(newName).build()));
            this.schemaCache.removeLatestEntitySchema(entityType);
            return grpcResponse.getRenamed();
        });
    }

    public boolean replaceCollection(@Nonnull String entityTypeToBeReplaced, @Nonnull String entityTypeToBeReplacedWith) {
        this.assertActive();
        return this.executeInTransactionIfPossible(evitaSessionContract -> {
            GrpcReplaceCollectionResponse grpcResponse = (GrpcReplaceCollectionResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.replaceCollection(GrpcReplaceCollectionRequest.newBuilder().setEntityTypeToBeReplaced(entityTypeToBeReplaced).setEntityTypeToBeReplacedWith(entityTypeToBeReplacedWith).build()));
            this.schemaCache.removeLatestEntitySchema(entityTypeToBeReplaced);
            this.schemaCache.removeLatestEntitySchema(entityTypeToBeReplacedWith);
            return grpcResponse.getReplaced();
        });
    }

    public int getEntityCollectionSize(@Nonnull String entityType) {
        this.assertActive();
        GrpcEntityCollectionSizeResponse grpcResponse = (GrpcEntityCollectionSizeResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.getEntityCollectionSize(GrpcEntityCollectionSizeRequest.newBuilder().setEntityType(entityType).build()));
        return grpcResponse.getSize();
    }

    @Nonnull
    public EntityEditor.EntityBuilder createNewEntity(@Nonnull String entityType) {
        this.assertActive();
        return (EntityEditor.EntityBuilder)this.executeInTransactionIfPossible(session -> {
            Object entitySchema = this.getCatalogSchema().getCatalogEvolutionMode().contains(CatalogEvolutionMode.ADDING_ENTITY_TYPES) ? this.getEntitySchema(entityType).map(EntitySchemaContract.class::cast).orElseGet(() -> EntitySchema._internalBuild((String)entityType)) : this.getEntitySchemaOrThrowException(entityType);
            return new InitialEntityBuilder((EntitySchemaContract)entitySchema, null);
        });
    }

    @Nonnull
    public <S extends Serializable> S createNewEntity(@Nonnull Class<S> expectedType) {
        this.assertActive();
        EntityEditor.EntityBuilder entityBuilder = this.createNewEntity((String)ClassSchemaAnalyzer.extractEntityTypeFromClass(expectedType, (ReflectionLookup)this.reflectionLookup).orElseThrow(() -> new CollectionNotFoundException(expectedType)));
        return (S)((Serializable)this.proxyFactory.createEntityProxy(expectedType, (EntityContract)entityBuilder, this.getEntitySchemaIndex()));
    }

    @Nonnull
    public EntityEditor.EntityBuilder createNewEntity(@Nonnull String entityType, int primaryKey) {
        this.assertActive();
        return (EntityEditor.EntityBuilder)this.executeInTransactionIfPossible(session -> {
            Object entitySchema = this.getCatalogSchema().getCatalogEvolutionMode().contains(CatalogEvolutionMode.ADDING_ENTITY_TYPES) ? this.getEntitySchema(entityType).map(EntitySchemaContract.class::cast).orElseGet(() -> EntitySchema._internalBuild((String)entityType)) : this.getEntitySchemaOrThrowException(entityType);
            return new InitialEntityBuilder((EntitySchemaContract)entitySchema, Integer.valueOf(primaryKey));
        });
    }

    @Nonnull
    public <S extends Serializable> S createNewEntity(@Nonnull Class<S> expectedType, int primaryKey) {
        this.assertActive();
        EntityEditor.EntityBuilder entityBuilder = this.createNewEntity((String)ClassSchemaAnalyzer.extractEntityTypeFromClass(expectedType, (ReflectionLookup)this.reflectionLookup).orElseThrow(() -> new CollectionNotFoundException(expectedType)), primaryKey);
        return (S)((Serializable)this.proxyFactory.createEntityProxy(expectedType, (EntityContract)entityBuilder, this.getEntitySchemaIndex()));
    }

    @Nonnull
    public <S extends Serializable> EntityReference upsertEntity(@Nonnull S customEntity) {
        InstanceEditor ie;
        if (customEntity instanceof InstanceEditor && EntityContract.class.isAssignableFrom((ie = (InstanceEditor)customEntity).getContract())) {
            return ie.toMutation().map(this::upsertEntity).orElseGet(() -> {
                EntityContract entity = (EntityContract)ie.toInstance();
                return new EntityReference(entity.getType(), Objects.requireNonNull(entity.getPrimaryKey()).intValue());
            });
        }
        if (customEntity instanceof SealedEntityProxy) {
            SealedEntityProxy sealedEntityProxy = (SealedEntityProxy)customEntity;
            return sealedEntityProxy.getEntityBuilderWithCallback().map(entityMutation -> {
                EntityReference entityReference = this.upsertEntity(entityMutation.builder());
                entityMutation.updateEntityReference(entityReference);
                return entityReference;
            }).orElseGet(() -> {
                EntityContract entity = sealedEntityProxy.entity();
                return new EntityReference(entity.getType(), Objects.requireNonNull(entity.getPrimaryKey()).intValue());
            });
        }
        throw new EvitaInvalidUsageException("Method `upsertEntity` expects an instance of InstanceEditor, yet the provided instance is of type `" + String.valueOf(customEntity.getClass()) + "` doesn't implement it!", "Invalid usage of method `upsertEntity`!");
    }

    @Nonnull
    public <S extends Serializable> List<EntityReference> upsertEntityDeeply(@Nonnull S customEntity) {
        if (customEntity instanceof SealedEntityReferenceProxy) {
            SealedEntityReferenceProxy sealedEntityReferenceProxy = (SealedEntityReferenceProxy)customEntity;
            return Stream.concat(sealedEntityReferenceProxy.getReferencedEntityBuildersWithCallback().map(entityBuilderWithCallback -> {
                EntityReference entityReference = this.upsertEntity(entityBuilderWithCallback.builder());
                entityBuilderWithCallback.updateEntityReference(entityReference);
                return entityReference;
            }), sealedEntityReferenceProxy.getReferenceBuilderIfPresent().stream().map(it -> {
                EntityClassifier entityClassifier = sealedEntityReferenceProxy.getEntityClassifier();
                EntityUpsertMutation entityUpsertMutation = new EntityUpsertMutation(entityClassifier.getType(), entityClassifier.getPrimaryKey(), EntityMutation.EntityExistence.MUST_EXIST, (Collection)it.buildChangeSet().collect(Collectors.toList()));
                EntityReference entityReference = this.upsertEntity((EntityMutation)entityUpsertMutation);
                sealedEntityReferenceProxy.notifyBuilderUpserted();
                return entityReference;
            })).toList();
        }
        if (customEntity instanceof SealedEntityProxy) {
            SealedEntityProxy sealedEntityProxy = (SealedEntityProxy)customEntity;
            return Stream.concat(sealedEntityProxy.getReferencedEntityBuildersWithCallback(), sealedEntityProxy.getEntityBuilderWithCallback().stream()).map(entityBuilderWithCallback -> {
                EntityReference entityReference = this.upsertEntity(entityBuilderWithCallback.builder());
                entityBuilderWithCallback.updateEntityReference(entityReference);
                return entityReference;
            }).toList();
        }
        if (customEntity instanceof InstanceEditor) {
            InstanceEditor ie = (InstanceEditor)customEntity;
            return ie.toMutation().map(this::upsertEntity).map(List::of).orElse(Collections.emptyList());
        }
        throw new EvitaInvalidUsageException("Method `upsertEntity` expects an instance of InstanceEditor, yet the provided instance is of type `" + String.valueOf(customEntity.getClass()) + "` doesn't implement it!", "Invalid usage of method `upsertEntity`!");
    }

    @Nonnull
    public EntityReference upsertEntity(@Nonnull EntityMutation entityMutation) {
        this.assertActive();
        return this.executeInTransactionIfPossible(session -> {
            GrpcEntityMutation grpcEntityMutation = DelegatingEntityMutationConverter.INSTANCE.convert(entityMutation);
            GrpcUpsertEntityResponse grpcResult = (GrpcUpsertEntityResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.upsertEntity(GrpcUpsertEntityRequest.newBuilder().setEntityMutation(grpcEntityMutation).build()));
            GrpcEntityReference grpcReference = grpcResult.getEntityReference();
            return new EntityReference(grpcReference.getEntityType(), grpcReference.getPrimaryKey());
        });
    }

    @Nonnull
    public SealedEntity upsertAndFetchEntity(@Nonnull EntityEditor.EntityBuilder entityBuilder, EntityContentRequire ... require) {
        return entityBuilder.toMutation().map(it -> this.upsertAndFetchEntity((EntityMutation)it, require)).orElseGet(() -> this.getEntity(entityBuilder.getType(), (int)Objects.requireNonNull(entityBuilder.getPrimaryKey()), require).orElseThrow(() -> new EvitaInvalidUsageException("Entity `" + entityBuilder.getType() + "` with id `" + entityBuilder.getPrimaryKey() + "` doesn't exist!")));
    }

    @Nonnull
    public SealedEntity upsertAndFetchEntity(@Nonnull EntityMutation entityMutation, EntityContentRequire ... require) {
        this.assertActive();
        return this.executeInTransactionIfPossible(session -> {
            GrpcEntityMutation grpcEntityMutation = DelegatingEntityMutationConverter.INSTANCE.convert(entityMutation);
            PrettyPrintingVisitor.StringWithParameters stringWithParameters = PrettyPrintingVisitor.toStringWithParameterExtraction((Constraint[])require);
            GrpcUpsertEntityResponse grpcResponse = (GrpcUpsertEntityResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.upsertEntity(GrpcUpsertEntityRequest.newBuilder().setEntityMutation(grpcEntityMutation).setRequire(stringWithParameters.query()).addAllPositionalQueryParams(stringWithParameters.parameters().stream().map(QueryConverter::convertQueryParam).toList()).build()));
            return (SealedEntity)EntityConverter.toEntity(entity -> this.schemaCache.getEntitySchemaOrThrowException(entity.getEntityType(), entity.getSchemaVersion(), this::fetchEntitySchema, this::getCatalogSchema), (EvitaRequest)new EvitaRequest(Query.query((HeadConstraint)QueryConstraints.collection((String)entityMutation.getEntityType()), (Require)QueryConstraints.require((RequireConstraint[])new RequireConstraint[]{QueryConstraints.entityFetch((EntityContentRequire[])require)})), OffsetDateTime.now(), SealedEntity.class, null), (GrpcSealedEntity)grpcResponse.getEntity(), SealedEntity.class, (EntityConverter.TypeConverter)EntityConverter.SEALED_ENTITY_TYPE_CONVERTER);
        });
    }

    public boolean deleteEntity(@Nonnull String entityType, int primaryKey) {
        this.assertActive();
        return this.executeInTransactionIfPossible(session -> {
            GrpcDeleteEntityResponse grpcResponse = (GrpcDeleteEntityResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.deleteEntity(GrpcDeleteEntityRequest.newBuilder().setEntityType(entityType).setPrimaryKey(Int32Value.newBuilder().setValue(primaryKey).build()).build()));
            return grpcResponse.hasEntity() || grpcResponse.hasEntityReference();
        });
    }

    public boolean deleteEntity(@Nonnull Class<?> modelClass, int primaryKey) throws EntityClassInvalidException {
        return this.deleteEntity((String)ClassSchemaAnalyzer.extractEntityTypeFromClass(modelClass, (ReflectionLookup)this.reflectionLookup).orElseThrow(() -> new CollectionNotFoundException(modelClass)), primaryKey);
    }

    @Nonnull
    public Optional<SealedEntity> deleteEntity(@Nonnull String entityType, int primaryKey, EntityContentRequire ... require) {
        return this.deleteEntityInternal(entityType, SealedEntity.class, EntityConverter.SEALED_ENTITY_TYPE_CONVERTER, primaryKey, require);
    }

    @Nonnull
    public <T extends Serializable> Optional<T> deleteEntity(@Nonnull Class<T> modelClass, int primaryKey, EntityContentRequire ... require) throws EntityClassInvalidException {
        return this.deleteEntityInternal((String)ClassSchemaAnalyzer.extractEntityTypeFromClass(modelClass, (ReflectionLookup)this.reflectionLookup).orElseThrow(() -> new CollectionNotFoundException(modelClass)), modelClass, this::createEntityProxy, primaryKey, require);
    }

    public int deleteEntityAndItsHierarchy(@Nonnull String entityType, int primaryKey) {
        this.assertActive();
        return this.executeInTransactionIfPossible(session -> {
            GrpcDeleteEntityAndItsHierarchyResponse grpcResponse = (GrpcDeleteEntityAndItsHierarchyResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.deleteEntityAndItsHierarchy(GrpcDeleteEntityRequest.newBuilder().setEntityType(entityType).setPrimaryKey(Int32Value.newBuilder().setValue(primaryKey).build()).build()));
            return grpcResponse.getDeletedEntities();
        });
    }

    @Nonnull
    public DeletedHierarchy<SealedEntity> deleteEntityAndItsHierarchy(@Nonnull String entityType, int primaryKey, EntityContentRequire ... require) {
        return this.deleteEntityHierarchyInternal(entityType, SealedEntity.class, EntityConverter.SEALED_ENTITY_TYPE_CONVERTER, primaryKey, require);
    }

    @Nonnull
    public <T extends Serializable> DeletedHierarchy<T> deleteEntityAndItsHierarchy(@Nonnull Class<T> modelClass, int primaryKey, EntityContentRequire ... require) throws EvitaInvalidUsageException {
        return this.deleteEntityHierarchyInternal((String)ClassSchemaAnalyzer.extractEntityTypeFromClass(modelClass, (ReflectionLookup)this.reflectionLookup).orElseThrow(() -> new CollectionNotFoundException(modelClass)), modelClass, this::createEntityProxy, primaryKey, require);
    }

    public int deleteEntities(@Nonnull Query query) {
        this.assertActive();
        return this.executeInTransactionIfPossible(session -> {
            PrettyPrintingVisitor.StringWithParameters stringWithParameters = query.normalizeQuery().toStringWithParameterExtraction();
            GrpcDeleteEntitiesResponse grpcResponse = (GrpcDeleteEntitiesResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.deleteEntities(GrpcDeleteEntitiesRequest.newBuilder().setQuery(stringWithParameters.query()).addAllPositionalQueryParams(stringWithParameters.parameters().stream().map(QueryConverter::convertQueryParam).toList()).build()));
            return grpcResponse.getDeletedEntities();
        });
    }

    @Nonnull
    public SealedEntity[] deleteSealedEntitiesAndReturnBodies(@Nonnull Query query) {
        this.assertActive();
        return this.executeInTransactionIfPossible(session -> {
            EvitaRequest evitaRequest = new EvitaRequest(query, OffsetDateTime.now(), SealedEntity.class, null);
            PrettyPrintingVisitor.StringWithParameters stringWithParameters = query.normalizeQuery().toStringWithParameterExtraction();
            GrpcDeleteEntitiesResponse grpcResponse = (GrpcDeleteEntitiesResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.deleteEntities(GrpcDeleteEntitiesRequest.newBuilder().setQuery(stringWithParameters.query()).addAllPositionalQueryParams(stringWithParameters.parameters().stream().map(QueryConverter::convertQueryParam).toList()).build()));
            return (SealedEntity[])grpcResponse.getDeletedEntityBodiesList().stream().map(it -> (SealedEntity)EntityConverter.toEntity(entity -> this.schemaCache.getEntitySchemaOrThrowException(entity.getEntityType(), entity.getSchemaVersion(), this::fetchEntitySchema, this::getCatalogSchema), (EvitaRequest)evitaRequest, (GrpcSealedEntity)it, SealedEntity.class, (EntityConverter.TypeConverter)EntityConverter.SEALED_ENTITY_TYPE_CONVERTER)).toArray(SealedEntity[]::new);
        });
    }

    public boolean archiveEntity(@Nonnull String entityType, int primaryKey) {
        this.assertActive();
        return this.executeInTransactionIfPossible(session -> {
            GrpcArchiveEntityResponse grpcResponse = (GrpcArchiveEntityResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.archiveEntity(GrpcArchiveEntityRequest.newBuilder().setEntityType(entityType).setPrimaryKey(Int32Value.newBuilder().setValue(primaryKey).build()).build()));
            return grpcResponse.hasEntity() || grpcResponse.hasEntityReference();
        });
    }

    public boolean archiveEntity(@Nonnull Class<?> modelClass, int primaryKey) throws EntityClassInvalidException {
        return this.archiveEntity((String)ClassSchemaAnalyzer.extractEntityTypeFromClass(modelClass, (ReflectionLookup)this.reflectionLookup).orElseThrow(() -> new CollectionNotFoundException(modelClass)), primaryKey);
    }

    @Nonnull
    public Optional<SealedEntity> archiveEntity(@Nonnull String entityType, int primaryKey, EntityContentRequire ... require) {
        return this.archiveEntityInternal(entityType, SealedEntity.class, EntityConverter.SEALED_ENTITY_TYPE_CONVERTER, primaryKey, require);
    }

    @Nonnull
    public <T extends Serializable> Optional<T> archiveEntity(@Nonnull Class<T> modelClass, int primaryKey, EntityContentRequire ... require) throws EntityClassInvalidException {
        return this.archiveEntityInternal((String)ClassSchemaAnalyzer.extractEntityTypeFromClass(modelClass, (ReflectionLookup)this.reflectionLookup).orElseThrow(() -> new CollectionNotFoundException(modelClass)), modelClass, this::createEntityProxy, primaryKey, require);
    }

    public boolean restoreEntity(@Nonnull String entityType, int primaryKey) {
        this.assertActive();
        return this.executeInTransactionIfPossible(session -> {
            GrpcRestoreEntityResponse grpcResponse = (GrpcRestoreEntityResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.restoreEntity(GrpcRestoreEntityRequest.newBuilder().setEntityType(entityType).setPrimaryKey(Int32Value.newBuilder().setValue(primaryKey).build()).build()));
            return grpcResponse.hasEntity() || grpcResponse.hasEntityReference();
        });
    }

    public boolean restoreEntity(@Nonnull Class<?> modelClass, int primaryKey) throws EntityClassInvalidException {
        return this.restoreEntity((String)ClassSchemaAnalyzer.extractEntityTypeFromClass(modelClass, (ReflectionLookup)this.reflectionLookup).orElseThrow(() -> new CollectionNotFoundException(modelClass)), primaryKey);
    }

    @Nonnull
    public Optional<SealedEntity> restoreEntity(@Nonnull String entityType, int primaryKey, EntityContentRequire ... require) {
        return this.restoreEntityInternal(entityType, SealedEntity.class, EntityConverter.SEALED_ENTITY_TYPE_CONVERTER, primaryKey, require);
    }

    @Nonnull
    public <T extends Serializable> Optional<T> restoreEntity(@Nonnull Class<T> modelClass, int primaryKey, EntityContentRequire ... require) throws EntityClassInvalidException {
        return this.restoreEntityInternal((String)ClassSchemaAnalyzer.extractEntityTypeFromClass(modelClass, (ReflectionLookup)this.reflectionLookup).orElseThrow(() -> new CollectionNotFoundException(modelClass)), modelClass, this::createEntityProxy, primaryKey, require);
    }

    @Nonnull
    public CatalogVersion getCatalogVersionAt(@Nullable OffsetDateTime moment) throws TemporalDataNotAvailableException {
        this.assertActive();
        GrpcCatalogVersionAtResponse grpcResponse = (GrpcCatalogVersionAtResponse)this.executeWithBlockingEvitaSessionService(session -> {
            GrpcCatalogVersionAtRequest.Builder builder = GrpcCatalogVersionAtRequest.newBuilder();
            if (moment != null) {
                builder.setTheMoment(EvitaDataTypesConverter.toGrpcOffsetDateTime((OffsetDateTime)moment));
            }
            return session.getCatalogVersionAt(builder.build());
        });
        return new CatalogVersion(grpcResponse.getVersion(), EvitaDataTypesConverter.toOffsetDateTime((GrpcOffsetDateTime)grpcResponse.getIntroducedAt()));
    }

    @Nonnull
    public Stream<ChangeCatalogCapture> getMutationsHistory(@Nonnull ChangeCatalogCaptureRequest request) {
        this.assertActive();
        MutationsStreamObserver streamObserver = new MutationsStreamObserver();
        AtomicReference callRef = new AtomicReference();
        this.executeWithAsyncEvitaSessionService(session -> {
            ClientCall call = session.getChannel().newCall(EvitaSessionServiceGrpc.getGetMutationsHistoryMethod(), session.getCallOptions());
            callRef.set(call);
            ClientCalls.asyncServerStreamingCall((ClientCall)call, (Object)ChangeCaptureConverter.toGrpcChangeCaptureRequest((ChangeCatalogCaptureRequest)request), (StreamObserver)streamObserver);
            return null;
        });
        return (Stream)StreamSupport.stream(new ChangeCatalogCaptureSpliterator(streamObserver), false).onClose(() -> {
            if (!streamObserver.isCompleted()) {
                ((ClientCall)callRef.get()).cancel("Stream closed by the client", null);
                streamObserver.onCompleted();
            }
        });
    }

    @Nonnull
    public Task<?, FileForFetch> backupCatalog(@Nullable OffsetDateTime pastMoment, @Nullable Long catalogVersion, boolean includingWAL) throws TemporalDataNotAvailableException {
        this.assertActive();
        return this.executeInTransactionIfPossible(session -> {
            GrpcBackupCatalogResponse grpcResponse = (GrpcBackupCatalogResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> {
                GrpcBackupCatalogRequest.Builder builder = GrpcBackupCatalogRequest.newBuilder();
                Optional.ofNullable(pastMoment).ifPresent(pm -> builder.setPastMoment(EvitaDataTypesConverter.toGrpcOffsetDateTime((OffsetDateTime)pm)));
                Optional.ofNullable(catalogVersion).ifPresent(cv -> builder.setCatalogVersion(Int64Value.newBuilder().setValue(cv.longValue()).build()));
                return evitaSessionService.backupCatalog(builder.setIncludingWAL(includingWAL).build());
            });
            return this.management.createTask(EvitaDataTypesConverter.toTaskStatus((GrpcTaskStatus)grpcResponse.getTaskStatus()));
        });
    }

    @Nonnull
    public Task<?, FileForFetch> fullBackupCatalog() {
        this.assertActive();
        return this.executeInTransactionIfPossible(session -> {
            GrpcFullBackupCatalogResponse grpcResponse = (GrpcFullBackupCatalogResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.fullBackupCatalog(Empty.newBuilder().build()));
            return this.management.createTask(EvitaDataTypesConverter.toTaskStatus((GrpcTaskStatus)grpcResponse.getTaskStatus()));
        });
    }

    @Nonnull
    public Optional<UUID> getOpenedTransactionId() {
        this.assertActive();
        return Optional.ofNullable(this.transactionAccessor.get()).filter(EvitaClientTransaction::isClosed).map(EvitaClientTransaction::getTransactionId);
    }

    public boolean isRollbackOnly() {
        return this.getOpenedTransactionId().isPresent() && this.transactionAccessor.get().isRollbackOnly();
    }

    public void setRollbackOnly() {
        this.assertActive();
        if (this.transactionAccessor.get() == null) {
            throw new UnexpectedTransactionStateException("No transaction has been opened!");
        }
        EvitaClientTransaction transaction = this.transactionAccessor.get();
        transaction.setRollbackOnly();
    }

    public boolean isReadOnly() {
        return !this.sessionTraits.isReadWrite();
    }

    @Nonnull
    public TransactionContract.CommitBehavior getCommitBehavior() {
        return this.commitBehaviour;
    }

    public boolean isBinaryFormat() {
        return this.sessionTraits.isBinary();
    }

    public boolean isDryRun() {
        return this.sessionTraits.isDryRun();
    }

    public long getInactivityDurationInSeconds() {
        return (System.currentTimeMillis() - this.lastCall) / 1000L;
    }

    @Nonnull
    public SealedCatalogSchema getCatalogSchema(@Nonnull EvitaClient evita) {
        this.assertActive();
        return this.schemaCache.getLatestCatalogSchema(() -> this.isActive() ? this.fetchCatalogSchema() : evita.queryCatalog(this.catalogName, session -> ((EvitaClientSession)session).fetchCatalogSchema(), new SessionTraits.SessionFlags[0]), this.clientEntitySchemaAccessor);
    }

    @Nonnull
    public CompletableFuture<CommitProgress.CommitVersions> closeInternally() {
        if (this.isActive()) {
            CompletableFuture<CommitProgress.CommitVersions> closeFuture = new CompletableFuture<CommitProgress.CommitVersions>();
            this.closedFuture = closeFuture.whenComplete((newCatalogVersion, throwable) -> {
                Optional.ofNullable(this.onTerminationCallback).ifPresent(it -> it.accept(this));
                if (throwable instanceof CancellationException) {
                    CancellationException cancellationException = (CancellationException)throwable;
                    throw cancellationException;
                }
                if (throwable instanceof TransactionException) {
                    TransactionException transactionException = (TransactionException)throwable;
                    throw transactionException;
                }
                if (throwable != null) {
                    throw new TransactionException("Unexpected exception occurred while executing transaction!", throwable);
                }
            });
            return closeFuture;
        }
        return this.closedFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWithExtendedTimeout(@Nonnull Runnable lambda, long timeout, @Nonnull TimeUnit unit) {
        try {
            this.callTimeout.push(new Timeout(timeout, unit));
            lambda.run();
        }
        finally {
            this.callTimeout.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeWithExtendedTimeout(@Nonnull Supplier<T> lambda, long timeout, @Nonnull TimeUnit unit) {
        try {
            this.callTimeout.push(new Timeout(timeout, unit));
            T t = lambda.get();
            return t;
        }
        finally {
            this.callTimeout.pop();
        }
    }

    @Nonnull
    private <S> S createEntityProxy(@Nonnull Class<S> contract, @Nonnull SealedEntity sealedEntity) {
        return (S)this.proxyFactory.createEntityProxy(contract, (EntityContract)sealedEntity, this.getEntitySchemaIndex());
    }

    @Nonnull
    private Map<String, EntitySchemaContract> getEntitySchemaIndex() {
        return this.schemaCache.getLatestEntitySchemaIndex(this::getAllEntityTypes, this::fetchEntitySchema, this::getCatalogSchema);
    }

    @Nonnull
    private <T> Optional<T> getEntityInternal(@Nonnull String entityType, @Nonnull Class<T> expectedType, @Nonnull EntityConverter.TypeConverter<T> typeConverter, int primaryKey, @Nonnull EvitaRequest evitaRequest, RequireConstraint ... require) {
        GrpcEntityResponse grpcResponse;
        this.assertActive();
        GrpcEntityRequest.Builder requestBuilder = GrpcEntityRequest.newBuilder().setEntityType(entityType).setPrimaryKey(primaryKey).addAllScopes(evitaRequest.getScopes().stream().map(EvitaEnumConverter::toGrpcScope).toList());
        if (require != null) {
            PrettyPrintingVisitor.StringWithParameters stringWithParameters = PrettyPrintingVisitor.toStringWithParameterExtraction((Constraint[])require);
            requestBuilder.setRequire(stringWithParameters.query()).addAllPositionalQueryParams(stringWithParameters.parameters().stream().map(QueryConverter::convertQueryParam).toList());
        }
        return (grpcResponse = (GrpcEntityResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.getEntity(requestBuilder.build()))).hasEntity() ? Optional.of(EntityConverter.toEntity(entity -> this.schemaCache.getEntitySchemaOrThrowException(entity.getEntityType(), entity.getSchemaVersion(), this::fetchEntitySchema, this::getCatalogSchema), (EvitaRequest)evitaRequest, (GrpcSealedEntity)grpcResponse.getEntity(), expectedType, typeConverter)) : Optional.empty();
    }

    @Nonnull
    private <S extends Serializable> List<S> queryListInternal(@Nonnull Query query, @Nonnull Class<S> expectedType, @Nonnull EvitaRequest evitaRequest, @Nonnull EntityConverter.TypeConverter<S> typeConverter) {
        this.assertActive();
        Query finalQuery = EvitaClientSession.assertRequestMakesSenseAndEntityTypeIsPresent(query, expectedType, this.reflectionLookup);
        PrettyPrintingVisitor.StringWithParameters stringWithParameters = finalQuery.toStringWithParameterExtraction();
        GrpcQueryListResponse grpcResponse = (GrpcQueryListResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.queryList(GrpcQueryRequest.newBuilder().setQuery(stringWithParameters.query()).addAllPositionalQueryParams(stringWithParameters.parameters().stream().map(QueryConverter::convertQueryParam).toList()).build()));
        if (EntityReferenceContract.class.isAssignableFrom(expectedType)) {
            List entityReferencesList = grpcResponse.getEntityReferencesList();
            return EntityConverter.toEntityReferences((List)entityReferencesList);
        }
        if (grpcResponse.getBinaryEntitiesList().isEmpty()) {
            return EntityConverter.toEntities((List)grpcResponse.getSealedEntitiesList(), (EvitaRequest)evitaRequest, (entityType, schemaVersion) -> this.schemaCache.getEntitySchemaOrThrowException((String)entityType, (int)schemaVersion, this::fetchEntitySchema, this::getCatalogSchema), expectedType, typeConverter);
        }
        return grpcResponse.getBinaryEntitiesList().stream().map(EntityConverter::parseBinaryEntity).map(it -> (Serializable)it).toList();
    }

    private <T> T executeWithBlockingEvitaSessionService(@Nonnull AsyncCallFunction<EvitaSessionServiceGrpc.EvitaSessionServiceFutureStub, ListenableFuture<T>> lambda) {
        Timeout timeout = this.getCurrentTimeout();
        try {
            ClientSessionInterceptor.SessionIdHolder.setSessionId(this.getId().toString());
            Object object = lambda.apply((EvitaSessionServiceGrpc.EvitaSessionServiceFutureStub)this.evitaSessionServiceFutureStub.withDeadlineAfter(timeout.timeout(), timeout.timeoutUnit())).get(timeout.timeout(), timeout.timeoutUnit());
            return (T)object;
        }
        catch (ExecutionException e) {
            Throwable theException = e.getCause() == null ? e : e.getCause();
            throw EvitaClient.transformException(theException, () -> {
                CompletableFuture<CommitProgress.CommitVersions> future = this.closeInternally();
                future.completeExceptionally(theException);
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new EvitaClientServerCallException("Server call interrupted.", e);
        }
        catch (TimeoutException e) {
            throw new EvitaClientTimedOutException(timeout.timeout(), timeout.timeoutUnit());
        }
        finally {
            ClientSessionInterceptor.SessionIdHolder.reset();
        }
    }

    @Nonnull
    private Timeout getCurrentTimeout() {
        Timeout timeout = this.callTimeout.peek();
        Assert.isPremiseValid((timeout != null ? 1 : 0) != 0, (String)"No timeout has been set for the current call! There should be always a timeout present, this is a bug!");
        return timeout;
    }

    private <T> T executeWithAsyncEvitaSessionService(@Nonnull AsyncCallFunction<EvitaSessionServiceGrpc.EvitaSessionServiceStub, T> lambda) {
        Timeout timeout = this.getCurrentTimeout();
        try {
            ClientSessionInterceptor.SessionIdHolder.setSessionId(this.getId().toString());
            T t = lambda.apply((EvitaSessionServiceGrpc.EvitaSessionServiceStub)this.evitaSessionServiceStub.withDeadlineAfter(timeout.timeout(), timeout.timeoutUnit()));
            return t;
        }
        catch (ExecutionException e) {
            Throwable theException = e.getCause() == null ? e : e.getCause();
            throw EvitaClient.transformException(theException, () -> {
                CompletableFuture<CommitProgress.CommitVersions> future = this.closeInternally();
                future.completeExceptionally(theException);
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new EvitaClientServerCallException("Server call interrupted.", e);
        }
        catch (TimeoutException e) {
            throw new EvitaClientTimedOutException(timeout.timeout(), timeout.timeoutUnit());
        }
        finally {
            ClientSessionInterceptor.SessionIdHolder.reset();
        }
    }

    @Nonnull
    private <S extends Serializable> Optional<S> queryOneInternal(@Nonnull Query query, @Nonnull Class<S> expectedType, @Nonnull EvitaRequest evitaRequest, @Nonnull EntityConverter.TypeConverter<S> typeConverter) {
        this.assertActive();
        Query finalQuery = EvitaClientSession.assertRequestMakesSenseAndEntityTypeIsPresent(query, expectedType, this.reflectionLookup);
        PrettyPrintingVisitor.StringWithParameters stringWithParameters = finalQuery.toStringWithParameterExtraction();
        GrpcQueryOneResponse grpcResponse = (GrpcQueryOneResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.queryOne(GrpcQueryRequest.newBuilder().setQuery(stringWithParameters.query()).addAllPositionalQueryParams(stringWithParameters.parameters().stream().map(QueryConverter::convertQueryParam).toList()).build()));
        if (EntityReferenceContract.class.isAssignableFrom(expectedType)) {
            if (!grpcResponse.hasEntityReference()) {
                return Optional.empty();
            }
            GrpcEntityReference entityReference = grpcResponse.getEntityReference();
            return Optional.of(new EntityReference(entityReference.getEntityType(), entityReference.getPrimaryKey()));
        }
        if (grpcResponse.hasBinaryEntity()) {
            return Optional.of((Serializable)EntityConverter.parseBinaryEntity((GrpcBinaryEntity)grpcResponse.getBinaryEntity()));
        }
        if (!grpcResponse.hasSealedEntity()) {
            return Optional.empty();
        }
        GrpcSealedEntity sealedEntity = grpcResponse.getSealedEntity();
        return Optional.of((Serializable)EntityConverter.toEntity(entity -> this.schemaCache.getEntitySchemaOrThrowException(entity.getEntityType(), entity.getSchemaVersion(), this::fetchEntitySchema, this::getCatalogSchema), (EvitaRequest)evitaRequest, (GrpcSealedEntity)sealedEntity, expectedType, typeConverter));
    }

    @Nonnull
    private <T> Optional<T> deleteEntityInternal(@Nonnull String entityType, @Nonnull Class<T> expectedType, @Nonnull EntityConverter.TypeConverter<T> typeConverter, int primaryKey, @Nonnull EntityContentRequire[] require) {
        this.assertActive();
        return this.executeInTransactionIfPossible(session -> {
            PrettyPrintingVisitor.StringWithParameters stringWithParameters = PrettyPrintingVisitor.toStringWithParameterExtraction((Constraint[])require);
            GrpcDeleteEntityResponse grpcResponse = (GrpcDeleteEntityResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.deleteEntity(GrpcDeleteEntityRequest.newBuilder().setEntityType(entityType).setPrimaryKey(Int32Value.newBuilder().setValue(primaryKey).build()).setRequire(stringWithParameters.query()).addAllPositionalQueryParams(stringWithParameters.parameters().stream().map(QueryConverter::convertQueryParam).toList()).build()));
            return grpcResponse.hasEntity() ? Optional.of(EntityConverter.toEntity(entity -> this.schemaCache.getEntitySchemaOrThrowException(entity.getEntityType(), entity.getSchemaVersion(), this::fetchEntitySchema, this::getCatalogSchema), (EvitaRequest)new EvitaRequest(Query.query((HeadConstraint)QueryConstraints.collection((String)entityType), (Require)QueryConstraints.require((RequireConstraint[])new RequireConstraint[]{QueryConstraints.entityFetch((EntityContentRequire[])require)})), OffsetDateTime.now(), expectedType, (String)ClassSchemaAnalyzer.extractEntityTypeFromClass((Class)expectedType, (ReflectionLookup)this.reflectionLookup).orElse(null)), (GrpcSealedEntity)grpcResponse.getEntity(), (Class)expectedType, (EntityConverter.TypeConverter)typeConverter)) : Optional.empty();
        });
    }

    @Nonnull
    private <T> Optional<T> archiveEntityInternal(@Nonnull String entityType, @Nonnull Class<T> expectedType, @Nonnull EntityConverter.TypeConverter<T> typeConverter, int primaryKey, @Nonnull EntityContentRequire[] require) {
        this.assertActive();
        return this.executeInTransactionIfPossible(session -> {
            PrettyPrintingVisitor.StringWithParameters stringWithParameters = PrettyPrintingVisitor.toStringWithParameterExtraction((Constraint[])require);
            GrpcArchiveEntityResponse grpcResponse = (GrpcArchiveEntityResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.archiveEntity(GrpcArchiveEntityRequest.newBuilder().setEntityType(entityType).setPrimaryKey(Int32Value.newBuilder().setValue(primaryKey).build()).setRequire(stringWithParameters.query()).addAllPositionalQueryParams(stringWithParameters.parameters().stream().map(QueryConverter::convertQueryParam).toList()).build()));
            return grpcResponse.hasEntity() ? Optional.of(EntityConverter.toEntity(entity -> this.schemaCache.getEntitySchemaOrThrowException(entity.getEntityType(), entity.getSchemaVersion(), this::fetchEntitySchema, this::getCatalogSchema), (EvitaRequest)new EvitaRequest(Query.query((HeadConstraint)QueryConstraints.collection((String)entityType), (Require)QueryConstraints.require((RequireConstraint[])new RequireConstraint[]{QueryConstraints.entityFetch((EntityContentRequire[])require)})), OffsetDateTime.now(), expectedType, (String)ClassSchemaAnalyzer.extractEntityTypeFromClass((Class)expectedType, (ReflectionLookup)this.reflectionLookup).orElse(null)), (GrpcSealedEntity)grpcResponse.getEntity(), (Class)expectedType, (EntityConverter.TypeConverter)typeConverter)) : Optional.empty();
        });
    }

    @Nonnull
    private <T> Optional<T> restoreEntityInternal(@Nonnull String entityType, @Nonnull Class<T> expectedType, @Nonnull EntityConverter.TypeConverter<T> typeConverter, int primaryKey, @Nonnull EntityContentRequire[] require) {
        this.assertActive();
        return this.executeInTransactionIfPossible(session -> {
            PrettyPrintingVisitor.StringWithParameters stringWithParameters = PrettyPrintingVisitor.toStringWithParameterExtraction((Constraint[])require);
            GrpcRestoreEntityResponse grpcResponse = (GrpcRestoreEntityResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.restoreEntity(GrpcRestoreEntityRequest.newBuilder().setEntityType(entityType).setPrimaryKey(Int32Value.newBuilder().setValue(primaryKey).build()).setRequire(stringWithParameters.query()).addAllPositionalQueryParams(stringWithParameters.parameters().stream().map(QueryConverter::convertQueryParam).toList()).build()));
            return grpcResponse.hasEntity() ? Optional.of(EntityConverter.toEntity(entity -> this.schemaCache.getEntitySchemaOrThrowException(entity.getEntityType(), entity.getSchemaVersion(), this::fetchEntitySchema, this::getCatalogSchema), (EvitaRequest)new EvitaRequest(Query.query((HeadConstraint)QueryConstraints.collection((String)entityType), (Require)QueryConstraints.require((RequireConstraint[])new RequireConstraint[]{QueryConstraints.entityFetch((EntityContentRequire[])require)})), OffsetDateTime.now(), expectedType, (String)ClassSchemaAnalyzer.extractEntityTypeFromClass((Class)expectedType, (ReflectionLookup)this.reflectionLookup).orElse(null)), (GrpcSealedEntity)grpcResponse.getEntity(), (Class)expectedType, (EntityConverter.TypeConverter)typeConverter)) : Optional.empty();
        });
    }

    @Nonnull
    private <T> DeletedHierarchy<T> deleteEntityHierarchyInternal(@Nonnull String entityType, @Nonnull Class<T> expectedType, @Nonnull EntityConverter.TypeConverter<T> typeConverter, int primaryKey, EntityContentRequire ... require) {
        this.assertActive();
        return this.executeInTransactionIfPossible(session -> {
            PrettyPrintingVisitor.StringWithParameters stringWithParameters = PrettyPrintingVisitor.toStringWithParameterExtraction((Constraint[])require);
            GrpcDeleteEntityAndItsHierarchyResponse grpcResponse = (GrpcDeleteEntityAndItsHierarchyResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.deleteEntityAndItsHierarchy(GrpcDeleteEntityRequest.newBuilder().setEntityType(entityType).setPrimaryKey(Int32Value.newBuilder().setValue(primaryKey).build()).setRequire(stringWithParameters.query()).addAllPositionalQueryParams(stringWithParameters.parameters().stream().map(QueryConverter::convertQueryParam).toList()).build()));
            return new DeletedHierarchy(grpcResponse.getDeletedEntities(), grpcResponse.getDeletedEntityPrimaryKeysList().stream().mapToInt(Integer::intValue).toArray(), grpcResponse.hasDeletedRootEntity() ? EntityConverter.toEntity(entity -> this.schemaCache.getEntitySchemaOrThrowException(entity.getEntityType(), entity.getSchemaVersion(), this::fetchEntitySchema, this::getCatalogSchema), (EvitaRequest)new EvitaRequest(Query.query((HeadConstraint)QueryConstraints.collection((String)entityType), (Require)QueryConstraints.require((RequireConstraint[])new RequireConstraint[]{QueryConstraints.entityFetch((EntityContentRequire[])require)})), OffsetDateTime.now(), expectedType, (String)ClassSchemaAnalyzer.extractEntityTypeFromClass((Class)expectedType, (ReflectionLookup)this.reflectionLookup).orElse(null)), (GrpcSealedEntity)grpcResponse.getDeletedRootEntity(), (Class)expectedType, (EntityConverter.TypeConverter)typeConverter) : null);
        });
    }

    @Nonnull
    private EvitaResponseExtraResult[] getEvitaResponseExtraResults(@Nonnull GrpcQueryResponse grpcResponse, @Nonnull EvitaRequest request) {
        return grpcResponse.hasExtraResults() ? ResponseConverter.toExtraResults(sealedEntity -> this.schemaCache.getEntitySchemaOrThrowException(sealedEntity.getEntityType(), sealedEntity.getSchemaVersion(), this::fetchEntitySchema, this::getCatalogSchema), (EvitaRequest)request, (GrpcExtraResults)grpcResponse.getExtraResults()) : new EvitaResponseExtraResult[]{};
    }

    @Nonnull
    private CatalogSchema fetchCatalogSchema() {
        GrpcCatalogSchemaResponse grpcResponse = (GrpcCatalogSchemaResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.getCatalogSchema(GrpcGetCatalogSchemaRequest.newBuilder().build()));
        return CatalogSchemaConverter.convert((GrpcCatalogSchema)grpcResponse.getCatalogSchema(), (EntitySchemaProvider)this.clientEntitySchemaAccessor);
    }

    @Nonnull
    private Optional<EntitySchema> fetchEntitySchema(@Nonnull String entityType) {
        GrpcEntitySchemaResponse grpcResponse = (GrpcEntitySchemaResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.getEntitySchema(GrpcEntitySchemaRequest.newBuilder().setEntityType(entityType).build()));
        if (!grpcResponse.hasEntitySchema()) {
            return Optional.empty();
        }
        return Optional.of(EntitySchemaConverter.convert((GrpcEntitySchema)grpcResponse.getEntitySchema()));
    }

    private void assertActive() {
        if (!this.isActive()) {
            throw new InstanceTerminatedException("session");
        }
        this.lastCall = System.currentTimeMillis();
    }

    @Nonnull
    private EvitaClientTransaction createAndInitTransaction() {
        if (!this.sessionTraits.isReadWrite()) {
            throw new TransactionNotSupportedException("Transaction cannot be opened in read only session!");
        }
        if (this.getCatalogState() == CatalogState.WARMING_UP) {
            throw new TransactionNotSupportedException("Catalog " + this.getCatalogName() + " doesn't support transaction yet. Call `goLiveAndClose()` method first!");
        }
        GrpcTransactionResponse grpcResponse = (GrpcTransactionResponse)this.executeWithBlockingEvitaSessionService(evitaSessionService -> evitaSessionService.getTransactionId(Empty.newBuilder().build()));
        EvitaClientTransaction tx = new EvitaClientTransaction(EvitaDataTypesConverter.toUuid((GrpcUuid)grpcResponse.getTransactionId()), grpcResponse.getCatalogVersion());
        this.schemaCache.updateLastKnownCatalogVersion(grpcResponse.getCatalogVersion());
        this.transactionAccessor.getAndUpdate(transaction -> {
            Assert.isPremiseValid((transaction == null ? 1 : 0) != 0, (String)"Transaction unexpectedly found!");
            if (this.sessionTraits.isDryRun()) {
                tx.setRollbackOnly();
            }
            return tx;
        });
        return tx;
    }

    private <T> T executeInTransactionIfPossible(Function<EvitaSessionContract, T> logic) {
        if (this.transactionAccessor.get() == null && this.getCatalogState() == CatalogState.ALIVE) {
            T t;
            block10: {
                EvitaClientTransaction newTransaction = this.createAndInitTransaction();
                try {
                    t = logic.apply(this);
                    if (newTransaction == null) break block10;
                    newTransaction.close();
                }
                catch (Throwable ex) {
                    try {
                        Optional.ofNullable(this.transactionAccessor.get()).ifPresent(EvitaClientTransaction::setRollbackOnly);
                        throw ex;
                    }
                    catch (Throwable throwable) {
                        if (newTransaction != null) {
                            try {
                                newTransaction.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
            }
            return t;
        }
        try {
            return logic.apply(this);
        }
        catch (Throwable ex) {
            Optional.ofNullable(this.transactionAccessor.get()).ifPresent(EvitaClientTransaction::setRollbackOnly);
            throw ex;
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EvitaClientSession)) {
            return false;
        }
        EvitaClientSession other = (EvitaClientSession)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$sessionId = this.sessionId;
        UUID other$sessionId = other.sessionId;
        return !(this$sessionId == null ? other$sessionId != null : !((Object)this$sessionId).equals(other$sessionId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EvitaClientSession;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $sessionId = this.sessionId;
        result = result * 59 + ($sessionId == null ? 43 : ((Object)$sessionId).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EvitaClientSession(sessionId=" + String.valueOf(this.sessionId) + ")";
    }

    @Generated
    public EvitaClient getEvita() {
        return this.evita;
    }

    @Generated
    public TransactionContract.CommitBehavior getCommitBehaviour() {
        return this.commitBehaviour;
    }

    @Generated
    public ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    private class ClientEntitySchemaAccessor
    implements EntitySchemaProvider {
        private ClientEntitySchemaAccessor() {
        }

        @Nonnull
        public Collection<EntitySchemaContract> getEntitySchemas() {
            return (EvitaClientSession.this.isActive() ? EvitaClientSession.this.getAllEntityTypes() : EvitaClientSession.this.evita.queryCatalog(EvitaClientSession.this.catalogName, EvitaSessionContract::getAllEntityTypes, new SessionTraits.SessionFlags[0])).stream().map(this::getEntitySchema).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        }

        @Nonnull
        public Optional<EntitySchemaContract> getEntitySchema(@Nonnull String entityType) {
            return (EvitaClientSession.this.isActive() ? EvitaClientSession.this.getEntitySchema(entityType) : EvitaClientSession.this.evita.queryCatalog(EvitaClientSession.this.catalogName, session -> session.getEntitySchema(entityType), new SessionTraits.SessionFlags[0])).map(EntitySchemaContract.class::cast);
        }
    }

    private static class MutationsStreamObserver
    implements StreamObserver<GetMutationsHistoryResponse> {
        private final BlockingQueue<StreamValueWrapper<ChangeCatalogCapture>> queue = new LinkedBlockingQueue<StreamValueWrapper<ChangeCatalogCapture>>();
        private final AtomicBoolean completed = new AtomicBoolean(false);

        private MutationsStreamObserver() {
        }

        public void onNext(GetMutationsHistoryResponse getMutationsHistoryResponse) {
            if (this.completed.get()) {
                throw new CancellationException("Stream has been completed!");
            }
            getMutationsHistoryResponse.getChangeCaptureList().stream().map(ChangeCaptureConverter::toChangeCatalogCapture).forEach(it -> this.queue.add(new StreamValueWrapper<ChangeCatalogCapture>((ChangeCatalogCapture)it)));
        }

        public void onError(Throwable throwable) {
            this.queue.add(new StreamValueWrapper(throwable));
        }

        public void onCompleted() {
            this.queue.add(StreamValueWrapper.streamCompleted());
            this.completed.set(true);
        }

        @Nonnull
        public Optional<ChangeCatalogCapture> take() {
            try {
                StreamValueWrapper<ChangeCatalogCapture> valueWrapper = this.queue.take();
                if (valueWrapper.completed()) {
                    if (valueWrapper.error() != null) {
                        throw new GenericEvitaInternalError("Error while retrieving a mutation stream.", valueWrapper.error());
                    }
                    return Optional.empty();
                }
                return Optional.ofNullable(valueWrapper.value());
            }
            catch (InterruptedException e) {
                return Optional.empty();
            }
        }

        public boolean isCompleted() {
            return this.completed.get();
        }
    }

    private static class ChangeCatalogCaptureSpliterator
    extends Spliterators.AbstractSpliterator<ChangeCatalogCapture> {
        private final MutationsStreamObserver mutationsStreamObserver;

        public ChangeCatalogCaptureSpliterator(@Nonnull MutationsStreamObserver mutationsStreamObserver) {
            super(Long.MAX_VALUE, 16);
            this.mutationsStreamObserver = mutationsStreamObserver;
        }

        @Override
        public boolean tryAdvance(Consumer<? super ChangeCatalogCapture> action) {
            Optional<ChangeCatalogCapture> capture = this.mutationsStreamObserver.take();
            if (capture.isEmpty()) {
                return false;
            }
            action.accept((ChangeCatalogCapture)capture.get());
            return true;
        }
    }

    public record StreamValueWrapper<T>(@Nullable T value, @Nullable Throwable error, boolean completed) {
        public StreamValueWrapper(@Nullable T value) {
            this(value, null, false);
        }

        public StreamValueWrapper(@Nullable Throwable error) {
            this(null, error, true);
        }

        public static <T> StreamValueWrapper<T> streamCompleted() {
            return new StreamValueWrapper<Object>(null, null, true);
        }
    }
}

