/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.driver;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.StringValue;
import com.linecorp.armeria.client.grpc.GrpcClientBuilder;
import io.evitadb.api.CatalogStatistics;
import io.evitadb.api.EvitaManagementContract;
import io.evitadb.api.EvitaSessionContract;
import io.evitadb.api.exception.FileForFetchNotFoundException;
import io.evitadb.api.exception.TemporalDataNotAvailableException;
import io.evitadb.api.file.FileForFetch;
import io.evitadb.api.requestResponse.system.SystemStatus;
import io.evitadb.api.task.Task;
import io.evitadb.api.task.TaskStatus;
import io.evitadb.dataType.PaginatedList;
import io.evitadb.driver.AsyncCallFunction;
import io.evitadb.driver.ClientTask;
import io.evitadb.driver.ClientTaskTracker;
import io.evitadb.driver.EvitaClient;
import io.evitadb.driver.Timeout;
import io.evitadb.driver.exception.EvitaClientServerCallException;
import io.evitadb.driver.exception.EvitaClientTimedOutException;
import io.evitadb.exception.UnexpectedIOException;
import io.evitadb.externalApi.grpc.dataType.EvitaDataTypesConverter;
import io.evitadb.externalApi.grpc.generated.EvitaManagementServiceGrpc;
import io.evitadb.externalApi.grpc.generated.GrpcCancelTaskRequest;
import io.evitadb.externalApi.grpc.generated.GrpcCancelTaskResponse;
import io.evitadb.externalApi.grpc.generated.GrpcDeleteFileToFetchRequest;
import io.evitadb.externalApi.grpc.generated.GrpcDeleteFileToFetchResponse;
import io.evitadb.externalApi.grpc.generated.GrpcEvitaCatalogStatisticsResponse;
import io.evitadb.externalApi.grpc.generated.GrpcEvitaConfigurationResponse;
import io.evitadb.externalApi.grpc.generated.GrpcEvitaServerStatusResponse;
import io.evitadb.externalApi.grpc.generated.GrpcFetchFileRequest;
import io.evitadb.externalApi.grpc.generated.GrpcFetchFileResponse;
import io.evitadb.externalApi.grpc.generated.GrpcFile;
import io.evitadb.externalApi.grpc.generated.GrpcFileToFetchRequest;
import io.evitadb.externalApi.grpc.generated.GrpcFileToFetchResponse;
import io.evitadb.externalApi.grpc.generated.GrpcFilesToFetchRequest;
import io.evitadb.externalApi.grpc.generated.GrpcFilesToFetchResponse;
import io.evitadb.externalApi.grpc.generated.GrpcOffsetDateTime;
import io.evitadb.externalApi.grpc.generated.GrpcRestoreCatalogFromServerFileRequest;
import io.evitadb.externalApi.grpc.generated.GrpcRestoreCatalogRequest;
import io.evitadb.externalApi.grpc.generated.GrpcRestoreCatalogResponse;
import io.evitadb.externalApi.grpc.generated.GrpcSpecifiedTaskStatusesRequest;
import io.evitadb.externalApi.grpc.generated.GrpcSpecifiedTaskStatusesResponse;
import io.evitadb.externalApi.grpc.generated.GrpcTaskStatus;
import io.evitadb.externalApi.grpc.generated.GrpcTaskStatusRequest;
import io.evitadb.externalApi.grpc.generated.GrpcTaskStatusResponse;
import io.evitadb.externalApi.grpc.generated.GrpcTaskStatusesRequest;
import io.evitadb.externalApi.grpc.generated.GrpcTaskStatusesResponse;
import io.evitadb.externalApi.grpc.requestResponse.EvitaEnumConverter;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvitaClientManagement
implements EvitaManagementContract,
Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EvitaClientManagement.class);
    private final EvitaClient evitaClient;
    private final ClientTaskTracker clientTaskTracker;
    private final EvitaManagementServiceGrpc.EvitaManagementServiceStub evitaManagementServiceStub;
    private final EvitaManagementServiceGrpc.EvitaManagementServiceFutureStub evitaManagementServiceFutureStub;

    public EvitaClientManagement(@Nonnull EvitaClient evitaClient, @Nonnull GrpcClientBuilder grpcClientBuilder) {
        this.evitaClient = evitaClient;
        this.clientTaskTracker = new ClientTaskTracker(this, evitaClient.getConfiguration().trackedTaskLimit(), 2000);
        this.evitaManagementServiceStub = (EvitaManagementServiceGrpc.EvitaManagementServiceStub)grpcClientBuilder.build(EvitaManagementServiceGrpc.EvitaManagementServiceStub.class);
        this.evitaManagementServiceFutureStub = (EvitaManagementServiceGrpc.EvitaManagementServiceFutureStub)grpcClientBuilder.build(EvitaManagementServiceGrpc.EvitaManagementServiceFutureStub.class);
    }

    @Nonnull
    public CatalogStatistics[] getCatalogStatistics() {
        this.evitaClient.assertActive();
        GrpcEvitaCatalogStatisticsResponse response = (GrpcEvitaCatalogStatisticsResponse)this.executeWithEvitaService(evitaService -> evitaService.getCatalogStatistics(Empty.newBuilder().build()));
        return (CatalogStatistics[])response.getCatalogStatisticsList().stream().map(EvitaDataTypesConverter::toCatalogStatistics).toArray(CatalogStatistics[]::new);
    }

    @Nonnull
    public CompletableFuture<FileForFetch> backupCatalog(@Nonnull String catalogName, @Nullable OffsetDateTime pastMoment, @Nullable Long catalogVersion, boolean includingWAL) throws TemporalDataNotAvailableException {
        this.evitaClient.assertActive();
        try (EvitaSessionContract session = this.evitaClient.createReadWriteSession(catalogName);){
            Task resultTask = session.backupCatalog(pastMoment, catalogVersion, includingWAL);
            CompletableFuture completableFuture = resultTask.getFutureResult();
            return completableFuture;
        }
    }

    @Nonnull
    public CompletableFuture<FileForFetch> fullBackupCatalog(@Nonnull String catalogName) {
        this.evitaClient.assertActive();
        try (EvitaSessionContract session = this.evitaClient.createReadWriteSession(catalogName);){
            Task resultTask = session.fullBackupCatalog();
            CompletableFuture completableFuture = resultTask.getFutureResult();
            return completableFuture;
        }
    }

    @Nonnull
    public Task<?, Void> restoreCatalog(@Nonnull String catalogName, long totalBytesExpected, @Nonnull InputStream inputStream) throws UnexpectedIOException {
        this.evitaClient.assertActive();
        return this.executeWithEvitaBlockingService(evitaService -> {
            final CompletableFuture result = new CompletableFuture();
            final AtomicLong bytesSent = new AtomicLong(0L);
            final AtomicReference taskStatus = new AtomicReference();
            StreamObserver requestObserver = evitaService.restoreCatalog((StreamObserver)new StreamObserver<GrpcRestoreCatalogResponse>(){
                final AtomicLong bytesReceived = new AtomicLong(0L);

                public void onNext(GrpcRestoreCatalogResponse value) {
                    this.bytesReceived.accumulateAndGet(value.getRead(), Math::max);
                    if (value.hasTask()) {
                        taskStatus.set(EvitaDataTypesConverter.toTaskStatus((GrpcTaskStatus)value.getTask()));
                    }
                }

                public void onError(Throwable t) {
                    log.error("Error occurred during catalog restoration: {}", (Object)t.getMessage(), (Object)t);
                    result.completeExceptionally(t);
                }

                public void onCompleted() {
                    if (bytesSent.get() == this.bytesReceived.get()) {
                        result.complete((TaskStatus)taskStatus.get());
                    } else {
                        result.completeExceptionally((Throwable)new UnexpectedIOException("Number of bytes sent and received during catalog restoration does not match (sent " + bytesSent.get() + ", received " + this.bytesReceived.get() + ")!", "Number of bytes sent and received during catalog restoration does not match!"));
                    }
                }
            });
            ByteBuffer buffer = ByteBuffer.allocate(65536);
            try (InputStream inputStream2 = inputStream;){
                while (inputStream.available() > 0) {
                    int read = inputStream.read(buffer.array());
                    if (read == -1) {
                        requestObserver.onCompleted();
                    }
                    buffer.limit(read);
                    requestObserver.onNext((Object)GrpcRestoreCatalogRequest.newBuilder().setCatalogName(catalogName).setBackupFile(ByteString.copyFrom((ByteBuffer)buffer)).build());
                    buffer.clear();
                    bytesSent.addAndGet(read);
                }
                requestObserver.onCompleted();
            }
            catch (IOException e) {
                requestObserver.onError((Throwable)e);
                throw new RuntimeException(e);
            }
            return this.clientTaskTracker.createTask(Objects.requireNonNull((TaskStatus)result.get()));
        });
    }

    @Nonnull
    public Task<?, Void> restoreCatalog(@Nonnull String catalogName, @Nonnull UUID fileId) throws FileForFetchNotFoundException {
        this.evitaClient.assertActive();
        GrpcRestoreCatalogFromServerFileRequest request = GrpcRestoreCatalogFromServerFileRequest.newBuilder().setFileId(EvitaDataTypesConverter.toGrpcUuid((UUID)fileId)).setCatalogName(catalogName).build();
        GrpcRestoreCatalogResponse response = (GrpcRestoreCatalogResponse)this.executeWithEvitaService(evitaService -> evitaService.restoreCatalogFromServerFile(request));
        return this.clientTaskTracker.createTask(EvitaDataTypesConverter.toTaskStatus((GrpcTaskStatus)response.getTask()));
    }

    @Nonnull
    public PaginatedList<TaskStatus<?, ?>> listTaskStatuses(int page, int pageSize, @Nullable String[] taskType, TaskStatus.TaskSimplifiedState ... states) {
        this.evitaClient.assertActive();
        GrpcTaskStatusesRequest.Builder builder = GrpcTaskStatusesRequest.newBuilder().setPageNumber(page).setPageSize(pageSize);
        if (taskType != null) {
            for (String string : taskType) {
                builder.addTaskType(StringValue.of((String)string));
            }
        }
        for (String string : states) {
            builder.addSimplifiedState(EvitaEnumConverter.toGrpcSimplifiedStatus((TaskStatus.TaskSimplifiedState)string));
        }
        GrpcTaskStatusesRequest request = builder.build();
        GrpcTaskStatusesResponse response = (GrpcTaskStatusesResponse)this.executeWithEvitaService(evitaService -> evitaService.listTaskStatuses(request));
        return new PaginatedList(response.getPageNumber(), response.getPageSize(), response.getTotalNumberOfRecords(), (List)response.getTaskStatusList().stream().map(EvitaDataTypesConverter::toTaskStatus).collect(Collectors.toCollection(ArrayList::new)));
    }

    @Nonnull
    public Optional<TaskStatus<?, ?>> getTaskStatus(@Nonnull UUID jobId) {
        this.evitaClient.assertActive();
        GrpcTaskStatusRequest request = GrpcTaskStatusRequest.newBuilder().setTaskId(EvitaDataTypesConverter.toGrpcUuid((UUID)jobId)).build();
        GrpcTaskStatusResponse response = (GrpcTaskStatusResponse)this.executeWithEvitaService(evitaService -> evitaService.getTaskStatus(request));
        return response.hasTaskStatus() ? Optional.of(EvitaDataTypesConverter.toTaskStatus((GrpcTaskStatus)response.getTaskStatus())) : Optional.empty();
    }

    @Nonnull
    public Collection<TaskStatus<?, ?>> getTaskStatuses(UUID ... jobId) {
        this.evitaClient.assertActive();
        GrpcSpecifiedTaskStatusesRequest.Builder builder = GrpcSpecifiedTaskStatusesRequest.newBuilder();
        for (UUID id : jobId) {
            builder.addTaskIds(EvitaDataTypesConverter.toGrpcUuid((UUID)id));
        }
        GrpcSpecifiedTaskStatusesRequest request = builder.build();
        GrpcSpecifiedTaskStatusesResponse response = (GrpcSpecifiedTaskStatusesResponse)this.executeWithEvitaService(evitaService -> evitaService.getTaskStatuses(request));
        return response.getTaskStatusList().stream().map(EvitaDataTypesConverter::toTaskStatus).collect(Collectors.toCollection(ArrayList::new));
    }

    public boolean cancelTask(@Nonnull UUID jobId) {
        this.evitaClient.assertActive();
        GrpcCancelTaskRequest request = GrpcCancelTaskRequest.newBuilder().setTaskId(EvitaDataTypesConverter.toGrpcUuid((UUID)jobId)).build();
        GrpcCancelTaskResponse response = (GrpcCancelTaskResponse)this.executeWithEvitaService(evitaService -> evitaService.cancelTask(request));
        return response.getSuccess();
    }

    @Nonnull
    public PaginatedList<FileForFetch> listFilesToFetch(int page, int pageSize, @Nonnull Set<String> origin) {
        this.evitaClient.assertActive();
        GrpcFilesToFetchRequest.Builder requestBuilder = GrpcFilesToFetchRequest.newBuilder().setPageNumber(page).setPageSize(pageSize);
        for (String theOrigin : origin) {
            requestBuilder.addOrigin(StringValue.of((String)theOrigin));
        }
        GrpcFilesToFetchResponse response = (GrpcFilesToFetchResponse)this.executeWithEvitaService(evitaService -> evitaService.listFilesToFetch(requestBuilder.build()));
        return new PaginatedList(response.getPageNumber(), response.getPageSize(), response.getTotalNumberOfRecords(), (List)response.getFilesToFetchList().stream().map(EvitaDataTypesConverter::toFileForFetch).collect(Collectors.toCollection(ArrayList::new)));
    }

    @Nonnull
    public Optional<FileForFetch> getFileToFetch(@Nonnull UUID fileId) {
        this.evitaClient.assertActive();
        GrpcFileToFetchRequest request = GrpcFileToFetchRequest.newBuilder().setFileId(EvitaDataTypesConverter.toGrpcUuid((UUID)fileId)).build();
        GrpcFileToFetchResponse response = (GrpcFileToFetchResponse)this.executeWithEvitaService(evitaService -> evitaService.getFileToFetch(request));
        return response.hasFileToFetch() ? Optional.of(EvitaDataTypesConverter.toFileForFetch((GrpcFile)response.getFileToFetch())) : Optional.empty();
    }

    @Nonnull
    public InputStream fetchFile(@Nonnull UUID fileId) throws FileForFetchNotFoundException, UnexpectedIOException {
        this.evitaClient.assertActive();
        try {
            final Path tempFile = Files.createTempFile("downloadedFile", ".tmp", new FileAttribute[0]);
            final CompletableFuture downloadFuture = new CompletableFuture();
            this.executeWithEvitaBlockingService(evitaService -> {
                evitaService.fetchFile(GrpcFetchFileRequest.newBuilder().setFileId(EvitaDataTypesConverter.toGrpcUuid((UUID)fileId)).build(), (StreamObserver)new StreamObserver<GrpcFetchFileResponse>(){

                    public void onNext(GrpcFetchFileResponse response) {
                        try {
                            Files.write(tempFile, response.getFileContents().toByteArray(), StandardOpenOption.APPEND);
                        }
                        catch (IOException e) {
                            this.onError(e);
                        }
                    }

                    public void onError(Throwable t) {
                        downloadFuture.completeExceptionally(t);
                    }

                    public void onCompleted() {
                        downloadFuture.complete(null);
                    }
                });
                return null;
            });
            downloadFuture.join();
            return new FileInputStream(tempFile.toFile()){

                @Override
                public void close() throws IOException {
                    super.close();
                    Files.deleteIfExists(tempFile);
                }
            };
        }
        catch (IOException e) {
            throw new UnexpectedIOException("Failed to create temporary file or write to it: " + e.getMessage(), "Failed to create temporary file or write to it", (Throwable)e);
        }
    }

    public void deleteFile(@Nonnull UUID fileId) throws FileForFetchNotFoundException {
        this.evitaClient.assertActive();
        GrpcDeleteFileToFetchRequest request = GrpcDeleteFileToFetchRequest.newBuilder().setFileId(EvitaDataTypesConverter.toGrpcUuid((UUID)fileId)).build();
        GrpcDeleteFileToFetchResponse response = (GrpcDeleteFileToFetchResponse)this.executeWithEvitaService(evitaService -> evitaService.deleteFile(request));
        if (!response.getSuccess()) {
            throw new FileForFetchNotFoundException(fileId);
        }
    }

    @Nonnull
    public SystemStatus getSystemStatus() {
        this.evitaClient.assertActive();
        GrpcEvitaServerStatusResponse response = (GrpcEvitaServerStatusResponse)this.executeWithEvitaService(evitaService -> evitaService.serverStatus(Empty.newBuilder().build()));
        return new SystemStatus(response.getVersion(), EvitaDataTypesConverter.toOffsetDateTime((GrpcOffsetDateTime)response.getStartedAt()), Duration.of(response.getUptime(), ChronoUnit.SECONDS), response.getInstanceId(), response.getCatalogsCorrupted(), response.getCatalogsOk());
    }

    @Nonnull
    public String getConfiguration() {
        this.evitaClient.assertActive();
        GrpcEvitaConfigurationResponse response = (GrpcEvitaConfigurationResponse)this.executeWithEvitaService(evitaService -> evitaService.getConfiguration(Empty.newBuilder().build()));
        return response.getConfiguration();
    }

    @Override
    public void close() {
        this.clientTaskTracker.close();
    }

    @Nonnull
    public <S, T> ClientTask<S, T> createTask(@Nonnull TaskStatus<S, T> taskStatus) {
        return this.clientTaskTracker.createTask(taskStatus);
    }

    private <T> T executeWithEvitaBlockingService(@Nonnull AsyncCallFunction<EvitaManagementServiceGrpc.EvitaManagementServiceStub, T> lambda) {
        Timeout timeout = this.evitaClient.timeout.get().peek();
        try {
            return lambda.apply((EvitaManagementServiceGrpc.EvitaManagementServiceStub)this.evitaManagementServiceStub.withDeadlineAfter(timeout.timeout(), timeout.timeoutUnit()));
        }
        catch (ExecutionException e) {
            throw EvitaClient.transformException(e.getCause() == null ? e : e.getCause(), () -> {});
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new EvitaClientServerCallException("Server call interrupted.", e);
        }
        catch (TimeoutException e) {
            throw new EvitaClientTimedOutException(timeout.timeout(), timeout.timeoutUnit());
        }
    }

    private <T> T executeWithEvitaService(@Nonnull AsyncCallFunction<EvitaManagementServiceGrpc.EvitaManagementServiceFutureStub, ListenableFuture<T>> lambda) {
        Timeout timeout = this.evitaClient.timeout.get().peek();
        try {
            return (T)lambda.apply((EvitaManagementServiceGrpc.EvitaManagementServiceFutureStub)this.evitaManagementServiceFutureStub.withDeadlineAfter(timeout.timeout(), timeout.timeoutUnit())).get(timeout.timeout(), timeout.timeoutUnit());
        }
        catch (ExecutionException e) {
            throw EvitaClient.transformException(e.getCause() == null ? e : e.getCause(), () -> {});
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new EvitaClientServerCallException("Server call interrupted.", e);
        }
        catch (TimeoutException e) {
            throw new EvitaClientTimedOutException(timeout.timeout(), timeout.timeoutUnit());
        }
    }
}

