/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.driver;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Empty;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientFactoryBuilder;
import com.linecorp.armeria.client.grpc.GrpcClientBuilder;
import com.linecorp.armeria.client.grpc.GrpcClients;
import com.linecorp.armeria.client.retry.RetryRule;
import com.linecorp.armeria.client.retry.RetryRuleBuilder;
import com.linecorp.armeria.client.retry.RetryingClient;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.grpc.GrpcSerializationFormats;
import io.evitadb.api.CatalogState;
import io.evitadb.api.CommitProgress;
import io.evitadb.api.EvitaContract;
import io.evitadb.api.EvitaManagementContract;
import io.evitadb.api.EvitaSessionContract;
import io.evitadb.api.SessionTraits;
import io.evitadb.api.TransactionContract;
import io.evitadb.api.exception.InstanceTerminatedException;
import io.evitadb.api.exception.TransactionException;
import io.evitadb.api.requestResponse.schema.CatalogSchemaEditor;
import io.evitadb.api.requestResponse.schema.mutation.TopLevelCatalogSchemaMutation;
import io.evitadb.api.requestResponse.schema.mutation.catalog.CreateCatalogSchemaMutation;
import io.evitadb.api.requestResponse.system.SystemStatus;
import io.evitadb.driver.AsyncCallFunction;
import io.evitadb.driver.EvitaClientManagement;
import io.evitadb.driver.EvitaClientSession;
import io.evitadb.driver.EvitaEntitySchemaCache;
import io.evitadb.driver.Timeout;
import io.evitadb.driver.config.EvitaClientConfiguration;
import io.evitadb.driver.exception.EvitaClientServerCallException;
import io.evitadb.driver.exception.EvitaClientTimedOutException;
import io.evitadb.driver.exception.IncompatibleClientException;
import io.evitadb.driver.interceptor.ClientSessionInterceptor;
import io.evitadb.driver.trace.ClientTracingContext;
import io.evitadb.driver.trace.ClientTracingContextProvider;
import io.evitadb.driver.trace.DefaultClientTracingContext;
import io.evitadb.exception.EvitaInternalError;
import io.evitadb.exception.EvitaInvalidUsageException;
import io.evitadb.exception.GenericEvitaInternalError;
import io.evitadb.exception.InvalidEvitaVersionException;
import io.evitadb.externalApi.grpc.certificate.ClientCertificateManager;
import io.evitadb.externalApi.grpc.generated.EvitaServiceGrpc;
import io.evitadb.externalApi.grpc.generated.GrpcCatalogNamesResponse;
import io.evitadb.externalApi.grpc.generated.GrpcCatalogState;
import io.evitadb.externalApi.grpc.generated.GrpcCommitBehavior;
import io.evitadb.externalApi.grpc.generated.GrpcDeleteCatalogIfExistsRequest;
import io.evitadb.externalApi.grpc.generated.GrpcDeleteCatalogIfExistsResponse;
import io.evitadb.externalApi.grpc.generated.GrpcEvitaSessionRequest;
import io.evitadb.externalApi.grpc.generated.GrpcEvitaSessionResponse;
import io.evitadb.externalApi.grpc.generated.GrpcGetCatalogStateRequest;
import io.evitadb.externalApi.grpc.generated.GrpcGetCatalogStateResponse;
import io.evitadb.externalApi.grpc.generated.GrpcRenameCatalogRequest;
import io.evitadb.externalApi.grpc.generated.GrpcRenameCatalogResponse;
import io.evitadb.externalApi.grpc.generated.GrpcReplaceCatalogRequest;
import io.evitadb.externalApi.grpc.generated.GrpcReplaceCatalogResponse;
import io.evitadb.externalApi.grpc.generated.GrpcTopLevelCatalogSchemaMutation;
import io.evitadb.externalApi.grpc.generated.GrpcUpdateEvitaRequest;
import io.evitadb.externalApi.grpc.requestResponse.EvitaEnumConverter;
import io.evitadb.externalApi.grpc.requestResponse.schema.mutation.DelegatingTopLevelCatalogSchemaMutationConverter;
import io.evitadb.utils.ArrayUtils;
import io.evitadb.utils.CertificateUtils;
import io.evitadb.utils.CollectionUtils;
import io.evitadb.utils.ReflectionLookup;
import io.evitadb.utils.UUIDUtil;
import io.evitadb.utils.VersionUtils;
import io.grpc.ClientInterceptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class EvitaClient
implements EvitaContract {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EvitaClient.class);
    static final Pattern ERROR_MESSAGE_PATTERN = Pattern.compile("(\\w+:\\w+:\\w+): (.*)");
    final ThreadLocal<LinkedList<Timeout>> timeout;
    private final EvitaServiceGrpc.EvitaServiceFutureStub evitaServiceFutureStub;
    private final EvitaClientConfiguration configuration;
    private final AtomicBoolean active;
    private final ReflectionLookup reflectionLookup;
    private final Map<String, EvitaEntitySchemaCache> entitySchemaCache;
    private final Map<UUID, EvitaSessionContract> activeSessions;
    private final ExecutorService executor;
    private final ClientFactory clientFactory;
    private final GrpcClientBuilder grpcClientBuilder;
    private final EvitaClientManagement management;

    @Nonnull
    public static RuntimeException transformException(@Nonnull Throwable ex, @Nonnull Runnable onUnauthenticated) {
        if (ex instanceof StatusRuntimeException) {
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)ex;
            return EvitaClient.transformStatusRuntimeException(statusRuntimeException, onUnauthenticated);
        }
        if (ex instanceof EvitaInvalidUsageException) {
            EvitaInvalidUsageException invalidUsageException = (EvitaInvalidUsageException)ex;
            return invalidUsageException;
        }
        if (ex instanceof EvitaInternalError) {
            EvitaInternalError evitaInternalError = (EvitaInternalError)ex;
            return evitaInternalError;
        }
        log.error("Unexpected internal Evita error occurred: {}", (Object)ex.getMessage(), (Object)ex);
        return new EvitaClientServerCallException("Unexpected internal Evita error occurred.", ex);
    }

    @Nonnull
    private static ClientTracingContext getClientTracingContext(@Nonnull EvitaClientConfiguration configuration) {
        ClientTracingContext context = ClientTracingContextProvider.getContext();
        Object openTelemetryInstance = configuration.openTelemetryInstance();
        if (openTelemetryInstance != null && context instanceof DefaultClientTracingContext) {
            throw new EvitaInvalidUsageException("OpenTelemetry instance is set, but tracing context is not configured!");
        }
        return context;
    }

    @Nonnull
    private static RuntimeException transformStatusRuntimeException(@Nonnull StatusRuntimeException statusRuntimeException, @Nonnull Runnable onUnauthenticated) {
        Status.Code statusCode = statusRuntimeException.getStatus().getCode();
        String description = Optional.ofNullable(statusRuntimeException.getStatus().getDescription()).map(it -> statusCode.name() + ": " + it).orElseGet(() -> statusCode.name());
        if (statusCode == Status.Code.UNAUTHENTICATED) {
            onUnauthenticated.run();
            return new InstanceTerminatedException("session");
        }
        if (statusCode == Status.Code.INVALID_ARGUMENT || statusCode == Status.Code.PERMISSION_DENIED) {
            Matcher expectedFormat = ERROR_MESSAGE_PATTERN.matcher(description);
            if (expectedFormat.matches()) {
                return EvitaInvalidUsageException.createExceptionWithErrorCode((String)expectedFormat.group(2), (String)expectedFormat.group(1));
            }
            return new EvitaInvalidUsageException(description);
        }
        Matcher expectedFormat = ERROR_MESSAGE_PATTERN.matcher(description);
        if (expectedFormat.matches()) {
            return GenericEvitaInternalError.createExceptionWithErrorCode((String)expectedFormat.group(2), (String)expectedFormat.group(1));
        }
        return new GenericEvitaInternalError(description);
    }

    public EvitaClient(@Nonnull EvitaClientConfiguration configuration) {
        this(configuration, null);
    }

    public EvitaClient(@Nonnull EvitaClientConfiguration configuration, @Nullable Consumer<GrpcClientBuilder> grpcConfigurator) {
        block16: {
            VersionUtils.SemVer clientVersion;
            String uriScheme;
            this.active = new AtomicBoolean(true);
            this.entitySchemaCache = new ConcurrentHashMap<String, EvitaEntitySchemaCache>(8);
            this.activeSessions = CollectionUtils.createConcurrentHashMap((int)16);
            this.configuration = configuration;
            ClientFactoryBuilder clientFactoryBuilder = ClientFactory.builder().workerGroup(Runtime.getRuntime().availableProcessors()).idleTimeoutMillis(TimeUnit.MILLISECONDS.convert(configuration.timeout(), configuration.timeoutUnit())).pingIntervalMillis(1000L);
            if (configuration.tlsEnabled()) {
                uriScheme = "https";
                ClientCertificateManager.Builder certificateBuilder = new ClientCertificateManager.Builder().useGeneratedCertificate(configuration.useGeneratedCertificate(), configuration.host(), configuration.systemApiPort()).usingTrustedServerCertificate(configuration.trustCertificate()).trustStorePassword(configuration.trustStorePassword()).mtls(configuration.mtlsEnabled()).clientCertificateFilePath(configuration.certificateFileName()).clientPrivateKeyFilePath(configuration.certificateKeyFileName()).clientPrivateKeyPassword(configuration.certificateKeyPassword());
                if (configuration.certificateFolderPath() != null) {
                    certificateBuilder.certificateClientFolderPath(configuration.certificateFolderPath());
                }
                if (configuration.serverCertificatePath() != null) {
                    certificateBuilder.serverCertificateFilePath(configuration.serverCertificatePath());
                }
                ClientCertificateManager clientCertificateManager = certificateBuilder.build();
                clientFactoryBuilder = clientCertificateManager.buildClientSslContext((certificateType, certificate) -> {
                    try {
                        switch (certificateType) {
                            case SERVER: {
                                log.info("Server's certificate fingerprint: {}", (Object)CertificateUtils.getCertificateFingerprint((Certificate)certificate));
                                break;
                            }
                            case CLIENT: {
                                log.info("Client's certificate fingerprint: {}", (Object)CertificateUtils.getCertificateFingerprint((Certificate)certificate));
                            }
                        }
                    }
                    catch (NoSuchAlgorithmException | CertificateEncodingException e) {
                        throw new GenericEvitaInternalError("Failed to get certificate fingerprint.", "Failed to get certificate fingerprint: " + e.getMessage(), (Throwable)e);
                    }
                }, clientFactoryBuilder);
            } else {
                uriScheme = "http";
            }
            this.executor = Executors.newCachedThreadPool();
            this.clientFactory = clientFactoryBuilder.build();
            try {
                clientVersion = VersionUtils.SemVer.fromString((String)this.getVersion());
            }
            catch (InvalidEvitaVersionException e) {
                clientVersion = null;
            }
            GrpcClientBuilder grpcClientBuilder = GrpcClients.builder((String)(uriScheme + "://" + configuration.host() + ":" + configuration.port() + "/")).factory(this.clientFactory).serializationFormat(GrpcSerializationFormats.PROTO).intercept(new ClientInterceptor[]{new ClientSessionInterceptor(configuration.clientId(), clientVersion)});
            if (configuration.retry()) {
                grpcClientBuilder.decorator(RetryingClient.builder((RetryRule)RetryRule.of((RetryRule[])new RetryRule[]{((RetryRuleBuilder)RetryRule.builder().onTimeoutException()).thenBackoff(), ((RetryRuleBuilder)RetryRule.builder().onStatus(new HttpStatus[]{HttpStatus.SERVICE_UNAVAILABLE, HttpStatus.GATEWAY_TIMEOUT, HttpStatus.UNKNOWN})).thenBackoff(), ((RetryRuleBuilder)RetryRule.builder().onStatus(new HttpStatus[]{HttpStatus.TOO_MANY_REQUESTS})).thenNoRetry()})).useRetryAfter(true).newDecorator());
            }
            ClientTracingContext context = EvitaClient.getClientTracingContext(configuration);
            if (configuration.openTelemetryInstance() != null) {
                context.setOpenTelemetry(configuration.openTelemetryInstance());
            }
            Optional.ofNullable(grpcConfigurator).ifPresent(it -> it.accept(grpcClientBuilder));
            this.grpcClientBuilder = grpcClientBuilder;
            this.evitaServiceFutureStub = (EvitaServiceGrpc.EvitaServiceFutureStub)grpcClientBuilder.build(EvitaServiceGrpc.EvitaServiceFutureStub.class);
            this.reflectionLookup = new ReflectionLookup(configuration.reflectionLookupBehaviour());
            this.timeout = ThreadLocal.withInitial(() -> {
                LinkedList<Timeout> timeouts = new LinkedList<Timeout>();
                timeouts.add(new Timeout(configuration.timeout(), configuration.timeoutUnit()));
                return timeouts;
            });
            this.management = new EvitaClientManagement(this, this.grpcClientBuilder);
            this.active.set(true);
            try {
                VersionUtils.SemVer serverVersion;
                if (clientVersion == null) {
                    log.warn("Client version `{}` is not a valid semantic version. Aborting version check, this situation may lead to compatibility issues.", (Object)this.getVersion());
                    return;
                }
                SystemStatus systemStatus = this.management().getSystemStatus();
                try {
                    serverVersion = VersionUtils.SemVer.fromString((String)systemStatus.version());
                }
                catch (InvalidEvitaVersionException e) {
                    log.warn("Server version `{}` is not a valid semantic version. Aborting version check, this situation may lead to compatibility issues.", (Object)systemStatus.version());
                    return;
                }
                int comparisonResult = VersionUtils.SemVer.compare((VersionUtils.SemVer)clientVersion, (VersionUtils.SemVer)serverVersion);
                if (comparisonResult < 0) {
                    log.warn("Client version {} is lower than the server version {}. It may not represent a compatibility issue, but it is recommended to update the client to the latest version.", (Object)clientVersion, (Object)serverVersion);
                    break block16;
                }
                if (comparisonResult <= 0) break block16;
                if (clientVersion.snapshot() || serverVersion.snapshot()) {
                    log.warn("Client version `{}` is higher than server version `{}`. This situation might lead to compatibility issues, but there is SNAPSHOT version involved and some kind of testing is probably happening.", (Object)clientVersion, (Object)serverVersion);
                    break block16;
                }
                throw new IncompatibleClientException("Client version `" + String.valueOf(clientVersion) + "` is higher than the server version `" + String.valueOf(serverVersion) + "`. This situation will probably lead to compatibility issues. Please update the server to the latest version.", "Incompatible client version!");
            }
            catch (IncompatibleClientException ex) {
                throw ex;
            }
            catch (Exception ex) {
                log.error("Failed to connect to the evitaDB server. Please check the connection settings.", (Throwable)ex);
            }
        }
    }

    public boolean isActive() {
        return this.active.get();
    }

    @Nonnull
    public EvitaClientSession createSession(@Nonnull SessionTraits traits) {
        GrpcEvitaSessionResponse grpcResponse;
        this.assertActive();
        GrpcEvitaSessionRequest.Builder sessionBuilder = GrpcEvitaSessionRequest.newBuilder().setCatalogName(traits.catalogName()).setDryRun(traits.isDryRun());
        if (traits.isReadWrite()) {
            if (traits.commitBehaviour() != null) {
                sessionBuilder.setCommitBehavior(EvitaEnumConverter.toGrpcCommitBehavior((TransactionContract.CommitBehavior)traits.commitBehaviour()));
            }
            grpcResponse = traits.isBinary() ? (GrpcEvitaSessionResponse)this.executeWithEvitaService(evitaService -> evitaService.createBinaryReadWriteSession(sessionBuilder.build())) : (GrpcEvitaSessionResponse)this.executeWithEvitaService(evitaService -> evitaService.createReadWriteSession(sessionBuilder.build()));
        } else {
            grpcResponse = traits.isBinary() ? (GrpcEvitaSessionResponse)this.executeWithEvitaService(evitaService -> evitaService.createBinaryReadOnlySession(sessionBuilder.build())) : (GrpcEvitaSessionResponse)this.executeWithEvitaService(evitaService -> evitaService.createReadOnlySession(sessionBuilder.build()));
        }
        EvitaClientSession evitaClientSession = new EvitaClientSession(this, this.management, this.entitySchemaCache.computeIfAbsent(traits.catalogName(), catalogName -> new EvitaEntitySchemaCache((String)catalogName, this.reflectionLookup)), this.grpcClientBuilder, traits.catalogName(), EvitaEnumConverter.toCatalogState((GrpcCatalogState)grpcResponse.getCatalogState()), Optional.ofNullable(grpcResponse.getCatalogId()).filter(it -> !it.isBlank()).map(UUIDUtil::uuid).orElseGet(UUIDUtil::randomUUID), UUIDUtil.uuid((String)grpcResponse.getSessionId()), EvitaEnumConverter.toCommitBehavior((GrpcCommitBehavior)grpcResponse.getCommitBehaviour()), traits, evitaSession -> {
            this.activeSessions.remove(evitaSession.getId());
            Optional.ofNullable(traits.onTermination()).ifPresent(it -> it.onTermination((EvitaSessionContract)evitaSession));
        }, Objects.requireNonNull(this.timeout.get().peek()));
        this.activeSessions.put(evitaClientSession.getId(), evitaClientSession);
        return evitaClientSession;
    }

    @Nonnull
    public Optional<EvitaSessionContract> getSessionById(@Nonnull UUID uuid) {
        return Optional.ofNullable(this.activeSessions.get(uuid));
    }

    public void terminateSession(@Nonnull EvitaSessionContract session) {
        this.assertActive();
        if (!(session instanceof EvitaClientSession)) {
            throw new EvitaInvalidUsageException("Passed session is expected to be `EvitaClientSession`, but it is not (" + session.getClass().getSimpleName() + ")!");
        }
        EvitaClientSession evitaClientSession = (EvitaClientSession)session;
        evitaClientSession.close();
    }

    @Nonnull
    public Set<String> getCatalogNames() {
        this.assertActive();
        GrpcCatalogNamesResponse grpcResponse = (GrpcCatalogNamesResponse)this.executeWithEvitaService(evitaService -> evitaService.getCatalogNames(Empty.newBuilder().build()));
        return new LinkedHashSet<String>((Collection<String>)grpcResponse.getCatalogNamesList());
    }

    @Nonnull
    public Optional<CatalogState> getCatalogState(@Nonnull String catalogName) {
        this.assertActive();
        GrpcGetCatalogStateResponse grpcResponse = (GrpcGetCatalogStateResponse)this.executeWithEvitaService(evitaService -> evitaService.getCatalogState(GrpcGetCatalogStateRequest.newBuilder().setCatalogName(catalogName).build()));
        return grpcResponse.hasCatalogState() ? Optional.of(EvitaEnumConverter.toCatalogState((GrpcCatalogState)grpcResponse.getCatalogState())) : Optional.empty();
    }

    @Nonnull
    public CatalogSchemaEditor.CatalogSchemaBuilder defineCatalog(@Nonnull String catalogName) {
        this.assertActive();
        if (!this.getCatalogNames().contains(catalogName)) {
            this.update(new TopLevelCatalogSchemaMutation[]{new CreateCatalogSchemaMutation(catalogName)});
        }
        return this.queryCatalog(catalogName, (EvitaSessionContract session) -> ((EvitaClientSession)session).getCatalogSchema(this), new SessionTraits.SessionFlags[0]).openForWrite();
    }

    public void renameCatalog(@Nonnull String catalogName, @Nonnull String newCatalogName) {
        this.assertActive();
        GrpcRenameCatalogRequest request = GrpcRenameCatalogRequest.newBuilder().setCatalogName(catalogName).setNewCatalogName(newCatalogName).build();
        GrpcRenameCatalogResponse grpcResponse = (GrpcRenameCatalogResponse)this.executeWithEvitaService(evitaService -> evitaService.renameCatalog(request));
        boolean success = grpcResponse.getSuccess();
        if (success) {
            this.entitySchemaCache.remove(catalogName);
            this.entitySchemaCache.remove(newCatalogName);
        }
    }

    public void replaceCatalog(@Nonnull String catalogNameToBeReplacedWith, @Nonnull String catalogNameToBeReplaced) {
        this.assertActive();
        GrpcReplaceCatalogRequest request = GrpcReplaceCatalogRequest.newBuilder().setCatalogNameToBeReplacedWith(catalogNameToBeReplacedWith).setCatalogNameToBeReplaced(catalogNameToBeReplaced).build();
        GrpcReplaceCatalogResponse grpcResponse = (GrpcReplaceCatalogResponse)this.executeWithEvitaService(evitaService -> evitaService.replaceCatalog(request));
        boolean success = grpcResponse.getSuccess();
        if (success) {
            this.entitySchemaCache.remove(catalogNameToBeReplaced);
            this.entitySchemaCache.remove(catalogNameToBeReplacedWith);
        }
    }

    public boolean deleteCatalogIfExists(@Nonnull String catalogName) {
        this.assertActive();
        GrpcDeleteCatalogIfExistsRequest request = GrpcDeleteCatalogIfExistsRequest.newBuilder().setCatalogName(catalogName).build();
        GrpcDeleteCatalogIfExistsResponse grpcResponse = (GrpcDeleteCatalogIfExistsResponse)this.executeWithEvitaService(evitaService -> evitaService.deleteCatalogIfExists(request));
        boolean success = grpcResponse.getSuccess();
        if (success) {
            this.entitySchemaCache.remove(catalogName);
        }
        return success;
    }

    public void update(TopLevelCatalogSchemaMutation ... catalogMutations) {
        this.assertActive();
        List<GrpcTopLevelCatalogSchemaMutation> grpcSchemaMutations = Arrays.stream(catalogMutations).map(arg_0 -> ((DelegatingTopLevelCatalogSchemaMutationConverter)DelegatingTopLevelCatalogSchemaMutationConverter.INSTANCE).convert(arg_0)).toList();
        GrpcUpdateEvitaRequest request = GrpcUpdateEvitaRequest.newBuilder().addAllSchemaMutations(grpcSchemaMutations).build();
        this.executeWithEvitaService(evitaService -> evitaService.update(request));
    }

    public <T> T queryCatalog(@Nonnull String catalogName, @Nonnull Function<EvitaSessionContract, T> queryLogic, SessionTraits.SessionFlags ... flags) {
        this.assertActive();
        try (EvitaClientSession session = this.createSession(new SessionTraits(catalogName, flags));){
            T t = queryLogic.apply(session);
            return t;
        }
    }

    public void queryCatalog(@Nonnull String catalogName, @Nonnull Consumer<EvitaSessionContract> queryLogic, SessionTraits.SessionFlags ... flags) {
        this.assertActive();
        try (EvitaClientSession session = this.createSession(new SessionTraits(catalogName, flags));){
            queryLogic.accept(session);
        }
    }

    @Nonnull
    public <T> CompletableFuture<T> queryCatalogAsync(@Nonnull String catalogName, @Nonnull Function<EvitaSessionContract, T> queryLogic, SessionTraits.SessionFlags ... flags) {
        return CompletableFuture.supplyAsync(() -> {
            this.assertActive();
            try (EvitaClientSession session = this.createSession(new SessionTraits(catalogName, flags));){
                Object r = queryLogic.apply(session);
                return r;
            }
        }, this.executor);
    }

    public <T> T updateCatalog(@Nonnull String catalogName, @Nonnull Function<EvitaSessionContract, T> updater, @Nonnull TransactionContract.CommitBehavior commitBehaviour, SessionTraits.SessionFlags ... flags) {
        SessionTraits.SessionFlags[] sessionFlagsArray;
        this.assertActive();
        if (flags == null) {
            SessionTraits.SessionFlags[] sessionFlagsArray2 = new SessionTraits.SessionFlags[1];
            sessionFlagsArray = sessionFlagsArray2;
            sessionFlagsArray2[0] = SessionTraits.SessionFlags.READ_WRITE;
        } else {
            sessionFlagsArray = (SessionTraits.SessionFlags[])ArrayUtils.insertRecordIntoArrayOnIndex((Object)SessionTraits.SessionFlags.READ_WRITE, (Object[])flags, (int)flags.length);
        }
        SessionTraits traits = new SessionTraits(catalogName, commitBehaviour, sessionFlagsArray);
        try (EvitaClientSession session = this.createSession(traits);){
            T t = updater.apply(session);
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public <T> CompletionStage<T> updateCatalogAsync(@Nonnull String catalogName, @Nonnull Function<EvitaSessionContract, T> updater, @Nonnull TransactionContract.CommitBehavior commitBehaviour, SessionTraits.SessionFlags ... flags) {
        CompletionStage closeFuture;
        Object resultValue;
        SessionTraits.SessionFlags[] sessionFlagsArray;
        this.assertActive();
        if (flags == null) {
            SessionTraits.SessionFlags[] sessionFlagsArray2 = new SessionTraits.SessionFlags[1];
            sessionFlagsArray = sessionFlagsArray2;
            sessionFlagsArray2[0] = SessionTraits.SessionFlags.READ_WRITE;
        } else {
            sessionFlagsArray = (SessionTraits.SessionFlags[])ArrayUtils.insertRecordIntoArrayOnIndex((Object)SessionTraits.SessionFlags.READ_WRITE, (Object[])flags, (int)flags.length);
        }
        SessionTraits traits = new SessionTraits(catalogName, commitBehaviour, sessionFlagsArray);
        EvitaClientSession session = this.createSession(traits);
        try {
            resultValue = updater.apply(session);
        }
        finally {
            closeFuture = session.closeNow(commitBehaviour);
        }
        CompletableFuture result = new CompletableFuture();
        closeFuture.whenComplete((txId, ex) -> {
            if (ex != null) {
                result.completeExceptionally((Throwable)ex);
            } else {
                result.complete(resultValue);
            }
        });
        return result;
    }

    public void updateCatalog(@Nonnull String catalogName, @Nonnull Consumer<EvitaSessionContract> updater, @Nonnull TransactionContract.CommitBehavior commitBehaviour, SessionTraits.SessionFlags ... flags) {
        SessionTraits.SessionFlags[] sessionFlagsArray;
        this.assertActive();
        if (flags == null) {
            SessionTraits.SessionFlags[] sessionFlagsArray2 = new SessionTraits.SessionFlags[1];
            sessionFlagsArray = sessionFlagsArray2;
            sessionFlagsArray2[0] = SessionTraits.SessionFlags.READ_WRITE;
        } else {
            sessionFlagsArray = (SessionTraits.SessionFlags[])ArrayUtils.insertRecordIntoArrayOnIndex((Object)SessionTraits.SessionFlags.READ_WRITE, (Object[])flags, (int)flags.length);
        }
        SessionTraits traits = new SessionTraits(catalogName, commitBehaviour, sessionFlagsArray);
        try (EvitaClientSession session = this.createSession(traits);){
            updater.accept(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public CommitProgress updateCatalogAsync(@Nonnull String catalogName, @Nonnull Consumer<EvitaSessionContract> updater, @Nonnull TransactionContract.CommitBehavior commitBehaviour, SessionTraits.SessionFlags ... flags) throws TransactionException {
        CommitProgress commitProgress;
        SessionTraits.SessionFlags[] sessionFlagsArray;
        this.assertActive();
        if (flags == null) {
            SessionTraits.SessionFlags[] sessionFlagsArray2 = new SessionTraits.SessionFlags[1];
            sessionFlagsArray = sessionFlagsArray2;
            sessionFlagsArray2[0] = SessionTraits.SessionFlags.READ_WRITE;
        } else {
            sessionFlagsArray = (SessionTraits.SessionFlags[])ArrayUtils.insertRecordIntoArrayOnIndex((Object)SessionTraits.SessionFlags.READ_WRITE, (Object[])flags, (int)flags.length);
        }
        SessionTraits traits = new SessionTraits(catalogName, commitBehaviour, sessionFlagsArray);
        EvitaClientSession session = this.createSession(traits);
        try {
            updater.accept(session);
        }
        finally {
            commitProgress = session.closeNowWithProgress();
        }
        return commitProgress;
    }

    @Nonnull
    public EvitaManagementContract management() {
        return this.management;
    }

    public void close() {
        if (this.active.compareAndSet(true, false)) {
            this.activeSessions.values().forEach(EvitaSessionContract::close);
            this.activeSessions.clear();
            this.management.close();
            this.clientFactory.close();
        }
    }

    @Nonnull
    public String getVersion() {
        return VersionUtils.readVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWithExtendedTimeout(@Nonnull Runnable lambda, long timeout, @Nonnull TimeUnit unit) {
        LinkedList<Timeout> callTimeouts = this.timeout.get();
        try {
            callTimeouts.push(new Timeout(timeout, unit));
            lambda.run();
        }
        finally {
            callTimeouts.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeWithExtendedTimeout(@Nonnull Supplier<T> lambda, long timeout, @Nonnull TimeUnit unit) {
        LinkedList<Timeout> callTimeouts = this.timeout.get();
        try {
            callTimeouts.push(new Timeout(timeout, unit));
            T t = lambda.get();
            return t;
        }
        finally {
            callTimeouts.pop();
        }
    }

    protected void assertActive() {
        if (!this.active.get()) {
            throw new InstanceTerminatedException("client instance");
        }
    }

    private <T> T executeWithEvitaService(@Nonnull AsyncCallFunction<EvitaServiceGrpc.EvitaServiceFutureStub, ListenableFuture<T>> lambda) {
        Timeout timeout = Objects.requireNonNull(this.timeout.get().peek());
        try {
            return (T)lambda.apply((EvitaServiceGrpc.EvitaServiceFutureStub)this.evitaServiceFutureStub.withDeadlineAfter(timeout.timeout(), timeout.timeoutUnit())).get(timeout.timeout(), timeout.timeoutUnit());
        }
        catch (ExecutionException e) {
            throw EvitaClient.transformException(e.getCause() == null ? e : e.getCause(), () -> {});
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new EvitaClientServerCallException("Server call interrupted.", e);
        }
        catch (TimeoutException e) {
            throw new EvitaClientTimedOutException(timeout.timeout(), timeout.timeoutUnit());
        }
    }

    @Generated
    public EvitaClientConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public ReflectionLookup getReflectionLookup() {
        return this.reflectionLookup;
    }
}

