/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.driver;

import io.evitadb.api.EvitaManagementContract;
import io.evitadb.api.task.TaskStatus;
import io.evitadb.driver.ClientTask;
import java.io.Closeable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientTaskTracker
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientTaskTracker.class);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final EvitaManagementContract evitaManagement;
    private final BlockingQueue<WeakReference<ClientTask<?, ?>>> tasks;
    private final ScheduledExecutorService scheduler;
    private final AtomicReference<ScheduledFuture<?>> refreshTaskStatusFuture = new AtomicReference();
    private final ReentrantLock refreshTaskLock = new ReentrantLock(true);
    private final int refreshIntervalMillis;

    public ClientTaskTracker(@Nonnull EvitaManagementContract evitaManagement, int clientTaskLimit, int refreshIntervalMillis) {
        this.evitaManagement = evitaManagement;
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.tasks = new ArrayBlockingQueue(clientTaskLimit);
        this.refreshIntervalMillis = refreshIntervalMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public <S, T> ClientTask<S, T> createTask(@Nonnull TaskStatus<S, T> taskStatus) {
        this.assertActive();
        TaskStatus.TaskSimplifiedState taskState = taskStatus.simplifiedState();
        if (taskState == TaskStatus.TaskSimplifiedState.WAITING_FOR_PRECONDITION || taskState == TaskStatus.TaskSimplifiedState.QUEUED || taskState == TaskStatus.TaskSimplifiedState.RUNNING) {
            ClientTask<S, T> taskToTrack = new ClientTask<S, T>(taskStatus, () -> arg_0 -> ((EvitaManagementContract)this.evitaManagement).cancelTask(arg_0), () -> arg_0 -> ((EvitaManagementContract)this.evitaManagement).getTaskStatus(arg_0));
            boolean added = this.tasks.offer(new WeakReference<ClientTask<S, T>>(taskToTrack));
            if (!added) {
                this.purgeFinishedTasks();
                if (!this.tasks.offer(new WeakReference<ClientTask<S, T>>(taskToTrack))) {
                    throw new RejectedExecutionException("Tracked client task limit reached, cannot track more tasks.");
                }
            }
            if (this.refreshTaskStatusFuture.get() == null) {
                this.refreshTaskLock.lock();
                try {
                    if (this.refreshTaskStatusFuture.get() == null) {
                        this.refreshTaskStatusFuture.set(this.scheduler.scheduleWithFixedDelay(this::refreshTaskStatus, 0L, this.refreshIntervalMillis, TimeUnit.MILLISECONDS));
                    }
                }
                finally {
                    this.refreshTaskLock.unlock();
                }
            }
            return taskToTrack;
        }
        return new ClientTask<S, T>(taskStatus);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.scheduler.shutdownNow();
            this.tasks.stream().map(Reference::get).filter(Objects::nonNull).forEach(ClientTask::discard);
        }
    }

    private void refreshTaskStatus() {
        try {
            UUID[] taskIds = (UUID[])this.tasks.stream().map(Reference::get).filter(Objects::nonNull).map(ClientTask::getStatus).map(TaskStatus::taskId).distinct().toArray(UUID[]::new);
            Map statusIndex = this.evitaManagement.getTaskStatuses(taskIds).stream().collect(Collectors.toMap(TaskStatus::taskId, Function.identity()));
            for (WeakReference weakReference : this.tasks) {
                TaskStatus status;
                ClientTask clientTask = (ClientTask)weakReference.get();
                if (clientTask == null || (status = (TaskStatus)statusIndex.get(clientTask.getStatus().taskId())) == null) continue;
                clientTask.updateStatus(status);
            }
            this.purgeFinishedTasks();
        }
        catch (Exception e) {
            log.error("Failed to refresh task statuses.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeFinishedTasks() {
        int bufferSize = Math.min(this.tasks.size(), 512);
        ArrayList<WeakReference> buffer = new ArrayList<WeakReference>(bufferSize);
        int queueSize = this.tasks.size();
        for (int i = 0; i < queueSize; i += this.tasks.drainTo(buffer, bufferSize)) {
            buffer.removeIf(task -> Optional.ofNullable((ClientTask)task.get()).map(ClientTask::isCompleted).orElse(true));
            this.tasks.addAll(buffer);
            buffer.clear();
        }
        if (this.tasks.isEmpty()) {
            this.refreshTaskLock.lock();
            try {
                ScheduledFuture<?> scheduledFuture = this.refreshTaskStatusFuture.get();
                if (this.tasks.isEmpty() && scheduledFuture != null) {
                    scheduledFuture.cancel(true);
                    this.refreshTaskStatusFuture.set(null);
                }
            }
            finally {
                this.refreshTaskLock.unlock();
            }
        }
    }

    private void assertActive() {
        if (this.closed.get()) {
            throw new IllegalStateException("Client task tracker is closed.");
        }
    }
}

