/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.driver;

import io.evitadb.api.task.Task;
import io.evitadb.api.task.TaskStatus;
import io.evitadb.driver.exception.TaskFailedException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class ClientTask<S, T>
implements Task<S, T> {
    private final AtomicReference<TaskStatus<S, T>> status;
    private final ClientTaskCompletableFuture<T> result;
    private final Function<UUID, Boolean> cancellationLambda;
    private final Function<UUID, Optional<TaskStatus<?, ?>>> stateUpdater;

    public ClientTask(@Nonnull TaskStatus<S, T> status, @Nonnull Supplier<Function<UUID, Boolean>> cancellationLambdaFactory, @Nonnull Supplier<Function<UUID, Optional<TaskStatus<?, ?>>>> stateUpdater) {
        this.status = new AtomicReference<TaskStatus<S, T>>(status);
        this.result = new ClientTaskCompletableFuture();
        if (status.simplifiedState() == TaskStatus.TaskSimplifiedState.FINISHED) {
            this.result.complete(status.result());
            this.cancellationLambda = null;
            this.stateUpdater = null;
        } else if (status.simplifiedState() == TaskStatus.TaskSimplifiedState.FAILED) {
            this.result.completeExceptionally((Throwable)((Object)new TaskFailedException(status.publicExceptionMessage())));
            this.cancellationLambda = null;
            this.stateUpdater = null;
        } else {
            this.cancellationLambda = cancellationLambdaFactory.get();
            this.stateUpdater = stateUpdater.get();
        }
    }

    public ClientTask(@Nonnull TaskStatus<S, T> status) {
        this(status, () -> null, () -> null);
    }

    @Nonnull
    public TaskStatus<S, T> getStatus() {
        return this.status.get();
    }

    @Nonnull
    public CompletableFuture<T> getFutureResult() {
        return this.result;
    }

    public boolean cancel() {
        if (this.result.isDone() || this.result.isCancelled() || this.cancellationLambda == null) {
            return false;
        }
        boolean cancelled = this.result.cancel(true);
        if (cancelled) {
            this.refreshStatus();
        }
        return cancelled;
    }

    public void discard() {
        this.result.cancel(true);
    }

    public boolean isCompleted() {
        return this.result.isDone() || this.result.isCancelled() || this.status.get().finished() != null;
    }

    public void updateStatus(@Nonnull TaskStatus<?, ?> status) {
        TaskStatus<?, ?> theStatus = status;
        this.status.set(theStatus);
        if (theStatus.simplifiedState() == TaskStatus.TaskSimplifiedState.FINISHED) {
            this.result.complete(theStatus.result());
        } else if (theStatus.simplifiedState() == TaskStatus.TaskSimplifiedState.FAILED) {
            this.result.completeExceptionally((Throwable)((Object)new TaskFailedException(theStatus.publicExceptionMessage())));
        }
    }

    private void refreshStatus() {
        this.stateUpdater.apply(this.status.get().taskId()).ifPresentOrElse(this::updateStatus, () -> this.updateStatus(this.status.get().transitionToFailed((Throwable)new CancellationException("Task was canceled."))));
    }

    private class ClientTaskCompletableFuture<X>
    extends CompletableFuture<X> {
        private ClientTaskCompletableFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (ClientTask.this.result.isDone() || ClientTask.this.result.isCancelled() || ClientTask.this.cancellationLambda == null) {
                return false;
            }
            Boolean canceledOnServer = ClientTask.this.cancellationLambda.apply(ClientTask.this.status.get().taskId());
            super.cancel(mayInterruptIfRunning);
            if (canceledOnServer.booleanValue()) {
                ClientTask.this.refreshStatus();
            }
            return canceledOnServer;
        }
    }
}

