/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.lab.gui.resolver;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.CacheControl;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.QueryParamsBuilder;
import com.linecorp.armeria.common.ServerCacheControl;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.file.HttpFile;
import io.evitadb.externalApi.lab.configuration.LabOptions;
import io.evitadb.externalApi.lab.gui.dto.EvitaDBConnection;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GuiHandler
implements HttpService {
    private static final Base64.Encoder BASE_64_ENCODER = Base64.getEncoder();
    private static final String EVITALAB_DATA_SET_PARAM_NAME = "evitalab";
    private static final String EVITALAB_SERVER_NAME_PARAM_NAME = "evitalab-server-name";
    private static final String EVITALAB_READONLY_PARAM_NAME = "evitalab-readonly";
    private static final String EVITALAB_PRECONFIGURED_CONNECTIONS_PARAM_NAME = "evitalab-pconnections";
    private static final Pattern ASSETS_PATTERN = Pattern.compile("/assets/([a-zA-Z0-9\\-_]+/)*[a-zA-Z0-9\\-_]+\\.[a-z0-9]+");
    private static final Pattern ROOT_ASSETS_PATTERN = Pattern.compile("(/logo)?/[a-zA-Z0-9\\-]+\\.[a-z0-9]+");
    @Nonnull
    private final LabOptions labConfig;
    @Nonnull
    private final String serverName;
    @Nonnull
    private final ObjectMapper objectMapper;
    private List<EvitaDBConnection> defaultConnections;

    @Nonnull
    public static GuiHandler create(@Nonnull LabOptions labConfig, @Nonnull String serverName, @Nonnull ObjectMapper objectMapper) {
        return new GuiHandler(labConfig, serverName, objectMapper);
    }

    @Nonnull
    private static String createJarResourceLocationWithForwardSlashes(@Nonnull Path path) {
        return path.toString().replace("\\", "/");
    }

    @Nonnull
    private static Boolean isLabDataSet(@Nonnull ServiceRequestContext ctx) {
        return Boolean.parseBoolean(ctx.queryParam(EVITALAB_DATA_SET_PARAM_NAME));
    }

    private static void passEncodedParam(@Nonnull QueryParamsBuilder params, @Nonnull String name, @Nonnull String value) {
        params.add(name, BASE_64_ENCODER.encodeToString(value.getBytes(StandardCharsets.UTF_8)));
    }

    @Nonnull
    private static HttpResponse serveAssets(@Nonnull ServiceRequestContext ctx, @Nonnull HttpRequest req, @Nonnull ClassLoader classLoader, @Nonnull String path, @Nonnull Path fsPath) throws Exception {
        return HttpFile.builder((ClassLoader)classLoader, (String)GuiHandler.createJarResourceLocationWithForwardSlashes(fsPath.resolve(Paths.get(path.substring(1), new String[0])))).cacheControl((CacheControl)ServerCacheControl.IMMUTABLE).build().asService().serve(ctx, req);
    }

    private static boolean isClientHttps(@Nonnull ServiceRequestContext ctx) {
        if (ctx.sessionProtocol().isTls()) {
            return true;
        }
        String forwardedProto = ctx.request().headers().get((CharSequence)HttpHeaderNames.X_FORWARDED_PROTO);
        return forwardedProto != null && forwardedProto.equalsIgnoreCase("https");
    }

    private GuiHandler(@Nonnull LabOptions labConfig, @Nonnull String serverName, @Nonnull ObjectMapper objectMapper) {
        this.labConfig = labConfig;
        this.serverName = serverName;
        this.objectMapper = objectMapper;
    }

    @Nonnull
    public HttpResponse serve(@Nonnull ServiceRequestContext ctx, @Nonnull HttpRequest req) throws Exception {
        String path = ctx.query() == null ? req.path() : req.path().replace("?" + ctx.query(), "");
        ClassLoader classLoader = this.getClass().getClassLoader();
        Path fsPath = Paths.get("META-INF/lab/gui/dist", new String[0]);
        if (path.isEmpty() || path.equals("/") || path.equals("/index.html")) {
            return this.serveRoot(ctx, req, classLoader, fsPath);
        }
        if (ROOT_ASSETS_PATTERN.matcher(path).matches() || ASSETS_PATTERN.matcher(path).matches()) {
            return GuiHandler.serveAssets(ctx, req, classLoader, path, fsPath);
        }
        return HttpResponse.of((int)404);
    }

    @Nonnull
    private HttpResponse serveRoot(@Nonnull ServiceRequestContext ctx, @Nonnull HttpRequest req, @Nonnull ClassLoader classLoader, @Nonnull Path fsPath) throws Exception {
        boolean labDataSetParamValue = GuiHandler.isLabDataSet(ctx);
        if (!labDataSetParamValue) {
            QueryParamsBuilder paramsWithLabData = ctx.queryParams().toBuilder();
            this.passLabDataSet(paramsWithLabData);
            this.passServerName(paramsWithLabData);
            this.passReadOnlyFlag(paramsWithLabData);
            String authority = req.headers().authority();
            this.passPreconfiguredEvitaDBConnections(paramsWithLabData, authority == null ? null : (GuiHandler.isClientHttps(ctx) ? "https://" : "http://") + authority);
            String newQueryString = paramsWithLabData.toQueryString();
            return HttpResponse.builder().status(HttpStatus.SEE_OTHER).header((CharSequence)HttpHeaderNames.LOCATION, (Object)(ctx.path() + "?" + newQueryString)).header((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)ServerCacheControl.DISABLED.asHeaderValue()).build();
        }
        return HttpFile.builder((ClassLoader)classLoader, (String)GuiHandler.createJarResourceLocationWithForwardSlashes(fsPath.resolve("index.html"))).lastModified(false).cacheControl((CacheControl)ServerCacheControl.DISABLED).build().asService().serve(ctx, req);
    }

    private void passLabDataSet(@Nonnull QueryParamsBuilder params) {
        params.add(EVITALAB_DATA_SET_PARAM_NAME, Boolean.TRUE.toString());
    }

    private void passServerName(@Nonnull QueryParamsBuilder params) {
        GuiHandler.passEncodedParam(params, EVITALAB_SERVER_NAME_PARAM_NAME, this.serverName);
    }

    private void passReadOnlyFlag(@Nonnull QueryParamsBuilder params) {
        GuiHandler.passEncodedParam(params, EVITALAB_READONLY_PARAM_NAME, String.valueOf(this.labConfig.getGui().isReadOnly()));
    }

    private void passPreconfiguredEvitaDBConnections(@Nonnull QueryParamsBuilder params, @Nullable String incomingRequestHostAndPort) throws IOException {
        List<EvitaDBConnection> connections = this.resolvePreconfiguredEvitaDBConnections(incomingRequestHostAndPort);
        String serializedSelfConnection = this.objectMapper.writeValueAsString(connections);
        GuiHandler.passEncodedParam(params, EVITALAB_PRECONFIGURED_CONNECTIONS_PARAM_NAME, serializedSelfConnection);
    }

    @Nonnull
    private List<EvitaDBConnection> resolvePreconfiguredEvitaDBConnections(@Nullable String incomingRequestHostAndPort) {
        if (this.defaultConnections == null || incomingRequestHostAndPort != null && !Objects.equals(incomingRequestHostAndPort, this.defaultConnections.get(0).serverUrl())) {
            String serverUrl = this.labConfig.getGui().isPreferIncomingHostAndPort() && incomingRequestHostAndPort != null ? incomingRequestHostAndPort : this.labConfig.getResolvedExposeOnUrl();
            this.defaultConnections = List.of(new EvitaDBConnection(null, this.serverName, serverUrl));
        }
        return this.defaultConnections;
    }
}

