/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.lab;

import com.linecorp.armeria.server.HttpService;
import io.evitadb.externalApi.event.ReadinessEvent;
import io.evitadb.externalApi.http.ExternalApiProvider;
import io.evitadb.externalApi.http.ProxyingEndpointProvider;
import io.evitadb.externalApi.lab.configuration.LabOptions;
import io.evitadb.utils.NetworkUtils;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabProvider
implements ProxyingEndpointProvider<LabOptions> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LabProvider.class);
    public static final String CODE = "lab";
    @Nonnull
    private final LabOptions configuration;
    @Nonnull
    private final HttpService apiHandler;
    private final long requestTimeout;
    private String reachableUrl;

    public LabProvider(@Nonnull LabOptions configuration, @Nonnull HttpService apiHandler, long requestTimeout) {
        this.configuration = configuration;
        this.apiHandler = apiHandler;
        this.requestTimeout = requestTimeout;
    }

    @Nonnull
    public String getCode() {
        return CODE;
    }

    @Nonnull
    public ExternalApiProvider.HttpServiceDefinition[] getHttpServiceDefinitions() {
        return new ExternalApiProvider.HttpServiceDefinition[]{new ExternalApiProvider.HttpServiceDefinition(this.apiHandler, ExternalApiProvider.PathHandlingMode.DYNAMIC_PATH_HANDLING, true)};
    }

    public boolean isReady() {
        Predicate<String> isReady = url -> {
            ReadinessEvent readinessEvent = new ReadinessEvent(CODE, ReadinessEvent.Prospective.CLIENT);
            return NetworkUtils.fetchContent((String)url, null, (String)"text/html", null, (long)this.requestTimeout, error -> {
                log.error("Error while checking readiness of Lab API: {}", error);
                readinessEvent.finish(ReadinessEvent.Result.ERROR);
            }, timeouted -> {
                log.error("{}", timeouted);
                readinessEvent.finish(ReadinessEvent.Result.TIMEOUT);
            }).map(content -> {
                boolean result = content.contains("evitaLab app");
                if (result) {
                    readinessEvent.finish(ReadinessEvent.Result.READY);
                }
                return result;
            }).orElse(false);
        };
        String[] baseUrls = this.configuration.getBaseUrls();
        if (this.reachableUrl == null) {
            for (String baseUrl : baseUrls) {
                if (!isReady.test(baseUrl)) continue;
                this.reachableUrl = baseUrl;
                return true;
            }
            return false;
        }
        return isReady.test(this.reachableUrl);
    }

    @Nonnull
    @Generated
    public LabOptions getConfiguration() {
        return this.configuration;
    }

    @Nonnull
    @Generated
    public HttpService getApiHandler() {
        return this.apiHandler;
    }
}

