/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.lab;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.server.HttpService;
import io.evitadb.api.configuration.EvitaConfiguration;
import io.evitadb.core.Evita;
import io.evitadb.externalApi.configuration.HeaderOptions;
import io.evitadb.externalApi.http.CorsEndpoint;
import io.evitadb.externalApi.http.CorsService;
import io.evitadb.externalApi.http.PathNormalizingHandler;
import io.evitadb.externalApi.lab.configuration.LabOptions;
import io.evitadb.externalApi.lab.gui.resolver.GuiHandler;
import io.evitadb.externalApi.lab.io.LabExceptionHandler;
import io.evitadb.externalApi.utils.UriPath;
import io.evitadb.externalApi.utils.path.RoutingHandlerService;
import io.evitadb.utils.CollectionUtils;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LabManager.class);
    @Nonnull
    private final ObjectMapper objectMapper = new ObjectMapper();
    @Nonnull
    private final Evita evita;
    @Nonnull
    private final HeaderOptions headerOptions;
    @Nonnull
    private final LabOptions labConfig;
    @Nonnull
    private final RoutingHandlerService labRouter = new RoutingHandlerService();
    @Nonnull
    private final Map<UriPath, CorsEndpoint> corsEndpoints = CollectionUtils.createConcurrentHashMap((int)20);

    public LabManager(@Nonnull Evita evita, @Nonnull HeaderOptions headerOptions, @Nonnull LabOptions labConfig) {
        this.evita = evita;
        this.headerOptions = headerOptions;
        this.labConfig = labConfig;
        this.registerLabGui();
        this.corsEndpoints.forEach((path, endpoint) -> this.labRouter.add(HttpMethod.OPTIONS, path.toString(), endpoint.toHandler()));
    }

    @Nonnull
    public HttpService getLabRouter() {
        return (HttpService)this.labRouter.decorate(PathNormalizingHandler::new);
    }

    private void registerLabGui() {
        UriPath endpointPath = UriPath.of((String[])new String[]{"/", "*"});
        CorsEndpoint corsEndpoint = this.corsEndpoints.computeIfAbsent(endpointPath, p -> new CorsEndpoint(this.headerOptions));
        corsEndpoint.addMetadata(Set.of(HttpMethod.GET), true, true);
        EvitaConfiguration configuration = this.evita.getConfiguration();
        this.labRouter.add(HttpMethod.GET, endpointPath.toString(), (HttpService)CorsService.standaloneFilter((HttpService)((HttpService)GuiHandler.create(this.labConfig, configuration.name(), this.objectMapper).decorate(service -> new LabExceptionHandler(this.objectMapper, (HttpService)service)))));
    }
}

