/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.leveldb.utils;

import eventcenter.leveldb.LevelDBPersistenceAdapter;
import java.io.File;

public class LevelDbUtils {
    public static SstFileStatisticsInfo generateSstFileStatisticsInfo(LevelDBPersistenceAdapter adapter) {
        File dirPath = adapter.getDirPath();
        int sstFileNum = 0;
        long sstFileSize = 0L;
        for (File file : dirPath.listFiles()) {
            if (!file.getName().endsWith(".sst")) continue;
            ++sstFileNum;
            sstFileSize += file.length();
        }
        SstFileStatisticsInfo info = new SstFileStatisticsInfo();
        info.setFileNum(sstFileNum);
        info.setFileSize(sstFileSize);
        return info;
    }

    private LevelDbUtils() {
    }

    public static class SstFileStatisticsInfo {
        private int fileNum;
        private long fileSize;

        public int getFileNum() {
            return this.fileNum;
        }

        public void setFileNum(int fileNum) {
            this.fileNum = fileNum;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public void setFileSize(long fileSize) {
            this.fileSize = fileSize;
        }

        public String toString() {
            return "SstFileStatisticsInfo{fileNum=" + this.fileNum + ", fileSize=" + this.fileSize + '}';
        }
    }
}

