/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.leveldb.tx;

import eventcenter.leveldb.LevelDBPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class BucketPageCache
implements Serializable {
    final List<LevelDBPage> pages;
    final Map<String, Integer> indexMap = new HashMap<String, Integer>();

    public BucketPageCache(List<LevelDBPage> pages) {
        this.pages = pages;
        this.init();
    }

    public BucketPageCache(int capacity) {
        this.pages = new ArrayList<LevelDBPage>(capacity);
    }

    private void init() {
        for (LevelDBPage page : this.pages) {
            this.fillIndexMap(page);
        }
    }

    private void fillIndexMap(LevelDBPage page) {
        if (page.getIndexes() == null) {
            return;
        }
        for (String index : page.getIndexes()) {
            this.indexMap.put(index, (int)page.getNo());
        }
    }

    public void addPage(LevelDBPage page) {
        this.pages.add(page);
        this.fillIndexMap(page);
    }

    public LevelDBPage getPageByNo(int pageNo) {
        try {
            return this.pages.get(pageNo - 1);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public LevelDBPage removeIndex(String index) {
        Integer pageNo = this.indexMap.remove(index);
        if (null == pageNo) {
            return null;
        }
        LevelDBPage page = this.getPageByNo(pageNo);
        if (page.getIndexes() == null) {
            return null;
        }
        page.getIndexes().remove(index);
        return page;
    }

    public LevelDBPage getByIndex(String index) {
        Integer pageNo = this.indexMap.get(index);
        if (null == pageNo) {
            return null;
        }
        return this.getPageByNo(pageNo);
    }

    public LevelDBPage updateIndex(LevelDBPage page, String index) {
        this.removeIndex(index);
        if (page.getIndexes() == null) {
            page.setIndexes(new ArrayList<String>());
        }
        page.getIndexes().add(index);
        this.indexMap.put(index, (int)page.getNo());
        return page;
    }

    public int size() {
        return this.pages.size();
    }
}

