/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.leveldb.saf;

import eventcenter.api.async.EventQueue;
import eventcenter.leveldb.LevelDBPersistenceAdapter;
import eventcenter.leveldb.LevelDBQueue;
import eventcenter.leveldb.QueueMiddleComponent;
import eventcenter.leveldb.strategy.LimitReadHouseKeepingStrategy;
import eventcenter.remote.saf.EventForward;
import eventcenter.remote.saf.StoreAndForwardPolicy;
import eventcenter.remote.saf.simple.SimpleEventForward;
import eventcenter.remote.utils.StringHelper;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class LevelDBStoreAndForwardPolicy
implements StoreAndForwardPolicy {
    private boolean isStoreOnSendFail = true;
    private Long checkInterval;
    private volatile boolean openLevelDB = false;
    private LevelDBPersistenceAdapter adapter;
    private String path;
    private Integer readLimitSize;
    private String levelDBName;
    private Long houseKeepingInterval;
    private final Logger logger = Logger.getLogger(this.getClass());

    public boolean storeOnSendFail() {
        return this.isStoreOnSendFail;
    }

    public boolean isStoreOnSendFail() {
        return this.isStoreOnSendFail;
    }

    public void setStoreOnSendFail(boolean isStoreOnSendFail) {
        this.isStoreOnSendFail = isStoreOnSendFail;
    }

    public Long getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(Long checkInterval) {
        this.checkInterval = checkInterval;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Integer getReadLimitSize() {
        return this.readLimitSize;
    }

    public void setReadLimitSize(Integer readLimitSize) {
        this.readLimitSize = readLimitSize;
    }

    public String getLevelDBName() {
        return this.levelDBName;
    }

    public void setLevelDBName(String levelDBName) {
        this.levelDBName = levelDBName;
    }

    public Long getHouseKeepingInterval() {
        return this.houseKeepingInterval;
    }

    public void setHouseKeepingInterval(Long houseKeepingInterval) {
        this.houseKeepingInterval = houseKeepingInterval;
    }

    public synchronized EventQueue createEventQueue(String queueName) throws IOException {
        if (StringHelper.isEmpty((String)queueName)) {
            throw new IllegalArgumentException("please set queue name for publisher group");
        }
        if (!this.openLevelDB) {
            try {
                this.init();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("start up leveldb saf policy failure:" + e.getMessage());
            }
        }
        QueueMiddleComponent queueMiddle = new QueueMiddleComponent(this.adapter, queueName);
        queueMiddle.open();
        LevelDBQueue queue = new LevelDBQueue(queueMiddle);
        LimitReadHouseKeepingStrategy strategy = new LimitReadHouseKeepingStrategy(queue);
        if (null != this.houseKeepingInterval) {
            strategy.setCheckInterval(this.houseKeepingInterval);
        }
        if (null != this.readLimitSize) {
            strategy.setReadLimitSize(this.readLimitSize);
        }
        queue.setHouseKeepingStrategy(strategy);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)new StringBuilder("create saf queue:leveldb^").append(queueName).append(" success."));
        }
        return queue;
    }

    private void init() throws IOException {
        this.adapter = new LevelDBPersistenceAdapter();
        File dir = new File(System.getProperty("user.home") + File.separator + "ec" + File.separator + "saf");
        if (this.path != null) {
            dir = new File(this.path + File.separator + ".safleveldb");
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.adapter.setDirPath(dir);
        this.adapter.setName(this.levelDBName);
        this.adapter.open();
        this.openLevelDB = true;
        this.logger.info((Object)new StringBuilder("start leveldb saf success, path:").append(dir.getPath()));
    }

    public EventForward createEventForward() {
        SimpleEventForward forward = new SimpleEventForward(this.isStoreOnSendFail);
        if (null != this.checkInterval) {
            forward.setCheckInterval(this.checkInterval.longValue());
        }
        return forward;
    }
}

