/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.leveldb;

import eventcenter.api.CommonEventSource;
import eventcenter.api.EventListener;
import eventcenter.api.async.EventQueue;
import eventcenter.api.async.LockBase;
import eventcenter.api.async.MessageListener;
import eventcenter.api.async.QueueException;
import eventcenter.api.tx.EventTxnStatus;
import eventcenter.api.tx.ResumeTxnHandler;
import eventcenter.api.tx.TransactionalSupport;
import eventcenter.leveldb.EventSourceWrapper;
import eventcenter.leveldb.HouseKeepingStrategy;
import eventcenter.leveldb.PersistenceException;
import eventcenter.leveldb.QueueMiddleComponent;
import eventcenter.leveldb.strategy.LimitReadHouseKeepingStrategy;
import eventcenter.leveldb.tx.TransactionConfig;
import eventcenter.leveldb.tx.TxnQueueComponent;
import eventcenter.leveldb.tx.TxnQueueComponentFactory;
import eventcenter.leveldb.tx.UnopenTxnModeException;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.iq80.leveldb.WriteBatch;

public class LevelDBQueue
extends LockBase
implements EventQueue,
TransactionalSupport {
    private final QueueMiddleComponent adapter;
    private volatile boolean isOpen = false;
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    private HouseKeepingStrategy houseKeepingStrategy;
    private TransactionConfig transactionConfig;
    private TxnQueueComponent txnQueueComponent;
    private Integer txnCapacity = 1000;

    public LevelDBQueue(QueueMiddleComponent adapter) {
        this.adapter = adapter;
    }

    public void open() throws IOException {
        long start = System.currentTimeMillis();
        this.isOpen = true;
        this.adapter.open();
        this.openTxnQueueComponent();
        if (null == this.houseKeepingStrategy) {
            this.houseKeepingStrategy = new LimitReadHouseKeepingStrategy(this);
        }
        this.houseKeepingStrategy.open();
        this.logger.info((Object)String.format("startup leveldb queue[%s,%s] success, took: %s ms.", this.adapter.getQueueName(), this.enqueueSize(), System.currentTimeMillis() - start));
    }

    public boolean isOpenTxnMode() {
        return null != this.transactionConfig;
    }

    private void openTxnQueueComponent() {
        if (!this.isOpenTxnMode()) {
            return;
        }
        this.txnQueueComponent = TxnQueueComponentFactory.create(this.adapter.getQueueName(), this.adapter.getDB(), this.transactionConfig, this.txnCapacity);
        try {
            this.txnQueueComponent.open();
            this.adapter.setOpenTxn(true);
        }
        catch (Exception e) {
            this.logger.error((Object)("startup txnQueueComponent failure:" + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        long start = System.currentTimeMillis();
        if (null != this.txnQueueComponent) {
            this.txnQueueComponent.shutdown();
        }
        this.adapter.close();
        this.houseKeepingStrategy.close();
        this.isOpen = false;
        LevelDBQueue levelDBQueue = this;
        synchronized (levelDBQueue) {
            ((Object)((Object)this)).notifyAll();
        }
        this.logger.info((Object)String.format("close leveldb queue[%s] success, took: %s ms.", this.adapter.getQueueName(), System.currentTimeMillis() - start));
    }

    public void offer(CommonEventSource evt) throws QueueException {
        try {
            this.adapter.save(evt);
            this.unlock();
        }
        catch (PersistenceException e) {
            throw new QueueException((Exception)e);
        }
    }

    public void offer(CommonEventSource evt, long timeout) {
        this.offer(evt);
    }

    public CommonEventSource peek() {
        try {
            EventSourceWrapper event = this.adapter.peek();
            if (null == event) {
                return event;
            }
            return event.getEvt();
        }
        catch (PersistenceException e) {
            throw new QueueException((Exception)e);
        }
    }

    public CommonEventSource peek(long timeout) {
        if (!this.isOpen) {
            return null;
        }
        CommonEventSource evt = this.peek();
        if (evt != null) {
            return evt;
        }
        this.lock(timeout);
        if (timeout <= -1L) {
            return this.peek(timeout);
        }
        return this.peek();
    }

    public CommonEventSource transfer() {
        return this.transfer(-1L);
    }

    public CommonEventSource transfer(long timeout) {
        if (!this.isOpen) {
            return null;
        }
        CommonEventSource evt = this.pop();
        if (evt != null) {
            return evt;
        }
        this.lock(timeout);
        if (timeout <= 0L) {
            return this.transfer(timeout);
        }
        return this.pop();
    }

    CommonEventSource transfer(long timeout, WriteBatch wb) {
        if (!this.isOpen) {
            return null;
        }
        CommonEventSource evt = this.pop(wb);
        if (evt != null) {
            return evt;
        }
        this.lock(timeout);
        if (timeout < 0L) {
            return this.transfer(timeout, wb);
        }
        return this.pop(wb);
    }

    private CommonEventSource pop() {
        if (!this.isOpen) {
            return null;
        }
        try {
            EventSourceWrapper eventWrapper = this.adapter.pop();
            if (null == eventWrapper) {
                return null;
            }
            if (!this.isOpenTxnMode()) {
                return eventWrapper.getWrapper();
            }
            return eventWrapper;
        }
        catch (Throwable e) {
            this.logger.error((Object)"pop message error", e);
            return null;
        }
    }

    private CommonEventSource pop(WriteBatch wb) {
        if (!this.isOpen) {
            return null;
        }
        try {
            EventSourceWrapper eventWrapper = this.adapter.pop(wb);
            if (null == eventWrapper) {
                return null;
            }
            if (!this.isOpenTxnMode()) {
                return eventWrapper.getEvt();
            }
            return eventWrapper;
        }
        catch (Throwable e) {
            this.logger.error((Object)"pop message error", e);
            return null;
        }
    }

    public int enqueueSize() {
        return (int)this.adapter.count();
    }

    public boolean isEmpty() {
        return false;
    }

    public void setMessageListener(MessageListener listener) {
    }

    public void resumeTxn(ResumeTxnHandler handler) throws Exception {
        this.getTxnQueueComponent().resumeTxn(handler);
    }

    public EventTxnStatus getTxnStatus(CommonEventSource event, String txnId, EventListener listener) throws Exception {
        if (!this.isOpenTxnMode()) {
            throw new UnopenTxnModeException();
        }
        return this.getTxnQueueComponent().getTxnStatus(event.getEventId(), listener.getClass(), txnId);
    }

    public EventTxnStatus getTxnStatus(CommonEventSource event, String txnId, EventListener listener, WriteBatch writeBatch) throws Exception {
        if (!this.isOpenTxnMode()) {
            throw new UnopenTxnModeException();
        }
        return this.getTxnQueueComponent().getTxnStatus(event.getEventId(), listener.getClass(), txnId, writeBatch);
    }

    public void commit(EventTxnStatus txnStatus) throws Exception {
        if (!this.isOpenTxnMode()) {
            throw new UnopenTxnModeException();
        }
        this.getTxnQueueComponent().commit(txnStatus);
    }

    public void houseKeeping() throws PersistenceException, IOException {
        this.getQueueMiddleComponent().houseKeeping();
        if (this.isOpenTxnMode()) {
            this.getTxnQueueComponent().houseKeeping();
        }
    }

    public HouseKeepingStrategy getHouseKeepingStrategy() {
        return this.houseKeepingStrategy;
    }

    public void setHouseKeepingStrategy(HouseKeepingStrategy houseKeepingStrategy) {
        this.houseKeepingStrategy = houseKeepingStrategy;
    }

    public TransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    public void setTransactionConfig(TransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    public Integer getTxnCapacity() {
        return this.txnCapacity;
    }

    public void setTxnCapacity(Integer txnCapacity) {
        this.txnCapacity = txnCapacity;
    }

    public TxnQueueComponent getTxnQueueComponent() {
        return this.txnQueueComponent;
    }

    public QueueMiddleComponent getQueueMiddleComponent() {
        return this.adapter;
    }
}

