/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.leveldb;

import eventcenter.api.CommonEventSource;
import eventcenter.api.utils.IdWorker;
import eventcenter.api.utils.SerializeUtils;
import eventcenter.leveldb.EventSourceWrapper;
import eventcenter.leveldb.PersistenceException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.WriteBatch;

public class LevelDBPersistenceAdapter
implements Closeable {
    private String name;
    private File dirPath;
    private Integer blockRestartInterval = 16;
    private Integer blockSize = 4096;
    private Long cacheSize = 0x10000000L;
    private Boolean useSnappyCompression = true;
    private Integer maxOpenFiles = 1000;
    private Boolean paranoidChecks = false;
    private Boolean verifyChecksums = false;
    private Integer writeBufferSize = 0x600000;
    private Boolean openLogger;
    private Integer batchDeleteSize = 1000;
    protected DB db;
    protected final IdWorker idWorker;
    protected final Logger logger = Logger.getLogger(this.getClass());

    public LevelDBPersistenceAdapter() {
        this.idWorker = new IdWorker(1L);
    }

    public File getDirPath() {
        if (null == this.dirPath) {
            this.dirPath = new File("eslogs");
        }
        return this.dirPath;
    }

    public void setDirPath(File dirPath) {
        this.dirPath = dirPath;
    }

    public Integer getBlockRestartInterval() {
        return this.blockRestartInterval;
    }

    public void setBlockRestartInterval(Integer blockRestartInterval) {
        this.blockRestartInterval = blockRestartInterval;
    }

    public Integer getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(Integer blockSize) {
        this.blockSize = blockSize;
    }

    public Long getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(Long cacheSize) {
        this.cacheSize = cacheSize;
    }

    public Boolean getUseSnappyCompression() {
        return this.useSnappyCompression;
    }

    public void setUseSnappyCompression(Boolean useSnappyCompression) {
        this.useSnappyCompression = useSnappyCompression;
    }

    public Integer getMaxOpenFiles() {
        return this.maxOpenFiles;
    }

    public void setMaxOpenFiles(Integer maxOpenFiles) {
        this.maxOpenFiles = maxOpenFiles;
    }

    public Boolean getParanoidChecks() {
        return this.paranoidChecks;
    }

    public void setParanoidChecks(Boolean paranoidChecks) {
        this.paranoidChecks = paranoidChecks;
    }

    public Boolean getVerifyChecksums() {
        return this.verifyChecksums;
    }

    public void setVerifyChecksums(Boolean verifyChecksums) {
        this.verifyChecksums = verifyChecksums;
    }

    public Integer getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBufferSize(Integer writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }

    public Integer getBatchDeleteSize() {
        return this.batchDeleteSize;
    }

    public void setBatchDeleteSize(Integer batchDeleteSize) {
        this.batchDeleteSize = batchDeleteSize;
    }

    protected Options createOptions() {
        Options options = new Options();
        options.createIfMissing(true);
        if (null != this.blockRestartInterval) {
            options.blockRestartInterval(this.blockRestartInterval.intValue());
        }
        if (null != this.blockSize) {
            options.blockSize(this.blockSize.intValue());
        }
        if (null != this.cacheSize) {
            options.cacheSize(this.cacheSize.longValue());
        }
        if (null != this.useSnappyCompression && this.useSnappyCompression.booleanValue()) {
            options.compressionType(CompressionType.SNAPPY);
        }
        if (null != this.maxOpenFiles) {
            options.maxOpenFiles(this.maxOpenFiles.intValue());
        }
        if (null != this.paranoidChecks) {
            options.paranoidChecks(this.paranoidChecks.booleanValue());
        }
        if (null != this.verifyChecksums) {
            options.verifyChecksums(this.verifyChecksums.booleanValue());
        }
        if (null != this.writeBufferSize) {
            options.writeBufferSize(this.writeBufferSize.intValue());
        }
        if (null != this.openLogger && this.openLogger.booleanValue()) {
            options.logger(new org.iq80.leveldb.Logger(){

                public void log(String message) {
                    if (LevelDBPersistenceAdapter.this.logger.isDebugEnabled()) {
                        LevelDBPersistenceAdapter.this.logger.debug((Object)message);
                    }
                }
            });
        }
        return options;
    }

    public synchronized void open() throws IOException {
        if (null != this.db) {
            return;
        }
        Options options = this.createOptions();
        File dirPath = this.getDirPath();
        this.db = JniDBFactory.factory.open(dirPath, options);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("open leveldb success, path:" + dirPath.getCanonicalPath()));
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.db == null) {
            return;
        }
        this.db.close();
        this.db = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"closed leveldb success");
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String nextId() {
        return String.valueOf(this.idWorker.nextId());
    }

    public String save(CommonEventSource evt) throws PersistenceException {
        EventSourceWrapper wrapper = new EventSourceWrapper(this.nextId(), evt);
        this.put(wrapper.getTxnId(), wrapper);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)new StringBuilder("saved evt:").append(wrapper.getTxnId()));
        }
        return wrapper.getTxnId();
    }

    public void houseKeeping() throws PersistenceException {
        List<EventSourceWrapper> list = null;
        int count = 500;
        while ((list = this.list(500)).size() > 0) {
            String[] ids = this.toIds(list);
            this.deleteById(ids);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)new StringBuilder("deleted keys:").append(ids));
        }
    }

    public List<EventSourceWrapper> list(int batchSize) throws PersistenceException {
        DBIterator iterator = this.db.iterator();
        iterator.seekToFirst();
        return this.list(batchSize, iterator);
    }

    public <T> T get(String key, Class<T> type) throws PersistenceException {
        try {
            if (null == this.db) {
                return null;
            }
            Serializable value = SerializeUtils.unserialize((byte[])this.db.get(key.getBytes()));
            if (null == value) {
                return null;
            }
            return type.cast(value);
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    public <T> List<T> getMore(Class<T> type, String ... keys) throws PersistenceException {
        ArrayList<T> list = new ArrayList<T>(keys.length);
        for (String key : keys) {
            list.add(this.get(key, type));
        }
        return list;
    }

    public List<EventSourceWrapper> list(int batchSize, DBIterator iterator) throws PersistenceException {
        ArrayList<EventSourceWrapper> list = new ArrayList<EventSourceWrapper>();
        try {
            for (int index = 0; index < batchSize && iterator.hasNext(); ++index) {
                Serializable value = SerializeUtils.unserialize((byte[])((byte[])iterator.peekNext().getValue()));
                list.add((EventSourceWrapper)value);
                iterator.next();
            }
            return list;
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    public DBIterator getIterator() {
        return this.db.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteById(String[] ids) throws PersistenceException {
        WriteBatch wb = this.db.createWriteBatch();
        try {
            for (String txnId : ids) {
                wb.delete(txnId.getBytes());
            }
            this.db.write(wb);
        }
        finally {
            try {
                wb.close();
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
        }
    }

    protected void deleteById(String txnId) {
        this.db.delete(txnId.getBytes());
    }

    public void put(String key, Serializable ser) throws PersistenceException {
        try {
            this.db.put(key.getBytes(), SerializeUtils.serialize((Serializable)ser));
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    public void put(String key, Serializable ser, WriteBatch update) throws PersistenceException {
        try {
            update.put(key.getBytes(), SerializeUtils.serialize((Serializable)ser));
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    String[] toIds(List<EventSourceWrapper> list) {
        String[] ids = new String[list.size()];
        int index = 0;
        for (EventSourceWrapper evt : list) {
            ids[index++] = evt.getTxnId();
        }
        return ids;
    }

    public DB getDb() {
        return this.db;
    }

    public synchronized void clear() throws IOException {
        while (this._clear() > 0) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int _clear() throws IOException {
        int index;
        DBIterator iterator = this.db.iterator();
        try {
            iterator.seekToFirst();
            if (!iterator.hasNext()) {
                int n = 0;
                return n;
            }
            WriteBatch wb = this.db.createWriteBatch();
            try {
                for (index = 0; index < this.batchDeleteSize && iterator.hasNext(); ++index) {
                    wb.delete((byte[])iterator.peekNext().getKey());
                    iterator.next();
                }
                this.db.write(wb);
            }
            finally {
                wb.close();
            }
        }
        finally {
            iterator.close();
        }
        return index;
    }

    public Boolean getOpenLogger() {
        return this.openLogger;
    }

    public void setOpenLogger(Boolean openLogger) {
        this.openLogger = openLogger;
    }
}

