/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.leveldb.tx;

import eventcenter.api.utils.SerializeUtils;
import eventcenter.leveldb.LevelDBPage;
import eventcenter.leveldb.tx.BucketFullException;
import eventcenter.leveldb.tx.BucketPageCache;
import eventcenter.leveldb.tx.IndexIterator;
import eventcenter.remote.utils.StringHelper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.WriteBatch;

public class LevelDBBucket
implements Serializable {
    private static final long serialVersionUID = -3011861468370113368L;
    static final int DEFAULT_PAGE_CAPACITY = 10;
    private final String id;
    private List<String> pageIds;
    BucketPageCache pagesCache;
    private final boolean openCache;
    private final DB db;
    private final String queueName;
    private int pageCount = 0;
    private LevelDBPage currentPage;
    private int maxCountOfPage = 20;
    private int maxCapacityOfPage = 10;
    private int[] pageCounts;
    private int capacityOfBucket;
    private volatile boolean init = false;
    Integer readPageNo;
    private final ReentrantLock writeLock = new ReentrantLock();
    private final Logger logger = Logger.getLogger(this.getClass());

    LevelDBBucket(String id, DB db, Profile profile) {
        this(id, db, profile.getQueueName(), profile.isOpenCache());
        if (null != profile.getMaxCountOfPage()) {
            this.maxCountOfPage = profile.getMaxCountOfPage();
        }
    }

    LevelDBBucket(String id, DB db, String queueName, boolean openCache) {
        this.db = db;
        this.id = id;
        this.queueName = queueName;
        this.openCache = openCache;
    }

    LevelDBBucket(String id, DB db, String queueName) {
        this(id, db, queueName, false);
    }

    public synchronized void open() throws IOException {
        if (this.init) {
            return;
        }
        ReentrantLock lock = this.writeLock;
        lock.lock();
        try {
            this.loadPageCount();
            if (this.openCache) {
                this.loadPages();
            }
            this.loadCapacityOfBucket();
            this.loadPageCounts();
            this.loadCurrentPage();
            this.loadReadPageNo();
        }
        finally {
            this.init = true;
            lock.unlock();
        }
    }

    private void loadPageCounts() throws IOException {
        this.pageCounts = new int[this.maxCountOfPage];
        for (int i = 0; i < this.maxCountOfPage; ++i) {
            if (i > this.pageCount) {
                this.pageCounts[i] = 0;
                continue;
            }
            String pageNo = String.valueOf(i + 1);
            LevelDBPage page = this.getPage(pageNo);
            if (null == page) {
                this.logger.warn((Object)("bucket[" + this.id + "]'s page[" + pageNo + "] is null"));
                this.pageCounts[i] = 0;
                continue;
            }
            this.pageCounts[i] = page.getIndexes().size();
        }
    }

    private void loadCurrentPage() throws IOException {
        if (this.openCache) {
            this.currentPage = this.getPageInner(1);
            WriteBatch wb = this.db.createWriteBatch();
            try {
                this.getIdlePage(wb);
            }
            catch (BucketFullException e) {
                this.logger.error((Object)e.getMessage());
            }
            return;
        }
        this.currentPage = this.getPage(String.valueOf(this.pageCount));
        if (this.currentPage == null) {
            WriteBatch writeBatch = this.db.createWriteBatch();
            try {
                this.currentPage = this.nextPage(writeBatch);
            }
            finally {
                this.db.write(writeBatch);
                writeBatch.close();
            }
        }
    }

    private void loadReadPageNo() throws IOException {
        this.readPageNo = LevelDBBucket.get(this.db, this.buildReadPageNoKey(), Integer.class);
        if (null == this.readPageNo) {
            WriteBatch wb = this.db.createWriteBatch();
            this.readPageNo = 1;
            try {
                this.saveReadPageNo(wb, this.readPageNo);
            }
            finally {
                this.db.write(wb);
                wb.close();
            }
        }
    }

    private void loadCapacityOfBucket() {
        this.capacityOfBucket = this.maxCountOfPage * this.maxCapacityOfPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPages() throws IOException {
        this.pagesCache = new BucketPageCache(this.maxCountOfPage + 1);
        WriteBatch wb = this.db.createWriteBatch();
        try {
            for (int i = 1; i <= this.maxCountOfPage; ++i) {
                LevelDBPage page = this.getPage(String.valueOf(i));
                if (null == page) {
                    page = this.createPage(i);
                    this.savePage(wb, page);
                    ++this.pageCount;
                    this.savePageCount(wb, this.pageCount);
                }
                this.pagesCache.addPage(page);
            }
        }
        finally {
            this.db.write(wb);
            wb.close();
        }
    }

    private void loadPageCount() throws IOException {
        Integer value = LevelDBBucket.get(this.db, LevelDBBucket.buildBucketPageCount(this.id), Integer.class);
        if (null == value) {
            return;
        }
        this.pageCount = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LevelDBPage nextPage(WriteBatch wb) throws IOException {
        ReentrantLock lock = this.writeLock;
        lock.lock();
        try {
            ++this.pageCount;
            LevelDBPage page = this.createPage(this.pageCount);
            this.savePage(wb, page);
            this.savePageCount(wb, this.pageCount);
            LevelDBPage levelDBPage = page;
            return levelDBPage;
        }
        finally {
            lock.unlock();
        }
    }

    private LevelDBPage createPage(int pageNo) {
        LevelDBPage page = new LevelDBPage();
        page.setNo(pageNo);
        page.setIndexes(new ArrayList<String>());
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String popByIndex(WriteBatch wb, String index) throws IllegalAccessException, IOException {
        if (!this.openCache) {
            throw new IllegalAccessException("it needs open cache");
        }
        ReentrantLock lock = this.writeLock;
        lock.lock();
        try {
            LevelDBPage page = this.pagesCache.removeIndex(index);
            if (null == page) {
                String string = null;
                return string;
            }
            this.savePage(wb, page);
            this.pageCounts[(int)page.getNo() - 1] = page.getIndexes().size();
            String string = index;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pop(WriteBatch wb) throws IOException {
        ReentrantLock lock = this.writeLock;
        lock.lock();
        try {
            List<String> values = this.pop(wb, 1);
            if (values == null || values.size() == 0) {
                String string = null;
                return string;
            }
            String string = values.get(0);
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> pop(WriteBatch wb, int count) throws IOException {
        ReentrantLock lock = this.writeLock;
        lock.lock();
        ArrayList<String> indexes = new ArrayList<String>(count + 1);
        try {
            int readPageNoSnapshot = this.readPageNo;
            this.readPageNo = this.pop(indexes, wb, this.readPageNo, count, this.count(), 0);
            if (this.readPageNo != readPageNoSnapshot) {
                this.saveReadPageNo(wb, this.readPageNo);
            }
        }
        finally {
            lock.unlock();
        }
        return indexes;
    }

    private int pop(List<String> indexes, WriteBatch wb, int readPageNo, int count, int totalCount, int loopCount) throws IOException {
        if (count == 0 || totalCount == 0 || loopCount >= this.maxCountOfPage) {
            return readPageNo;
        }
        int pageCount = this.pageCounts[readPageNo - 1];
        if (pageCount == 0) {
            readPageNo = this.increaseReadPageNo(readPageNo);
            this.pop(indexes, wb, readPageNo, count, totalCount, ++loopCount);
        }
        LevelDBPage page = this.getPageInner(readPageNo);
        int actualCount = 0;
        int leftCount = 0;
        if (count <= pageCount) {
            actualCount = count;
        } else {
            actualCount = pageCount;
            leftCount = count - pageCount;
        }
        try {
            List<String> subList = page.getIndexes().subList(0, actualCount);
            indexes.addAll(subList);
            page.getIndexes().removeAll(subList);
            totalCount -= actualCount;
        }
        catch (IndexOutOfBoundsException e) {
            this.logger.warn((Object)("bucket[" + this.id + "] page no :" + readPageNo + " only left:" + page.getIndexes().size() + ", it needs " + actualCount));
            totalCount -= page.getIndexes().size();
            indexes.addAll(page.getIndexes());
            page.getIndexes().clear();
        }
        this.pageCounts[readPageNo - 1] = page.getIndexes().size();
        if (actualCount == pageCount) {
            readPageNo = this.increaseReadPageNo(readPageNo);
        }
        this.savePage(wb, page);
        if (leftCount == 0) {
            return readPageNo;
        }
        return this.pop(indexes, wb, readPageNo, leftCount, totalCount, ++loopCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer savePageIndex(WriteBatch wb, String index) throws BucketFullException, IOException {
        ReentrantLock lock = this.writeLock;
        lock.lock();
        try {
            if (this.isFull()) {
                throw new BucketFullException(this.id);
            }
            LevelDBPage idlePage = this.getIdlePage(wb);
            if (this.openCache) {
                this.pagesCache.updateIndex(idlePage, index);
            } else {
                idlePage.getIndexes().add(index);
            }
            this.savePage(wb, idlePage);
            this.increaseCount(wb, (int)idlePage.getNo());
            Integer n = (int)idlePage.getNo();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveReadPageNo(WriteBatch wb, Integer pageNo) throws IOException {
        ReentrantLock lock = this.writeLock;
        lock.lock();
        try {
            LevelDBBucket.set(wb, this.buildReadPageNoKey(), (Serializable)pageNo);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increaseCount(WriteBatch wb, int pageNo) {
        ReentrantLock lock = this.writeLock;
        lock.lock();
        try {
            if (this.pageCounts[pageNo - 1] == this.maxCapacityOfPage) {
                this.logger.warn((Object)("bucket[" + this.id + "] page[" + pageNo + "]'s count is reach max capacity of page:" + this.maxCapacityOfPage + ", page count can't be increased"));
                return;
            }
            int n = pageNo - 1;
            this.pageCounts[n] = this.pageCounts[n] + 1;
        }
        finally {
            lock.unlock();
        }
    }

    private void decreaseCount(int pageNo) {
        ReentrantLock lock = this.writeLock;
        lock.lock();
        try {
            if (this.pageCounts[pageNo - 1] == 0) {
                this.logger.warn((Object)("bucket[" + this.id + "] page[" + pageNo + "]'s count is 0, page count can't be decreased"));
                return;
            }
            int n = pageNo - 1;
            this.pageCounts[n] = this.pageCounts[n] - 1;
        }
        finally {
            lock.unlock();
        }
    }

    private int increaseReadPageNo(int pageNo) {
        if (pageNo == this.maxCountOfPage) {
            return 1;
        }
        return ++pageNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePageCount(WriteBatch wb, int count) throws IOException {
        ReentrantLock lock = this.writeLock;
        lock.lock();
        try {
            LevelDBBucket.set(wb, LevelDBBucket.buildBucketPageCount(this.id), (Serializable)Integer.valueOf(count));
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePage(WriteBatch wb, LevelDBPage page) throws IOException {
        ReentrantLock lock = this.writeLock;
        lock.lock();
        try {
            LevelDBBucket.set(wb, this.buildPageId(String.valueOf(page.getNo())), (Serializable)page);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LevelDBPage getIdlePage(WriteBatch wb) throws BucketFullException, IOException {
        ReentrantLock lock = this.writeLock;
        lock.lock();
        try {
            int scanPageNo;
            if (this.currentPage.getIndexes().size() < this.maxCapacityOfPage) {
                LevelDBPage levelDBPage = this.currentPage;
                return levelDBPage;
            }
            int pageNo = 0;
            for (scanPageNo = (int)this.currentPage.getNo(); scanPageNo <= this.pageCounts.length; ++scanPageNo) {
                if (this.pageCounts[scanPageNo - 1] >= this.maxCapacityOfPage) continue;
                pageNo = scanPageNo;
                break;
            }
            if (this.currentPage.getNo() == 1L && pageNo == 0) {
                throw new BucketFullException(this.id);
            }
            if (pageNo == 0) {
                scanPageNo = 1;
                while ((long)scanPageNo < this.currentPage.getNo()) {
                    if (this.pageCounts[scanPageNo - 1] < this.maxCapacityOfPage) {
                        pageNo = scanPageNo;
                        break;
                    }
                    ++scanPageNo;
                }
                if ((long)pageNo == this.currentPage.getNo()) {
                    throw new BucketFullException(this.id);
                }
            }
            if (this.openCache) {
                this.currentPage = this.pagesCache.getPageByNo(pageNo);
            } else {
                LevelDBPage page = this.getPage(String.valueOf(pageNo));
                if (null == page) {
                    page = this.createPage(pageNo);
                    this.savePage(wb, page);
                    ++this.pageCount;
                    this.savePageCount(wb, this.pageCount);
                }
                this.currentPage = page;
            }
            LevelDBPage levelDBPage = this.currentPage;
            return levelDBPage;
        }
        finally {
            lock.unlock();
        }
    }

    public LevelDBPage getCurrentPage() {
        return this.currentPage;
    }

    public boolean isFull() {
        return this.count() >= this.capacity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count() {
        ReentrantLock lock = this.writeLock;
        lock.lock();
        try {
            int count = 0;
            for (int pageCount : this.pageCounts) {
                count += pageCount;
            }
            int n = count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public int capacity() {
        return this.capacityOfBucket;
    }

    private LevelDBPage getPage(String pageId) throws IOException {
        return LevelDBBucket.get(this.db, this.buildPageId(pageId), LevelDBPage.class);
    }

    public LevelDBPage getPageInner(int pageId) throws IOException {
        if (this.openCache) {
            return this.pagesCache.getPageByNo(pageId);
        }
        return this.getPage(String.valueOf(pageId));
    }

    public void iterateIndex(IndexIterator iterator) throws IOException {
        for (int pageNo = 1; pageNo <= this.getPageCount(); ++pageNo) {
            LevelDBPage snapshotPage = this.clonePage(pageNo);
            if (null == snapshotPage) {
                return;
            }
            for (String index : snapshotPage.getIndexes()) {
                try {
                    iterator.iterateIndex(index, pageNo);
                }
                catch (Throwable e) {
                    this.logger.error((Object)("iterating page index error:" + e.getMessage()), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LevelDBPage clonePage(int pageNo) throws IOException {
        ReentrantLock lock = this.writeLock;
        lock.lock();
        try {
            LevelDBPage page = this.getPageInner(pageNo);
            if (null == page) {
                LevelDBPage levelDBPage = null;
                return levelDBPage;
            }
            if (page.getIndexes() == null || page.getIndexes().size() == 0) {
                LevelDBPage levelDBPage = null;
                return levelDBPage;
            }
            LevelDBPage levelDBPage = page.clone();
            return levelDBPage;
        }
        finally {
            lock.unlock();
        }
    }

    protected String buildReadPageNoKey() {
        return new StringBuffer(LevelDBBucket.buildBucketKey(this.id)).append("_rc").toString();
    }

    protected static String buildBucketKey(String id) {
        return "bucket_" + id;
    }

    protected static String buildBucketPageCount(String id) {
        return new StringBuffer(LevelDBBucket.buildBucketKey(id)).append("_pageCount").toString();
    }

    protected String buildPageId(String pageNo) {
        return this.wrapperKey(this.id + "_page_" + pageNo);
    }

    protected String wrapperKey(String key) {
        return this.queueName + "_" + key;
    }

    public DB getDb() {
        return this.db;
    }

    public boolean isOpenCache() {
        return this.openCache;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public int getMaxCountOfPage() {
        return this.maxCountOfPage;
    }

    public void setMaxCountOfPage(int maxCountOfPage) {
        if (maxCountOfPage < 10) {
            throw new IllegalArgumentException("maxCountOfPage parameter can't be lower than 10");
        }
        this.maxCountOfPage = maxCountOfPage;
    }

    public int getMaxCapacityOfPage() {
        return this.maxCapacityOfPage;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public String getId() {
        return this.id;
    }

    static <T> T get(DB db, String key, Class<T> type) throws IOException {
        byte[] data = db.get(key.getBytes());
        Serializable obj = SerializeUtils.unserialize((byte[])data);
        if (null == obj) {
            return null;
        }
        return type.cast(obj);
    }

    static void delete(DB db, String key) {
        db.delete(key.getBytes());
    }

    static void delete(WriteBatch wb, String key) {
        wb.delete(key.getBytes());
    }

    static void set(DB db, String key, Serializable obj) throws IOException {
        db.put(key.getBytes(), SerializeUtils.serialize((Serializable)obj));
    }

    static void set(WriteBatch wb, String key, Serializable obj) throws IOException {
        wb.put(key.getBytes(), SerializeUtils.serialize((Serializable)obj));
    }

    private static Profile loadProfile(DB db, String id) throws IOException {
        String bucketKey = LevelDBBucket.buildBucketKey(id);
        return LevelDBBucket.get(db, bucketKey, Profile.class);
    }

    public static class Builder {
        private final DB db;
        private String queueName;
        private String id;
        private Profile profile = new Profile();

        public Builder(DB db) {
            this.db = db;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public Builder openCache(boolean openCache) {
            this.profile.setOpenCache(openCache);
            return this;
        }

        public Builder maxCountOfPage(Integer maxCountOfPage) {
            this.profile.setMaxCountOfPage(maxCountOfPage);
            return this;
        }

        public LevelDBBucket build() throws IOException {
            if (StringHelper.isEmpty((String)this.id) && StringHelper.isEmpty((String)this.queueName)) {
                throw new IllegalArgumentException("please set id or queueName parameter");
            }
            LevelDBBucket bucket = null;
            if (StringHelper.isNotEmpty((String)this.id)) {
                Profile snapshotProfile = LevelDBBucket.loadProfile(this.db, this.id);
                if (null != snapshotProfile) {
                    if (null != this.profile.getMaxCountOfPage()) {
                        snapshotProfile.setMaxCountOfPage(this.profile.getMaxCountOfPage());
                    }
                    this.profile = snapshotProfile;
                }
            } else {
                this.profile.setQueueName(this.queueName);
            }
            if (StringHelper.isEmpty((String)this.id)) {
                this.id = this.generateId();
                LevelDBBucket.set(this.db, LevelDBBucket.buildBucketKey(this.id), (Serializable)this.profile);
            } else if (StringHelper.isEmpty((String)this.profile.getQueueName())) {
                throw new IllegalArgumentException("bucket id can't be found and queueName is empty, please input queueName parameter");
            }
            bucket = new LevelDBBucket(this.id, this.db, this.profile);
            bucket.open();
            return bucket;
        }

        private String generateId() {
            return UUID.randomUUID().toString();
        }
    }

    public static class Profile
    implements Serializable {
        private static final long serialVersionUID = -2216005382888211890L;
        private Integer maxCountOfPage;
        private String queueName;
        private boolean openCache = false;

        public Integer getMaxCountOfPage() {
            return this.maxCountOfPage;
        }

        public void setMaxCountOfPage(Integer maxCountOfPage) {
            this.maxCountOfPage = maxCountOfPage;
        }

        public String getQueueName() {
            return this.queueName;
        }

        public void setQueueName(String queueName) {
            this.queueName = queueName;
        }

        public boolean isOpenCache() {
            return this.openCache;
        }

        public void setOpenCache(boolean openCache) {
            this.openCache = openCache;
        }
    }
}

