/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.leveldb;

import eventcenter.api.EventCenterConfig;
import eventcenter.api.async.QueueEventContainer;
import eventcenter.api.async.QueueEventContainerFactory;
import eventcenter.leveldb.LevelDBContainer;
import eventcenter.leveldb.LevelDBPersistenceAdapter;
import eventcenter.leveldb.LevelDBQueue;
import eventcenter.leveldb.QueueMiddleComponent;
import eventcenter.leveldb.strategy.LimitReadHouseKeepingStrategy;
import eventcenter.leveldb.tx.TransactionConfig;
import java.io.File;

public class LevelDBContainerFactory
implements QueueEventContainerFactory {
    private LevelDBPersistenceAdapter adapter;
    private QueueMiddleComponent queueMiddle;
    private LevelDBQueue queue;
    private LevelDBContainer container;
    private boolean openTxn = false;
    private TransactionConfig transactionConfig;
    private String path;
    private Integer corePoolSize = Runtime.getRuntime().availableProcessors();
    private Integer maximumPoolSize;
    private Integer keepAliveTime;
    private Integer blockingQueueFactor;
    private Integer readLimitSize;
    private Long checkInterval;
    private Long loopQueueInterval;
    private String levelDBName;
    private Boolean openLevelDbLog;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Integer getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(Integer corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public Integer getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMaximumPoolSize(Integer maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public Integer getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(Integer keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public Integer getBlockingQueueFactor() {
        return this.blockingQueueFactor;
    }

    public void setBlockingQueueFactor(Integer blockingQueueFactor) {
        this.blockingQueueFactor = blockingQueueFactor;
    }

    public Integer getReadLimitSize() {
        return this.readLimitSize;
    }

    public void setReadLimitSize(Integer readLimitSize) {
        this.readLimitSize = readLimitSize;
    }

    public Long getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(Long checkInterval) {
        this.checkInterval = checkInterval;
    }

    public String getLevelDBName() {
        return this.levelDBName;
    }

    public void setLevelDBName(String levelDBName) {
        this.levelDBName = levelDBName;
    }

    public Boolean getOpenLevelDbLog() {
        return this.openLevelDbLog;
    }

    public void setOpenLevelDbLog(Boolean openLevelDbLog) {
        this.openLevelDbLog = openLevelDbLog;
    }

    public Long getLoopQueueInterval() {
        return this.loopQueueInterval;
    }

    public void setLoopQueueInterval(Long loopQueueInterval) {
        this.loopQueueInterval = loopQueueInterval;
    }

    public boolean isOpenTxn() {
        return this.openTxn;
    }

    public void setOpenTxn(boolean openTxn) {
        this.openTxn = openTxn;
    }

    public TransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    public void setTransactionConfig(TransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    public QueueEventContainer createContainer(EventCenterConfig config) {
        if (null != this.container) {
            return this.container;
        }
        this.adapter = new LevelDBPersistenceAdapter();
        this.adapter.setOpenLogger(this.openLevelDbLog);
        this.queueMiddle = new QueueMiddleComponent(this.adapter);
        File dir = new File(System.getProperty("user.home") + File.separator + "ec" + File.separator + "leveldb");
        if (null != this.path && !"".equals(this.path)) {
            dir = new File(this.path);
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.adapter.setDirPath(dir);
        this.adapter.setName(this.levelDBName);
        this.queue = new LevelDBQueue(this.queueMiddle);
        LimitReadHouseKeepingStrategy strategy = new LimitReadHouseKeepingStrategy(this.queue);
        if (null != this.checkInterval) {
            strategy.setCheckInterval(this.checkInterval);
        }
        if (null != this.readLimitSize) {
            strategy.setReadLimitSize(this.readLimitSize);
        }
        this.queue.setHouseKeepingStrategy(strategy);
        this.container = new LevelDBContainer(config, this.queue);
        if (null != this.corePoolSize) {
            this.container.setCorePoolSize(this.corePoolSize);
        }
        if (null != this.maximumPoolSize) {
            this.container.setMaximumPoolSize(this.maximumPoolSize);
        }
        if (null != this.keepAliveTime) {
            this.container.setKeepAliveTime(this.keepAliveTime);
        }
        if (null != this.blockingQueueFactor) {
            this.container.setBlockingQueueFactor(this.blockingQueueFactor.intValue());
        }
        if (null != this.loopQueueInterval) {
            this.container.setLoopQueueInterval(this.loopQueueInterval);
        }
        if (null != this.transactionConfig) {
            this.container.setTransactionConfig(this.transactionConfig);
            this.queue.setTransactionConfig(this.transactionConfig);
        } else if (this.openTxn) {
            this.transactionConfig = new TransactionConfig();
            this.container.setTransactionConfig(this.transactionConfig);
            this.queue.setTransactionConfig(this.transactionConfig);
        }
        return this.container;
    }
}

