/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.predicate;

import io.doov.core.dsl.lang.Readable;
import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.predicate.PredicateMetadata;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class ValuePredicateMetadata<M extends ValuePredicateMetadata<M>>
extends LeafMetadata<M>
implements PredicateMetadata {
    private final AtomicInteger evalTrue = new AtomicInteger();
    private final AtomicInteger evalFalse = new AtomicInteger();

    public ValuePredicateMetadata(MetadataType type) {
        super(type);
    }

    @Override
    public AtomicInteger evalTrue() {
        return this.evalTrue;
    }

    @Override
    public AtomicInteger evalFalse() {
        return this.evalFalse;
    }

    public static <M extends ValuePredicateMetadata<M>> M trueMetadata() {
        return (M)((ValuePredicateMetadata)new ValuePredicateMetadata<M>(MetadataType.LEAF_PREDICATE).operator(DefaultOperator.always_true));
    }

    public static <M extends ValuePredicateMetadata<M>> M falseMetadata() {
        return (M)((ValuePredicateMetadata)new ValuePredicateMetadata<M>(MetadataType.LEAF_PREDICATE).operator(DefaultOperator.always_false));
    }

    public static <M extends ValuePredicateMetadata<M>> M valueMetadata(Supplier<?> value) {
        return (M)((ValuePredicateMetadata)new ValuePredicateMetadata<M>(MetadataType.LEAF_VALUE).valueSupplier(value));
    }

    public static <M extends ValuePredicateMetadata<M>> M valueMetadata(Object value) {
        return (M)((ValuePredicateMetadata)new ValuePredicateMetadata<M>(MetadataType.LEAF_VALUE).valueObject(value));
    }

    public static <M extends ValuePredicateMetadata<M>> M readableMetadata(Readable readable) {
        return (M)((ValuePredicateMetadata)new ValuePredicateMetadata<M>(MetadataType.LEAF_VALUE).valueReadable(readable));
    }

    public static <M extends ValuePredicateMetadata<M>> M readableMetadata(Readable ... readables) {
        ValuePredicateMetadata<M> metadata = new ValuePredicateMetadata<M>(MetadataType.LEAF_VALUE);
        for (Readable readable : readables) {
            metadata.valueReadable(readable);
        }
        return (M)metadata;
    }

    public static <M extends ValuePredicateMetadata<M>> M stringMetadata(String value) {
        return (M)((ValuePredicateMetadata)new ValuePredicateMetadata<M>(MetadataType.LEAF_VALUE).valueString(value));
    }

    public static <M extends ValuePredicateMetadata<M>> M stringMetadata(String value, String value2) {
        return (M)((ValuePredicateMetadata)((ValuePredicateMetadata)new ValuePredicateMetadata<M>(MetadataType.LEAF_VALUE).valueString(value)).valueString(value2));
    }

    public static <M extends ValuePredicateMetadata<M>> M unknownMetadata(String value) {
        return (M)((ValuePredicateMetadata)new ValuePredicateMetadata<M>(MetadataType.LEAF_VALUE).valueUnknown(value));
    }

    public static <M extends ValuePredicateMetadata<M>> M valueListMetadata(Collection<?> values) {
        return (M)((ValuePredicateMetadata)new ValuePredicateMetadata<M>(MetadataType.LEAF_VALUE).valueListObject(values));
    }

    public static <M extends ValuePredicateMetadata<M>> M anyMatchMetadata(Collection<?> values) {
        return (M)((ValuePredicateMetadata)new ValuePredicateMetadata<M>(MetadataType.FIELD_PREDICATE_MATCH_ANY).valueListObject(values));
    }

    public static <M extends ValuePredicateMetadata<M>> M anyMatchMetadata(String ... readables) {
        return (M)((ValuePredicateMetadata)((ValuePredicateMetadata)new ValuePredicateMetadata<M>(MetadataType.FIELD_PREDICATE_MATCH_ANY).valueReadable(DefaultOperator.lambda)).valueListObject(Arrays.asList(readables)));
    }

    public static <M extends ValuePredicateMetadata<M>> M allMatchMetadata(String ... readables) {
        return (M)((ValuePredicateMetadata)((ValuePredicateMetadata)new ValuePredicateMetadata<M>(MetadataType.FIELD_PREDICATE).valueReadable(DefaultOperator.lambda)).valueListObject(Arrays.asList(readables)));
    }

    public static <M extends ValuePredicateMetadata<M>> M noneMatchMetadata(String ... readables) {
        return (M)((ValuePredicateMetadata)((ValuePredicateMetadata)new ValuePredicateMetadata<M>(MetadataType.FIELD_PREDICATE).valueReadable(DefaultOperator.lambda)).valueListObject(Arrays.asList(readables)));
    }

    public static <M extends ValuePredicateMetadata<M>> M templateParam(String parameterIdentifier) {
        return (M)((ValuePredicateMetadata)new ValuePredicateMetadata<M>(MetadataType.TEMPLATE_IDENTIFIER).valueReadable(() -> parameterIdentifier));
    }
}

