/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.predicate;

import io.doov.core.FieldId;
import io.doov.core.dsl.DslField;
import io.doov.core.dsl.impl.DefaultFunction;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.Readable;
import io.doov.core.dsl.lang.ReduceType;
import io.doov.core.dsl.meta.BinaryMetadata;
import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.EmptyMetadata;
import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.Operator;
import io.doov.core.dsl.meta.predicate.NaryPredicateMetadata;
import io.doov.core.dsl.meta.predicate.PredicateMetadata;
import io.doov.core.dsl.meta.predicate.ValuePredicateMetadata;
import java.util.Collection;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class BinaryPredicateMetadata
extends BinaryMetadata
implements PredicateMetadata {
    private final AtomicInteger evalTrue = new AtomicInteger();
    private final AtomicInteger evalFalse = new AtomicInteger();

    public BinaryPredicateMetadata(Metadata left, Operator operator, Metadata right) {
        super(left, operator, right);
    }

    @Override
    public AtomicInteger evalTrue() {
        return this.evalTrue;
    }

    @Override
    public AtomicInteger evalFalse() {
        return this.evalFalse;
    }

    public static BinaryPredicateMetadata equalsMetadata(Metadata left, Metadata right) {
        return new BinaryPredicateMetadata(left, DefaultOperator.equals, right);
    }

    public static BinaryPredicateMetadata notEqualsMetadata(Metadata left, Metadata right) {
        return new BinaryPredicateMetadata(left, DefaultOperator.not_equals, right);
    }

    public static BinaryPredicateMetadata andMetadata(Metadata left, Metadata right) {
        return new BinaryPredicateMetadata(left, DefaultOperator.and, right);
    }

    public static BinaryPredicateMetadata orMetadata(Metadata left, Metadata right) {
        return new BinaryPredicateMetadata(left, DefaultOperator.or, right);
    }

    public static BinaryPredicateMetadata noneMatchMetadata(Metadata metadata, Collection<?> values) {
        return new BinaryPredicateMetadata(metadata, DefaultOperator.none_match_values, (Metadata)ValuePredicateMetadata.valueListMetadata(values));
    }

    public static BinaryPredicateMetadata equalsMetadata(Metadata metadata, Object value) {
        return new BinaryPredicateMetadata(metadata, DefaultOperator.equals, (Metadata)ValuePredicateMetadata.valueMetadata(value));
    }

    public static BinaryPredicateMetadata equalsMetadata(Metadata metadata, Supplier<?> supplier) {
        return new BinaryPredicateMetadata(metadata, DefaultOperator.equals, (Metadata)ValuePredicateMetadata.readableMetadata((Readable)DefaultOperator.lambda));
    }

    public static BinaryPredicateMetadata equalsMetadata(Metadata metadata, Readable value) {
        return new BinaryPredicateMetadata(metadata, DefaultOperator.equals, (Metadata)ValuePredicateMetadata.readableMetadata(value));
    }

    public static BinaryPredicateMetadata equalsMetadata(Metadata metadata, DefaultFunction<?, ?> condition) {
        return new BinaryPredicateMetadata(metadata, DefaultOperator.equals, (Metadata)condition.getMetadata());
    }

    public static BinaryPredicateMetadata notEqualsMetadata(Metadata metadata, Object value) {
        return new BinaryPredicateMetadata(metadata, DefaultOperator.not_equals, (Metadata)ValuePredicateMetadata.valueMetadata(value));
    }

    public static BinaryPredicateMetadata notEqualsMetadata(Metadata metadata, Supplier<?> supplier) {
        return new BinaryPredicateMetadata(metadata, DefaultOperator.not_equals, (Metadata)ValuePredicateMetadata.readableMetadata((Readable)DefaultOperator.lambda));
    }

    public static BinaryPredicateMetadata notEqualsMetadata(Metadata metadata, Readable value) {
        return new BinaryPredicateMetadata(metadata, DefaultOperator.not_equals, (Metadata)ValuePredicateMetadata.readableMetadata(value));
    }

    public static BinaryPredicateMetadata anyMatchMetadata(Metadata metadata, String ... readables) {
        return new BinaryPredicateMetadata(metadata, DefaultOperator.any_match_values, (Metadata)ValuePredicateMetadata.anyMatchMetadata(readables));
    }

    public static BinaryPredicateMetadata anyMatchMetadata(Metadata metadata, Collection<?> values) {
        return new BinaryPredicateMetadata(metadata, DefaultOperator.any_match_values, (Metadata)ValuePredicateMetadata.anyMatchMetadata(values));
    }

    public static BinaryPredicateMetadata allMatchMetadata(Metadata metadata, String ... readables) {
        return new BinaryPredicateMetadata(metadata, DefaultOperator.all_match_values, (Metadata)ValuePredicateMetadata.allMatchMetadata(readables));
    }

    public static BinaryPredicateMetadata allMatchMetadata(Metadata metadata, Collection<?> values) {
        return new BinaryPredicateMetadata(metadata, DefaultOperator.all_match_values, (Metadata)ValuePredicateMetadata.valueListMetadata(values));
    }

    public static BinaryPredicateMetadata matchNoneMetadata(Metadata metadata, String ... readables) {
        return new BinaryPredicateMetadata(metadata, DefaultOperator.none_match_values, (Metadata)ValuePredicateMetadata.allMatchMetadata(readables));
    }

    @Override
    public Metadata reduce(Context context, ReduceType type) {
        boolean right;
        boolean result;
        boolean bl = result = context.isEvalTrue(this) || !context.isEvalFalse(this);
        if (!result && type == ReduceType.SUCCESS) {
            return new EmptyMetadata();
        }
        if (result && type == ReduceType.FAILURE) {
            return new EmptyMetadata();
        }
        boolean left = context.isEvalTrue(this.getLeft()) || !context.isEvalFalse(this.getLeft());
        boolean bl2 = right = context.isEvalTrue(this.getRight()) || !context.isEvalFalse(this.getRight());
        if (this.getOperator() == DefaultOperator.and) {
            if (!right && left) {
                return this.getRight().reduce(context, type);
            }
            if (!left && right) {
                return this.getLeft().reduce(context, type);
            }
        } else if (this.getOperator() == DefaultOperator.or) {
            if (!right && left) {
                return this.getLeft().reduce(context, type);
            }
            if (!left && right) {
                return this.getRight().reduce(context, type);
            }
        } else {
            if (this.getLeft().type() == MetadataType.NARY_PREDICATE && ((NaryPredicateMetadata)this.getLeft()).getOperator() == DefaultOperator.count) {
                return this.getLeft().reduce(context, type);
            }
            if (this.getOperator() == DefaultOperator.any_match_values && this.getRight().type() == MetadataType.FIELD_PREDICATE_MATCH_ANY) {
                FieldId fieldId = this.left().filter(m -> m.type() == MetadataType.FIELD_PREDICATE).findFirst().map(m -> ((LeafMetadata)m).elements()).map(Deque::getFirst).map(e -> (DslField)e.getReadable()).map(DslField::id).orElse(null);
                return new BinaryPredicateMetadata(this.getLeft().reduce(context, type), DefaultOperator.equals, (Metadata)ValuePredicateMetadata.valueMetadata(context.getEvalValue(fieldId)));
            }
        }
        return new BinaryPredicateMetadata(this.getLeft().reduce(context, type), this.getOperator(), this.getRight().reduce(context, type));
    }
}

