/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl;

import io.doov.core.FieldModel;
import io.doov.core.dsl.impl.DefaultContext;
import io.doov.core.dsl.impl.DefaultResult;
import io.doov.core.dsl.lang.AbstractDSLBuilder;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.Result;
import io.doov.core.dsl.lang.StepWhen;
import io.doov.core.dsl.lang.ValidationRule;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.RuleMetadata;

public class DefaultValidationRule
extends AbstractDSLBuilder
implements ValidationRule {
    private final Metadata metadata;
    private final StepWhen stepWhen;
    private final boolean shortCircuit;

    public DefaultValidationRule(StepWhen stepWhen) {
        this(stepWhen, RuleMetadata.rule(stepWhen.metadata()), true);
    }

    public DefaultValidationRule(StepWhen stepWhen, boolean shortCircuit) {
        this(stepWhen, RuleMetadata.rule(stepWhen.metadata()), shortCircuit);
    }

    public DefaultValidationRule(StepWhen stepWhen, Metadata metadata, boolean shortCircuit) {
        this.metadata = metadata;
        this.stepWhen = stepWhen;
        this.shortCircuit = shortCircuit;
    }

    protected boolean isShortCircuit() {
        return this.shortCircuit;
    }

    @Override
    public StepWhen getStepWhen() {
        return this.stepWhen;
    }

    @Override
    public ValidationRule withShortCircuit(boolean shortCircuit) {
        return new DefaultValidationRule(this.stepWhen, shortCircuit);
    }

    @Override
    public Result executeOn(FieldModel model) {
        return this.executeOn(model, new DefaultContext(this.shortCircuit, this.stepWhen.stepCondition().metadata()));
    }

    @Override
    public Result executeOn(FieldModel model, Context context) {
        boolean valid = this.stepWhen.stepCondition().predicate().test(model, context);
        return new DefaultResult(valid, context);
    }

    @Override
    public Metadata metadata() {
        return this.metadata;
    }
}

