/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl;

import io.doov.core.FieldId;
import io.doov.core.FieldModel;
import io.doov.core.TagId;
import io.doov.core.dsl.DslField;
import io.doov.core.dsl.field.BaseFieldInfo;
import io.doov.core.dsl.field.types.Function;
import io.doov.core.dsl.impl.LeafStepCondition;
import io.doov.core.dsl.impl.base.IterableFunction;
import io.doov.core.dsl.impl.base.StringFunction;
import io.doov.core.dsl.impl.num.IntegerFunction;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.function.MapFunctionMetadata;
import io.doov.core.dsl.meta.predicate.BinaryPredicateMetadata;
import io.doov.core.dsl.meta.predicate.FieldMetadata;
import io.doov.core.dsl.meta.predicate.PredicateMetadata;
import io.doov.core.dsl.meta.predicate.UnaryPredicateMetadata;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class DefaultFunction<T, M extends Metadata>
implements Function<T> {
    protected final M metadata;
    protected final BiFunction<FieldModel, Context, Optional<T>> function;

    public DefaultFunction(M metadata, BiFunction<FieldModel, Context, Optional<T>> function) {
        this.metadata = metadata;
        this.function = function;
    }

    @Override
    public Optional<T> value(FieldModel model, Context context) {
        return this.function.apply(model, context);
    }

    public M getMetadata() {
        return this.metadata;
    }

    public BiFunction<FieldModel, Context, Optional<T>> getFunction() {
        return this.function;
    }

    @Override
    public String readable() {
        return this.metadata.readable();
    }

    public final IterableFunction<TagId, List<TagId>> tags() {
        return new IterableFunction<TagId, List<TagId>>(UnaryPredicateMetadata.tagsMetadata(this.metadata), (m, c) -> Optional.ofNullable(this.metadata).filter(o -> o instanceof FieldMetadata).map(f -> (FieldMetadata)f).map(FieldMetadata::field).map(DslField::id).map(FieldId::tags));
    }

    public final IntegerFunction position() {
        return new IntegerFunction((PredicateMetadata)UnaryPredicateMetadata.positionMetadata(this.metadata), (m, c) -> Optional.ofNullable(this.metadata).filter(o -> o instanceof FieldMetadata).map(f -> (FieldMetadata)f).map(FieldMetadata::field).map(DslField::id).map(FieldId::position));
    }

    public final StepCondition isNull() {
        return LeafStepCondition.isNull(this);
    }

    public final StepCondition isNotNull() {
        return LeafStepCondition.isNotNull(this);
    }

    public final StepCondition eq(T value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)BinaryPredicateMetadata.equalsMetadata(this.metadata, value), this.function, value, Object::equals);
    }

    @Deprecated
    public final StepCondition eq(Supplier<T> supplier) {
        return LeafStepCondition.stepCondition((PredicateMetadata)BinaryPredicateMetadata.equalsMetadata(this.metadata, supplier), this.function, supplier, Object::equals);
    }

    public final StepCondition eq(BaseFieldInfo<T> value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)BinaryPredicateMetadata.equalsMetadata(this.metadata, value), this.function, value, Object::equals);
    }

    public final StepCondition eq(Function<T> value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)BinaryPredicateMetadata.equalsMetadata(this.metadata, value), this.function, (m, c) -> Optional.ofNullable(value.read((FieldModel)m, (Context)c)), Object::equals);
    }

    public final StepCondition notEq(T value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)BinaryPredicateMetadata.notEqualsMetadata(this.metadata, value), this.function, value, (l, r) -> !l.equals(r));
    }

    @Deprecated
    public final StepCondition notEq(Supplier<T> supplier) {
        return LeafStepCondition.stepCondition((PredicateMetadata)BinaryPredicateMetadata.notEqualsMetadata(this.metadata, supplier), this.function, supplier, (l, r) -> !l.equals(r));
    }

    public final StepCondition notEq(BaseFieldInfo<T> value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)BinaryPredicateMetadata.notEqualsMetadata(this.metadata, value), this.function, value, (l, r) -> !l.equals(r));
    }

    public final StepCondition notEq(Function<T> value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)BinaryPredicateMetadata.notEqualsMetadata(this.metadata, value), this.function, (m, c) -> Optional.ofNullable(value.read((FieldModel)m, (Context)c)), (l, r) -> !l.equals(r));
    }

    @SafeVarargs
    public final StepCondition anyMatch(T ... values) {
        return LeafStepCondition.stepCondition(BinaryPredicateMetadata.anyMatchMetadata(this.metadata, Arrays.asList(values)), this.function, value -> Arrays.asList(values).contains(value));
    }

    public final StepCondition anyMatch(Collection<T> values) {
        return LeafStepCondition.stepCondition(BinaryPredicateMetadata.anyMatchMetadata(this.metadata, values), this.function, value -> values.stream().anyMatch(value::equals));
    }

    public final StepCondition anyMatch(List<Predicate<T>> values, String ... predicateReadables) {
        return LeafStepCondition.stepCondition(BinaryPredicateMetadata.anyMatchMetadata(this.metadata, predicateReadables), this.function, value -> values.stream().anyMatch((? super T v) -> v.test(value)));
    }

    @SafeVarargs
    public final StepCondition allMatch(T ... values) {
        return LeafStepCondition.stepCondition(BinaryPredicateMetadata.allMatchMetadata(this.metadata, Arrays.asList(values)), this.function, value -> Arrays.stream(values).allMatch(value::equals));
    }

    public final StepCondition allMatch(Collection<T> values) {
        return LeafStepCondition.stepCondition(BinaryPredicateMetadata.allMatchMetadata(this.metadata, values), this.function, value -> values.stream().allMatch(value::equals));
    }

    public final StepCondition allMatch(List<Predicate<T>> values, String ... predicateReadables) {
        return LeafStepCondition.stepCondition(BinaryPredicateMetadata.allMatchMetadata(this.metadata, predicateReadables), this.function, value -> values.stream().allMatch((? super T v) -> v.test(value)));
    }

    @SafeVarargs
    public final StepCondition noneMatch(T ... values) {
        return LeafStepCondition.stepCondition(BinaryPredicateMetadata.noneMatchMetadata(this.metadata, Arrays.asList(values)), this.function, value -> Arrays.stream(values).noneMatch(value::equals));
    }

    public final StepCondition noneMatch(Collection<T> values) {
        return LeafStepCondition.stepCondition(BinaryPredicateMetadata.noneMatchMetadata(this.metadata, values), this.function, value -> values.stream().noneMatch(value::equals));
    }

    public final StepCondition noneMatch(List<Predicate<T>> values, String ... predicateReadables) {
        return LeafStepCondition.stepCondition(BinaryPredicateMetadata.matchNoneMetadata(this.metadata, predicateReadables), this.function, value -> values.stream().noneMatch((? super T v) -> v.test(value)));
    }

    @Deprecated
    public final IntegerFunction mapToInt(java.util.function.Function<T, Integer> mapper) {
        return this.mapToInt("", mapper);
    }

    public final IntegerFunction mapToInt(String readable, java.util.function.Function<T, Integer> mapper) {
        return new IntegerFunction((PredicateMetadata)MapFunctionMetadata.mapToIntMetadata(this.metadata, readable), (model, context) -> this.value((FieldModel)model, (Context)context).map(mapper));
    }

    @Deprecated
    public final StringFunction mapToString(java.util.function.Function<T, String> mapper) {
        return this.mapToString("", mapper);
    }

    public final StringFunction mapToString(String readable, java.util.function.Function<T, String> mapper) {
        return new StringFunction(MapFunctionMetadata.mapToStringMetadata(this.metadata, readable), (model, context) -> this.value((FieldModel)model, (Context)context).map(mapper));
    }

    public final <R> DefaultFunction<R, MapFunctionMetadata> map(String readable, java.util.function.Function<T, R> mapper) {
        return new DefaultFunction<T, MapFunctionMetadata>(MapFunctionMetadata.mapAsMetadata(this.metadata, readable), (model, context) -> this.value((FieldModel)model, (Context)context).map(mapper));
    }

    public final <U, R> DefaultFunction<R, MapFunctionMetadata> mapUsing(String readable, Function<U> condition, BiFunction<T, U, R> mapper) {
        return new DefaultFunction<T, MapFunctionMetadata>(MapFunctionMetadata.mapUsingMetadata(this.metadata, readable, condition), (model, context) -> this.value((FieldModel)model, (Context)context).flatMap(l -> Optional.ofNullable(mapper.apply(l, condition.value((FieldModel)model, (Context)context).orElse(null)))));
    }
}

