/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.ast.AstHtmlRenderer;
import io.doov.core.dsl.meta.ast.AstLineVisitor;
import io.doov.core.dsl.meta.ast.AstMarkdownRenderer;
import io.doov.core.dsl.meta.ast.DefaultHtmlWriter;
import io.doov.core.dsl.meta.ast.FoldVisitor;
import io.doov.core.dsl.meta.i18n.ResourceBundleProvider;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AstVisitorUtils {
    public static String astToString(Metadata metadata, Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        new AstLineVisitor(stringBuilder, ResourceBundleProvider.BUNDLE, locale).browse(metadata, 0);
        return stringBuilder.toString();
    }

    public static String astToMarkdown(Metadata metadata, Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        new AstMarkdownRenderer(stringBuilder, ResourceBundleProvider.BUNDLE, locale).toMarkdown(metadata);
        return stringBuilder.toString();
    }

    public static Set<Metadata> collectMetadata(Metadata root) {
        return AstVisitorUtils.collect(root, Stream::of).collect(Collectors.toSet());
    }

    public static <T> T collect(Metadata root, T init, BiFunction<T, Metadata, T> metadataPredicate) {
        FoldVisitor<T> visitor = new FoldVisitor<T>(metadataPredicate, init);
        visitor.browse(root, 0);
        return visitor.getResult();
    }

    public static <T> Stream<T> collect(Metadata root, Function<Metadata, Stream<T>> accumulator) {
        return AstVisitorUtils.collect(root, Stream.of(new Object[0]), (r, m) -> Stream.concat(r, (Stream)accumulator.apply((Metadata)m)));
    }

    public static Stream<Metadata> collectIf(Metadata root, Predicate<Metadata> predicate) {
        return AstVisitorUtils.collect(root, m -> predicate.test((Metadata)m) ? Stream.of(m) : Stream.empty());
    }

    public static String toHtml(Metadata metadata, Locale locale) {
        ByteArrayOutputStream ops = new ByteArrayOutputStream();
        DefaultHtmlWriter htmlWriter = new DefaultHtmlWriter(locale, ops, ResourceBundleProvider.BUNDLE);
        new AstHtmlRenderer(htmlWriter).toHtml(metadata);
        return new String(ops.toByteArray(), StandardCharsets.UTF_8);
    }
}

