/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl.time;

import io.doov.core.dsl.impl.time.TemporalOperators;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalUnit;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface LocalTimeOperators
extends TemporalOperators<LocalTime> {
    @Override
    default public Function<LocalTime, LocalTime> minusFunction(int value, TemporalUnit unit) {
        return time -> time.minus(value, unit);
    }

    @Override
    default public Function<LocalTime, LocalTime> plusFunction(int value, TemporalUnit unit) {
        return time -> time.plus(value, unit);
    }

    @Override
    default public Function<LocalTime, LocalTime> withFunction(TemporalAdjuster ajuster) {
        return time -> time.with(ajuster);
    }

    @Override
    default public BiFunction<LocalTime, LocalTime, Boolean> afterFunction() {
        return LocalTime::isAfter;
    }

    @Override
    default public BiFunction<LocalTime, LocalTime, Boolean> afterOrEqualsFunction() {
        return (time1, time2) -> time1.isAfter((LocalTime)time2) || time1.equals(time2);
    }

    @Override
    default public BiFunction<LocalTime, LocalTime, Boolean> beforeFunction() {
        return LocalTime::isBefore;
    }

    @Override
    default public BiFunction<LocalTime, LocalTime, Boolean> beforeOrEqualsFunction() {
        return (time1, time2) -> time1.isBefore((LocalTime)time2) || time1.equals(time2);
    }

    @Override
    default public BiFunction<LocalTime, LocalTime, Long> betweenFunction(ChronoUnit unit) {
        return unit::between;
    }
}

