/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.mapping;

import io.doov.core.FieldModel;
import io.doov.core.dsl.impl.DefaultContext;
import io.doov.core.dsl.impl.ModelInterceptor;
import io.doov.core.dsl.lang.AbstractDSLBuilder;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.MappingInput;
import io.doov.core.dsl.lang.MappingOutput;
import io.doov.core.dsl.lang.MappingRule;
import io.doov.core.dsl.meta.MappingRuleMetadata;
import io.doov.core.dsl.meta.Metadata;

public class DefaultMappingRule<T>
extends AbstractDSLBuilder
implements MappingRule {
    private final MappingInput<T> input;
    private final MappingOutput<T> output;
    private final MappingRuleMetadata metadata;

    public DefaultMappingRule(MappingInput<T> input, MappingOutput<T> output) {
        this.input = input;
        this.output = output;
        this.metadata = new MappingRuleMetadata(input.metadata(), output.metadata());
    }

    @Override
    public Metadata metadata() {
        return this.metadata;
    }

    @Override
    public boolean validate(FieldModel inModel, FieldModel outModel) {
        return this.input.validate(inModel) && this.output.validate(outModel);
    }

    @Override
    public Context executeOn(FieldModel inModel, FieldModel outModel) {
        return this.executeOn(inModel, outModel, new DefaultContext(this.metadata));
    }

    @Override
    public Context executeOn(FieldModel model) {
        return this.executeOn(model, model);
    }

    @Override
    public <C extends Context> C executeOn(FieldModel inModel, FieldModel outModel, C context) {
        ModelInterceptor in = new ModelInterceptor(inModel, context);
        ModelInterceptor out = new ModelInterceptor(outModel, context);
        this.output.write(out, context, this.input.read(in, context));
        return context;
    }

    @Override
    public <C extends Context> C executeOn(FieldModel model, C context) {
        return this.executeOn(model, model, context);
    }
}

