/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.DslField;
import io.doov.core.dsl.meta.ConverterMetadata;
import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.Element;
import io.doov.core.dsl.meta.IterableMetadata;
import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.MappingOperator;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.Operator;
import io.doov.core.dsl.meta.ReturnType;
import io.doov.core.dsl.meta.ast.HtmlWriter;
import io.doov.core.dsl.meta.function.TemplateParamMetadata;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class AstHtmlRenderer {
    private static final List<Operator> AND_OR = Arrays.asList(DefaultOperator.and, DefaultOperator.or);
    protected HtmlWriter writer;

    public AstHtmlRenderer(HtmlWriter writer) {
        this.writer = writer;
    }

    public void toHtml(Metadata metadata) {
        this.toHtml(metadata, new ArrayDeque<Metadata>());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void toHtml(Metadata metadata, ArrayDeque<Metadata> parents) {
        parents.push(metadata);
        try {
            switch (metadata.type()) {
                case RULE: {
                    this.rule(metadata, parents);
                    return;
                }
                case WHEN: {
                    this.when(metadata, parents);
                    return;
                }
                case BINARY_PREDICATE: 
                case TEMPLATE_PARAM: {
                    this.binary(metadata, parents);
                    return;
                }
                case LEAF_PREDICATE: 
                case FIELD_PREDICATE: 
                case LEAF_VALUE: 
                case MAPPING_LEAF: 
                case TEMPLATE_IDENTIFIER: {
                    this.leaf(metadata, parents);
                    return;
                }
                case MAPPING_LEAF_ITERABLE: {
                    this.iterable(metadata, parents);
                    return;
                }
                case TYPE_CONVERTER: {
                    this.typeConverter(metadata, parents);
                    return;
                }
                case UNARY_PREDICATE: {
                    this.unary(metadata, parents);
                    return;
                }
                case NARY_PREDICATE: 
                case MULTIPLE_MAPPING: 
                case THEN_MAPPING: 
                case ELSE_MAPPING: {
                    this.nary(metadata, parents);
                    return;
                }
                case MAPPING_INPUT: {
                    this.mappingInput(metadata, parents);
                    return;
                }
                case FIELD_PREDICATE_MATCH_ANY: {
                    this.fieldMatchAny(metadata, parents);
                    return;
                }
                case SINGLE_MAPPING: {
                    this.singleMapping(metadata, parents);
                    return;
                }
                default: {
                    throw new IllegalStateException(metadata.type().name());
                }
            }
        }
        finally {
            parents.pop();
        }
    }

    private void iterable(Metadata metadata, ArrayDeque<Metadata> parents) {
        IterableMetadata iterableMetadata = (IterableMetadata)metadata;
        this.writer.writeBeginUl("dsl-ul-iterable");
        iterableMetadata.items().forEach(item -> {
            this.writer.writeBeginLi(new String[0]);
            this.toHtml((Metadata)item, parents);
            this.writer.writeEndLi();
        });
        this.writer.writeEndUl();
    }

    private void typeConverter(Metadata metadata, ArrayDeque<Metadata> parents) {
        this.writer.write("&nbsp;");
        this.writer.writeBeginSpan("dsl-token-type-converter");
        this.writer.writeBeginSpan("dsl-token-operator");
        this.writer.writeFromBundle(MappingOperator.using);
        this.writer.writeEndSpan();
        this.writer.write("&nbsp;");
        ConverterMetadata converterMetadata = (ConverterMetadata)metadata;
        converterMetadata.elementsAsList().forEach(element -> {
            this.writer.writeBeginSpan("dsl-token-value");
            this.writer.write("&apos;");
            this.writer.write(this.writer.escapeHtml4(element.getReadable().readable()));
            this.writer.write("&apos;");
            this.writer.writeEndSpan();
        });
        this.writer.writeEndSpan();
    }

    private void mappingInput(Metadata metadata, ArrayDeque<Metadata> parents) {
        metadata.children().forEach(m -> this.toHtml((Metadata)m, parents));
    }

    private void singleMapping(Metadata metadata, ArrayDeque<Metadata> parents) {
        Optional pmd = parents.stream().skip(1L).findFirst();
        MetadataType pmdType = pmd.map(Metadata::type).orElse(null);
        if (pmdType == MetadataType.MULTIPLE_MAPPING) {
            this.writer.writeBeginLi("dsl-li-nary");
        }
        this.writer.writeBeginSpan("dsl-token-single-mapping");
        this.writer.writeBeginSpan("dsl-token-operator");
        this.writer.writeFromBundle(MappingOperator.map);
        this.writer.writeEndSpan();
        this.writer.write("&nbsp;");
        this.toHtml(metadata.childAt(0), parents);
        this.writer.write("&nbsp;");
        this.writer.writeBeginSpan("dsl-token-operator");
        this.writer.writeFromBundle(MappingOperator.to);
        this.writer.writeEndSpan();
        this.writer.write("&nbsp;");
        this.toHtml(metadata.childAt(1), parents);
        this.writer.writeEndSpan();
        this.writer.write("&nbsp;");
        if (pmdType == MetadataType.MULTIPLE_MAPPING) {
            this.writer.writeEndLi();
        }
    }

    private void when(Metadata metadata, ArrayDeque<Metadata> parents) {
        Optional pmd = parents.stream().skip(1L).findFirst();
        MetadataType pmdType = pmd.map(Metadata::type).orElse(null);
        if (pmdType == MetadataType.MULTIPLE_MAPPING) {
            this.writer.writeBeginSpan("dsl-token-when");
            this.writer.writeFromBundle(metadata.getOperator());
            this.writer.writeEndSpan();
            this.writer.writeBeginUl("dsl-ul-when");
            this.toHtml(metadata.childAt(0), parents);
            this.writer.writeEndUl();
        } else {
            this.writer.writeBeginSpan("dsl-token-when");
            this.writer.writeFromBundle(metadata.getOperator());
            this.writer.writeEndSpan();
            this.writer.writeBeginUl("dsl-ul-when");
            this.toHtml(metadata.childAt(0), parents);
            this.writer.writeEndUl();
            this.writer.writeBeginSpan("dsl-token-validate");
            this.writer.writeFromBundle(DefaultOperator.validate);
            this.writer.writeEndSpan();
        }
    }

    private void fieldMatchAny(Metadata metadata, ArrayDeque<Metadata> parents) {
        this.writer.writeBeginSpan("dsl-token-value");
        for (Element e : ((LeafMetadata)metadata).elements()) {
            this.writer.writeFromBundle(e.getReadable().readable());
        }
        this.writer.writeEndSpan();
    }

    private void nary(Metadata metadata, ArrayDeque<Metadata> parents) {
        Optional pmd = parents.stream().skip(1L).findFirst();
        MetadataType pmdType = pmd.map(Metadata::type).orElse(null);
        if (pmd.map(m -> m.getOperator().returnType() == ReturnType.BOOLEAN).orElse(false).booleanValue()) {
            this.writer.writeExclusionBar(metadata, parents);
            this.writer.writeBeginSpan("dsl-token-nary");
            this.writer.writeFromBundle(metadata.getOperator());
            this.writer.writeEndSpan();
            this.writer.writeBeginOl("dsl-ol-nary");
            metadata.children().forEach(m -> this.toHtml((Metadata)m, parents));
            this.writer.writeEndOl();
        } else if (metadata.type() == MetadataType.MULTIPLE_MAPPING && pmdType == MetadataType.MULTIPLE_MAPPING) {
            this.writer.writeBeginLi("dsl-li-nary");
            metadata.children().forEach(m -> this.toHtml((Metadata)m, parents));
            this.writer.writeEndLi();
        } else if (metadata.type() == MetadataType.MULTIPLE_MAPPING) {
            if (metadata.children().filter(m -> m.getOperator() == DefaultOperator.when).count() == 1L) {
                this.writer.writeBeginDiv("dsl-token-single-mapping");
                metadata.children().forEach(m -> this.toHtml((Metadata)m, parents));
                this.writer.writeEndDiv();
            } else {
                this.writer.writeBeginUl("dsl-ol-mapping-nary");
                metadata.children().forEach(m -> this.toHtml((Metadata)m, parents));
                this.writer.writeEndUl();
            }
        } else if (metadata.type() == MetadataType.THEN_MAPPING) {
            this.writer.writeBeginSpan("dsl-token-then");
            this.writer.writeFromBundle(metadata.getOperator());
            this.writer.writeEndSpan();
            this.writer.writeBeginUl("dsl-ol-nary");
            metadata.children().forEach(m -> this.toHtml((Metadata)m, parents));
            this.writer.writeEndUl();
        } else if (metadata.type() == MetadataType.ELSE_MAPPING && metadata.children().count() > 0L) {
            this.writer.writeBeginSpan("dsl-token-else");
            this.writer.writeFromBundle(metadata.getOperator());
            this.writer.writeEndSpan();
            this.writer.writeBeginUl("dsl-ol-nary");
            metadata.children().forEach(m -> this.toHtml((Metadata)m, parents));
            this.writer.writeEndUl();
        } else if (metadata.type() != MetadataType.ELSE_MAPPING) {
            this.writer.writeBeginLi("dsl-li-nary");
            this.writer.writeExclusionBar(metadata, parents);
            this.writer.writeBeginSpan("dsl-token-nary");
            this.writer.writeFromBundle(metadata.getOperator());
            this.writer.writeEndSpan();
            this.writer.writeBeginOl("dsl-ol-nary");
            metadata.children().forEach(m -> this.toHtml((Metadata)m, parents));
            this.writer.writeEndOl();
            this.writer.writeEndLi();
        }
    }

    private void rule(Metadata metadata, ArrayDeque<Metadata> parents) {
        this.writer.writeBeginDiv("dsl-validation-rule");
        metadata.children().forEach(m -> this.toHtml((Metadata)m, parents));
        this.writer.writeEndDiv();
    }

    private void binary(Metadata metadata, ArrayDeque<Metadata> parents) {
        Optional pmd = parents.stream().skip(1L).findFirst();
        MetadataType pmdType = pmd.map(Metadata::type).orElse(null);
        Operator pmdOperator = pmd.map(Metadata::getOperator).orElse(null);
        boolean leftChild = pmd.map(m -> m.childAt(0) == metadata).orElse(false);
        if (!AND_OR.contains(pmdOperator) && metadata.getOperator() == DefaultOperator.and) {
            this.writer.writeBeginLi("dsl-li-binary");
            this.binary_BR(metadata, parents);
            this.writer.writeEndLi();
        } else if (pmdOperator == DefaultOperator.and && metadata.getOperator() == DefaultOperator.and) {
            this.binary_BR(metadata, parents);
        } else if (!AND_OR.contains(pmdOperator) && metadata.getOperator() == DefaultOperator.or) {
            this.writer.writeBeginLi("dsl-li-binary");
            this.binary_BR(metadata, parents);
            this.writer.writeEndLi();
        } else if (pmdOperator == DefaultOperator.or && metadata.getOperator() == DefaultOperator.or) {
            this.binary_BR(metadata, parents);
        } else if (pmdOperator == DefaultOperator.or && metadata.getOperator() == DefaultOperator.and && leftChild) {
            this.binary_SPACE(metadata, parents);
        } else if (pmdOperator == DefaultOperator.and && metadata.getOperator() == DefaultOperator.or && leftChild) {
            this.binary_BR(metadata, parents);
        } else if (pmdType == MetadataType.BINARY_PREDICATE && AND_OR.contains(metadata.getOperator())) {
            this.writer.writeBeginUl("dsl-ul-binary");
            this.writer.writeBeginLi("dsl-li-binary");
            this.binary_BR(metadata, parents);
            this.writer.writeEndLi();
            this.writer.writeEndUl();
        } else if (pmdType == MetadataType.BINARY_PREDICATE && !AND_OR.contains(metadata.getOperator())) {
            this.binary_SPACE(metadata, parents);
        } else if (pmdType == MetadataType.NARY_PREDICATE && AND_OR.contains(metadata.getOperator())) {
            this.writer.writeBeginLi("dsl-li-binary");
            this.binary_BR(metadata, parents);
            this.writer.writeEndLi();
        } else if (pmdType == MetadataType.NARY_PREDICATE && !AND_OR.contains(metadata.getOperator())) {
            this.writer.writeBeginLi("dsl-li-binary");
            this.binary_SPACE(metadata, parents);
            this.writer.writeEndLi();
        } else if (pmdType == MetadataType.UNARY_PREDICATE) {
            this.writer.writeBeginUl("dsl-ul-unary");
            this.binary_SPACE(metadata, parents);
            this.writer.writeEndUl();
        } else if (AND_OR.contains(metadata.getOperator())) {
            this.writer.writeBeginLi("dsl-li-binary");
            this.binary_BR(metadata, parents);
            this.writer.writeEndLi();
        } else if (metadata.type() == MetadataType.TEMPLATE_PARAM) {
            this.templateParam((TemplateParamMetadata)metadata);
        } else {
            this.binary_SPACE(metadata, parents);
        }
    }

    private void templateParam(TemplateParamMetadata metadata) {
        this.writer.writeBeginSpan(new String[0]);
        this.writer.write("{");
        this.writer.writeEndSpan();
        if (metadata.getRight().type() == MetadataType.EMPTY) {
            this.writer.writeBeginSpan("dsl-token-template-param");
            this.writer.write(metadata.childAt(0).readable(this.writer.getLocale()));
            this.writer.writeEndSpan();
        } else {
            this.writer.writeBeginSpan("dsl-token-field");
            this.handleField(metadata.childAt(1));
            this.writer.writeEndSpan();
        }
        this.writer.writeBeginSpan(new String[0]);
        this.writer.write("}");
        this.writer.writeEndSpan();
    }

    private void binary_BR(Metadata metadata, ArrayDeque<Metadata> parents) {
        this.toHtml(metadata.childAt(0), parents);
        this.writer.write("<br>");
        this.writer.writeBeginSpan("dsl-token-operator");
        this.writer.writeFromBundle(metadata.getOperator());
        this.writer.writeEndSpan();
        this.writer.write("&nbsp;");
        this.toHtml(metadata.childAt(1), parents);
    }

    private void binary_SPACE(Metadata metadata, ArrayDeque<Metadata> parents) {
        Optional pmd = parents.stream().skip(1L).findFirst();
        Operator pmdOperator = pmd.map(Metadata::getOperator).orElse(null);
        boolean leftChild = pmd.map(m -> m.childAt(0) == metadata).orElse(false);
        if (!leftChild || pmdOperator != DefaultOperator.or || metadata.getOperator() != DefaultOperator.and) {
            this.writer.writeExclusionBar(metadata, parents);
        }
        this.toHtml(metadata.childAt(0), parents);
        this.writer.write("&nbsp;");
        this.writer.writeBeginSpan("dsl-token-operator");
        this.writer.writeFromBundle(metadata.getOperator());
        this.writer.writeEndSpan();
        this.writer.write("&nbsp;");
        this.toHtml(metadata.childAt(1), parents);
    }

    private void unary(Metadata metadata, ArrayDeque<Metadata> parents) {
        Optional pmd = parents.stream().skip(1L).findFirst();
        Operator pmdOperator = pmd.map(Metadata::getOperator).orElse(null);
        if (AND_OR.contains(pmdOperator) && metadata.getOperator() == DefaultOperator.not) {
            this.writer.writeExclusionBar(metadata, parents);
            this.prefixUnary(metadata, parents);
        } else if (!AND_OR.contains(pmdOperator) && metadata.getOperator() == DefaultOperator.not) {
            this.writer.writeBeginLi("dsl-li-unary");
            this.prefixUnary(metadata, parents);
            this.writer.writeEndLi();
        } else if (pmd.map(m -> m.type() == MetadataType.NARY_PREDICATE).orElse(false).booleanValue()) {
            this.writer.writeBeginLi("dsl-li-leaf");
            this.writer.writeExclusionBar(metadata, parents);
            this.postfixUnary(metadata, parents);
            this.writer.writeEndLi();
        } else {
            this.writer.writeExclusionBar(metadata, parents);
            this.postfixUnary(metadata, parents);
        }
    }

    private void prefixUnary(Metadata metadata, ArrayDeque<Metadata> parents) {
        this.writer.writeBeginSpan("dsl-token-operator");
        this.writer.writeFromBundle(metadata.getOperator());
        this.writer.writeEndSpan();
        this.writer.write("&nbsp;");
        this.toHtml(metadata.childAt(0), parents);
    }

    private void postfixUnary(Metadata metadata, ArrayDeque<Metadata> parents) {
        this.toHtml(metadata.childAt(0), parents);
        this.writer.write("&nbsp;");
        this.writer.writeBeginSpan("dsl-token-operator");
        this.writer.writeFromBundle(metadata.getOperator());
        this.writer.writeEndSpan();
    }

    private void leaf(Metadata metadata, ArrayDeque<Metadata> parents) {
        this.writer.writeExclusionBar(metadata, parents);
        Optional pmd = parents.stream().skip(1L).findFirst();
        if (pmd.map(m -> m.type() == MetadataType.NARY_PREDICATE).orElse(false).booleanValue()) {
            this.writer.writeBeginLi("dsl-li-leaf");
        }
        ArrayList<Element> elts = new ArrayList<Element>(((LeafMetadata)metadata).elements());
        for (Element e : elts) {
            switch (e.getType()) {
                case OPERATOR: {
                    this.writer.writeBeginSpan("dsl-token-operator");
                    this.writer.writeFromBundle((Operator)e.getReadable());
                    this.writer.writeEndSpan();
                    break;
                }
                case TEMPORAL_UNIT: {
                    this.writer.writeBeginSpan("dsl-token-operator");
                    this.writer.writeFromBundle(e.getReadable().readable());
                    this.writer.writeEndSpan();
                    break;
                }
                case FIELD: {
                    Metadata fieldMetadata = ((DslField)e.getReadable()).getMetadata();
                    if (fieldMetadata.type() == MetadataType.TEMPLATE_PARAM) {
                        this.templateParam((TemplateParamMetadata)fieldMetadata);
                        break;
                    }
                    this.writer.writeBeginSpan("dsl-token-field");
                    this.handleField(fieldMetadata);
                    this.writer.writeEndSpan();
                    break;
                }
                case STRING_VALUE: {
                    this.writer.writeBeginSpan("dsl-token-value");
                    this.writer.write("&apos;");
                    this.writer.write(this.writer.escapeHtml4(e.getReadable().readable()));
                    this.writer.write("&apos;");
                    this.writer.writeEndSpan();
                    break;
                }
                case VALUE: {
                    this.writer.writeBeginSpan("dsl-token-value");
                    this.writer.writeFromBundle(e.getReadable().readable());
                    this.writer.writeEndSpan();
                    break;
                }
                default: {
                    this.writer.writeBeginSpan("dsl-token-unknown");
                    this.writer.writeFromBundle(e.getReadable().readable());
                    this.writer.writeEndSpan();
                }
            }
            if (elts.indexOf(e) == elts.size() - 1) continue;
            this.writer.write("&nbsp;");
        }
        if (pmd.map(m -> m.type() == MetadataType.NARY_PREDICATE).orElse(false).booleanValue()) {
            this.writer.writeEndLi();
        }
    }

    protected void handleField(Metadata metadata) {
        this.writer.write(this.writer.escapeHtml4(metadata.readable(this.writer.getLocale())));
    }
}

