/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl.base;

import io.doov.core.FieldModel;
import io.doov.core.dsl.impl.DefaultFunction;
import io.doov.core.dsl.impl.LeafStepCondition;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.meta.function.IterableFunctionMetadata;
import io.doov.core.dsl.meta.predicate.PredicateMetadata;
import io.doov.core.dsl.meta.predicate.UnaryPredicateMetadata;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class IterableFunction<T, C extends Iterable<T>>
extends DefaultFunction<C, PredicateMetadata> {
    public IterableFunction(PredicateMetadata metadata, BiFunction<FieldModel, Context, Optional<C>> value) {
        super(metadata, value);
    }

    public StepCondition contains(T value) {
        return LeafStepCondition.stepCondition(IterableFunctionMetadata.containsMetadata(this.metadata, value), this.getFunction(), collection -> StreamSupport.stream(collection.spliterator(), false).anyMatch(value::equals));
    }

    @SafeVarargs
    public final StepCondition containsAll(T ... values) {
        return LeafStepCondition.stepCondition(IterableFunctionMetadata.containsMetadata(this.metadata, Arrays.asList(values)), this.getFunction(), iterable -> StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toSet()).containsAll(Arrays.asList(values)));
    }

    public StepCondition isEmpty() {
        return LeafStepCondition.stepCondition(UnaryPredicateMetadata.isEmptyMetadata(this.metadata), this.getFunction(), iterable -> !iterable.iterator().hasNext());
    }

    public StepCondition isNotEmpty() {
        return LeafStepCondition.stepCondition(UnaryPredicateMetadata.isNotEmptyMetadata(this.metadata), this.getFunction(), iterable -> iterable.iterator().hasNext());
    }

    public StepCondition hasSize(int size) {
        return LeafStepCondition.stepCondition(IterableFunctionMetadata.hasSizeMetadata(this.metadata, size), this.getFunction(), iterable -> StreamSupport.stream(iterable.spliterator(), false).count() == (long)size);
    }

    public StepCondition hasNotSize(int size) {
        return LeafStepCondition.stepCondition(IterableFunctionMetadata.hasNotSizeMetadata(this.metadata, size), this.getFunction(), iterable -> StreamSupport.stream(iterable.spliterator(), false).count() != (long)size);
    }
}

