/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.template;

import io.doov.core.FieldId;
import io.doov.core.FieldInfo;
import io.doov.core.dsl.DslField;
import io.doov.core.dsl.field.DelegatingFieldInfo;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.function.TemplateParamMetadata;
import java.util.function.Function;

public class TemplateParam<T extends DslField<?>> {
    public final Class<T> type;
    private ProxyFieldInfo fieldInfo;
    private Function<FieldInfo, T> constructorRef;

    public static <T> Class<T> generify(Class<?> cls) {
        return cls;
    }

    public TemplateParam(Class<T> type, String parameterIdentifier, Function<FieldInfo, T> constructorRef) {
        this.type = type;
        this.fieldInfo = new ProxyFieldInfo(parameterIdentifier);
        this.constructorRef = constructorRef;
    }

    public T create() {
        return (T)((DslField)this.constructorRef.apply(this.fieldInfo));
    }

    public TemplateParam<T> bind(T field) {
        this.fieldInfo.setFieldInfo((FieldInfo)field);
        return this;
    }

    private static class ProxyFieldInfo
    implements DelegatingFieldInfo {
        private FieldInfo fieldInfo;
        private String unInitReadable;
        private FieldId templateFieldId;

        ProxyFieldInfo(String parameterIdentifier) {
            this.unInitReadable = parameterIdentifier;
            this.templateFieldId = () -> parameterIdentifier;
        }

        public void setFieldInfo(FieldInfo fieldInfo) {
            this.fieldInfo = fieldInfo;
        }

        @Override
        public FieldInfo delegate() {
            return this.fieldInfo;
        }

        @Override
        public FieldId id() {
            return this.fieldInfo != null ? this.fieldInfo.id() : this.templateFieldId;
        }

        @Override
        public Metadata getMetadata() {
            return TemplateParamMetadata.templateParamMetadata(this.unInitReadable, this.fieldInfo);
        }

        @Override
        public String readable() {
            return this.getMetadata().readable();
        }
    }
}

