/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl.time;

import io.doov.core.FieldModel;
import io.doov.core.dsl.field.types.NumericFieldInfo;
import io.doov.core.dsl.field.types.TemporalFieldInfo;
import io.doov.core.dsl.impl.DefaultFunction;
import io.doov.core.dsl.impl.LeafStepCondition;
import io.doov.core.dsl.impl.LogicalBinaryCondition;
import io.doov.core.dsl.impl.LogicalUnaryCondition;
import io.doov.core.dsl.impl.num.IntegerFunction;
import io.doov.core.dsl.impl.num.LongFunction;
import io.doov.core.dsl.impl.num.NumericFunction;
import io.doov.core.dsl.impl.time.TemporalOperators;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.meta.function.TemporalBiFunctionMetadata;
import io.doov.core.dsl.meta.predicate.BinaryPredicateMetadata;
import io.doov.core.dsl.meta.predicate.PredicateMetadata;
import io.doov.core.dsl.time.TemporalAdjuster;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public abstract class TemporalFunction<N extends Temporal>
extends DefaultFunction<N, PredicateMetadata>
implements TemporalOperators<N> {
    protected TemporalFunction(PredicateMetadata metadata, BiFunction<FieldModel, Context, Optional<N>> value) {
        super(metadata, value);
    }

    protected abstract TemporalFunction<N> temporalFunction(PredicateMetadata var1, BiFunction<FieldModel, Context, Optional<N>> var2);

    @Override
    public final StepCondition eq(TemporalFunction<N> value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)BinaryPredicateMetadata.equalsMetadata(this.metadata, value), this.getFunction(), value.getFunction(), Object::equals);
    }

    public final StepCondition before(N value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)TemporalBiFunctionMetadata.beforeValueMetadata(this, value), this.getFunction(), value, (l, r) -> this.beforeFunction().apply(l, r));
    }

    public final StepCondition before(TemporalFieldInfo<N> value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)TemporalBiFunctionMetadata.beforeTemporalFieldMetadata(this, value), this.getFunction(), value, (l, r) -> this.beforeFunction().apply(l, r));
    }

    public final StepCondition before(Supplier<N> value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)TemporalBiFunctionMetadata.beforeSupplierMetadata(this, value), this.getFunction(), value, (l, r) -> this.beforeFunction().apply(l, r));
    }

    public final StepCondition before(TemporalFunction<N> value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)TemporalBiFunctionMetadata.beforeTemporalConditionMetadata(this, value), this.getFunction(), value.getFunction(), (l, r) -> this.beforeFunction().apply(l, r));
    }

    public final StepCondition beforeOrEq(N value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)TemporalBiFunctionMetadata.beforeOrEqualsValueMetadata(this, value), this.getFunction(), value, (l, r) -> this.beforeOrEqualsFunction().apply(l, r));
    }

    public final StepCondition beforeOrEq(TemporalFieldInfo<N> value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)TemporalBiFunctionMetadata.beforeOrEqTemporalFieldMetadata(this, value), this.getFunction(), value, (l, r) -> this.beforeOrEqualsFunction().apply(l, r));
    }

    public final StepCondition beforeOrEq(Supplier<N> value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)TemporalBiFunctionMetadata.beforeOrEqualsSupplierMetadata(this, value), this.getFunction(), value, (l, r) -> this.beforeOrEqualsFunction().apply(l, r));
    }

    public final StepCondition beforeOrEq(TemporalFunction<N> value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)TemporalBiFunctionMetadata.beforeOrEqualsTemporalConditionMetadata(this, value), this.getFunction(), value.getFunction(), (l, r) -> this.beforeOrEqualsFunction().apply(l, r));
    }

    public final StepCondition after(N value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)TemporalBiFunctionMetadata.afterValueMetadata(this, value), this.getFunction(), value, (l, r) -> this.afterFunction().apply(l, r));
    }

    public final StepCondition after(TemporalFieldInfo<N> value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)TemporalBiFunctionMetadata.afterTemporalFieldMetadata(this, value), this.getFunction(), value, (l, r) -> this.afterFunction().apply(l, r));
    }

    public final StepCondition after(Supplier<N> value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)TemporalBiFunctionMetadata.afterSupplierMetadata(this, value), this.getFunction(), value, (l, r) -> this.afterFunction().apply(l, r));
    }

    public final StepCondition after(TemporalFunction<N> value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)TemporalBiFunctionMetadata.afterTemporalConditionMetadata(this, value), this.getFunction(), value.getFunction(), (l, r) -> this.afterFunction().apply(l, r));
    }

    public final StepCondition afterOrEq(N value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)TemporalBiFunctionMetadata.afterOrEqualsValueMetadata(this, value), this.getFunction(), value, (l, r) -> this.afterOrEqualsFunction().apply(l, r));
    }

    public final StepCondition afterOrEq(TemporalFieldInfo<N> value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)TemporalBiFunctionMetadata.afterOrEqTemporalFieldMetadata(this, value), this.getFunction(), value, (l, r) -> this.afterOrEqualsFunction().apply(l, r));
    }

    public final StepCondition afterOrEq(Supplier<N> value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)TemporalBiFunctionMetadata.afterOrEqualsSupplierMetadata(this, value), this.getFunction(), value, (l, r) -> this.afterOrEqualsFunction().apply(l, r));
    }

    public final StepCondition afterOrEq(TemporalFunction<N> value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)TemporalBiFunctionMetadata.afterOrEqualsTemporalConditionMetadata(this, value), this.getFunction(), value.getFunction(), (l, r) -> this.afterOrEqualsFunction().apply(l, r));
    }

    public final StepCondition between(N minIncluded, N maxExcluded) {
        return LogicalBinaryCondition.and(this.beforeOrEq(maxExcluded), this.afterOrEq(minIncluded));
    }

    public final StepCondition between(Supplier<N> minIncluded, Supplier<N> maxExcluded) {
        return LogicalBinaryCondition.and(this.beforeOrEq(maxExcluded), this.afterOrEq(minIncluded));
    }

    public final StepCondition between(TemporalFunction<N> minIncluded, TemporalFunction<N> maxExcluded) {
        return LogicalBinaryCondition.and(this.beforeOrEq(maxExcluded), this.afterOrEq(minIncluded));
    }

    public final StepCondition notBetween(N minIncluded, N maxExcluded) {
        return LogicalUnaryCondition.negate(this.between(minIncluded, maxExcluded));
    }

    public final StepCondition notBetween(Supplier<N> minIncluded, Supplier<N> maxExcluded) {
        return LogicalUnaryCondition.negate(this.between(minIncluded, maxExcluded));
    }

    public final StepCondition notBetween(TemporalFunction<N> minIncluded, TemporalFunction<N> maxExcluded) {
        return LogicalUnaryCondition.negate(this.between(minIncluded, maxExcluded));
    }

    public final TemporalFunction<N> with(TemporalAdjuster adjuster) {
        return this.temporalFunction(TemporalBiFunctionMetadata.withMetadata(this.metadata, adjuster.getMetadata()), (model, context) -> this.value((FieldModel)model, (Context)context).map(v -> (Temporal)this.withFunction(adjuster.getAdjuster()).apply(v)));
    }

    public final TemporalFunction<N> minus(int value, TemporalUnit unit) {
        return this.temporalFunction(TemporalBiFunctionMetadata.minusMetadata(this.metadata, value, (Object)unit), (model, context) -> this.value((FieldModel)model, (Context)context).map(v -> (Temporal)this.minusFunction(value, unit).apply(v)));
    }

    public final TemporalFunction<N> minus(NumericFieldInfo<Integer> value, TemporalUnit unit) {
        return this.temporalFunction(TemporalBiFunctionMetadata.minusMetadata(this.metadata, value, (Object)unit), (model, context) -> this.value((FieldModel)model, (Context)context).flatMap(l -> Optional.ofNullable(model.get(value.id())).map(r -> (Temporal)this.minusFunction((int)r, unit).apply(l))));
    }

    public final TemporalFunction<N> minus(NumericFunction<Integer> function, TemporalUnit unit) {
        return this.temporalFunction(TemporalBiFunctionMetadata.minusMetadata(this.metadata, function, (Object)unit), (model, context) -> this.value((FieldModel)model, (Context)context).flatMap(l -> function.value((FieldModel)model, (Context)context).map(r -> (Temporal)this.minusFunction((int)r, unit).apply(l))));
    }

    public final TemporalFunction<N> plus(int value, TemporalUnit unit) {
        return this.temporalFunction(TemporalBiFunctionMetadata.plusMetadata(this.metadata, value, (Object)unit), (model, context) -> this.value((FieldModel)model, (Context)context).map(v -> (Temporal)this.plusFunction(value, unit).apply(v)));
    }

    public final TemporalFunction<N> plus(NumericFieldInfo<Integer> value, TemporalUnit unit) {
        return this.temporalFunction(TemporalBiFunctionMetadata.plusMetadata(this.metadata, value, (Object)unit), (model, context) -> this.value((FieldModel)model, (Context)context).flatMap(l -> Optional.ofNullable(model.get(value.id())).map(r -> (Temporal)this.plusFunction((int)r, unit).apply(l))));
    }

    public final TemporalFunction<N> plus(NumericFunction<Integer> function, TemporalUnit unit) {
        return this.temporalFunction(TemporalBiFunctionMetadata.plusMetadata(this.metadata, function, (Object)unit), (model, context) -> this.value((FieldModel)model, (Context)context).flatMap(l -> function.value((FieldModel)model, (Context)context).map(r -> (Temporal)this.plusFunction((int)r, unit).apply(l))));
    }

    public final NumericFunction<Integer> ageAt(N value) {
        return IntegerFunction.fromLong(this.timeBetween((PredicateMetadata)TemporalBiFunctionMetadata.ageAtValueMetadata(this, value), ChronoUnit.YEARS, value));
    }

    public final NumericFunction<Integer> ageAt(TemporalFieldInfo<N> value) {
        return IntegerFunction.fromLong(this.timeBetween((PredicateMetadata)TemporalBiFunctionMetadata.ageAtTemporalFieldMetadata(this, value), ChronoUnit.YEARS, value));
    }

    public final NumericFunction<Integer> ageAt(TemporalFunction<N> value) {
        return IntegerFunction.fromLong(this.timeBetween((PredicateMetadata)TemporalBiFunctionMetadata.ageAtTemporalConditionMetadata(this, value), ChronoUnit.YEARS, value));
    }

    public final NumericFunction<Integer> ageAt(Supplier<N> value) {
        return IntegerFunction.fromLong(this.timeBetween((PredicateMetadata)TemporalBiFunctionMetadata.ageAtSupplierMetadata(this, value), ChronoUnit.YEARS, value));
    }

    public final NumericFunction<Integer> daysBetween(N value) {
        return IntegerFunction.fromLong(this.timeBetween((PredicateMetadata)TemporalBiFunctionMetadata.ageAtValueMetadata(this, value), ChronoUnit.DAYS, value));
    }

    public final NumericFunction<Integer> daysBetween(TemporalFieldInfo<N> value) {
        return IntegerFunction.fromLong(this.timeBetween((PredicateMetadata)TemporalBiFunctionMetadata.ageAtTemporalFieldMetadata(this, value), ChronoUnit.DAYS, value));
    }

    public final NumericFunction<Integer> daysBetween(TemporalFunction<N> value) {
        return IntegerFunction.fromLong(this.timeBetween((PredicateMetadata)TemporalBiFunctionMetadata.ageAtTemporalConditionMetadata(this, value), ChronoUnit.DAYS, value));
    }

    public final NumericFunction<Integer> daysBetween(Supplier<N> value) {
        return IntegerFunction.fromLong(this.timeBetween((PredicateMetadata)TemporalBiFunctionMetadata.ageAtSupplierMetadata(this, value), ChronoUnit.DAYS, value));
    }

    public final NumericFunction<Integer> monthsBetween(N value) {
        return IntegerFunction.fromLong(this.timeBetween((PredicateMetadata)TemporalBiFunctionMetadata.ageAtValueMetadata(this, value), ChronoUnit.MONTHS, value));
    }

    public final NumericFunction<Integer> monthsBetween(TemporalFieldInfo<N> value) {
        return IntegerFunction.fromLong(this.timeBetween((PredicateMetadata)TemporalBiFunctionMetadata.ageAtTemporalFieldMetadata(this, value), ChronoUnit.MONTHS, value));
    }

    public final NumericFunction<Integer> monthsBetween(TemporalFunction<N> value) {
        return IntegerFunction.fromLong(this.timeBetween((PredicateMetadata)TemporalBiFunctionMetadata.ageAtTemporalConditionMetadata(this, value), ChronoUnit.MONTHS, value));
    }

    public final NumericFunction<Integer> monthsBetween(Supplier<N> value) {
        return IntegerFunction.fromLong(this.timeBetween((PredicateMetadata)TemporalBiFunctionMetadata.ageAtSupplierMetadata(this, value), ChronoUnit.MONTHS, value));
    }

    public final NumericFunction<Integer> yearsBetween(N value) {
        return IntegerFunction.fromLong(this.timeBetween((PredicateMetadata)TemporalBiFunctionMetadata.ageAtValueMetadata(this, value), ChronoUnit.YEARS, value));
    }

    public final NumericFunction<Integer> yearsBetween(TemporalFieldInfo<N> value) {
        return IntegerFunction.fromLong(this.timeBetween((PredicateMetadata)TemporalBiFunctionMetadata.ageAtTemporalFieldMetadata(this, value), ChronoUnit.YEARS, value));
    }

    public final NumericFunction<Integer> yearsBetween(TemporalFunction<N> value) {
        return IntegerFunction.fromLong(this.timeBetween((PredicateMetadata)TemporalBiFunctionMetadata.ageAtTemporalConditionMetadata(this, value), ChronoUnit.YEARS, value));
    }

    public final NumericFunction<Integer> yearsBetween(Supplier<N> value) {
        return IntegerFunction.fromLong(this.timeBetween((PredicateMetadata)TemporalBiFunctionMetadata.ageAtSupplierMetadata(this, value), ChronoUnit.YEARS, value));
    }

    private NumericFunction<Long> timeBetween(PredicateMetadata metadata, ChronoUnit unit, N value) {
        return new LongFunction(metadata, (model, context) -> this.value((FieldModel)model, (Context)context).flatMap(l -> Optional.ofNullable(value).map(r -> this.betweenFunction(unit).apply(l, r))));
    }

    private NumericFunction<Long> timeBetween(PredicateMetadata metadata, ChronoUnit unit, TemporalFieldInfo<N> value) {
        return new LongFunction(metadata, (model, context) -> this.value((FieldModel)model, (Context)context).flatMap(l -> FieldModel.valueModel(model, value).map(r -> this.betweenFunction(unit).apply(l, r))));
    }

    private NumericFunction<Long> timeBetween(PredicateMetadata metadata, ChronoUnit unit, TemporalFunction<N> value) {
        return new LongFunction(metadata, (model, context) -> this.value((FieldModel)model, (Context)context).flatMap(l -> value.getFunction().apply((FieldModel)model, (Context)context).map(r -> this.betweenFunction(unit).apply(l, r))));
    }

    private NumericFunction<Long> timeBetween(PredicateMetadata metadata, ChronoUnit unit, Supplier<N> value) {
        return new LongFunction(metadata, (model, context) -> this.value((FieldModel)model, (Context)context).flatMap(arg_0 -> this.lambda$null$44((Supplier)value, unit, arg_0)));
    }

    private /* synthetic */ Optional lambda$null$44(Supplier value, ChronoUnit unit, Temporal l) {
        return Optional.ofNullable(value.get()).map(r -> this.betweenFunction(unit).apply(l, r));
    }
}

