/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl;

import io.doov.core.FieldId;
import io.doov.core.FieldInfo;
import io.doov.core.FieldModel;
import io.doov.core.dsl.lang.Context;
import io.doov.core.serial.TypeAdapterRegistry;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.stream.Stream;

public final class ModelInterceptor
implements FieldModel {
    private final FieldModel model;
    private final Context context;

    public ModelInterceptor(FieldModel model, Context context) {
        this.model = model;
        this.context = context;
    }

    @Override
    public <T> T get(FieldId id) {
        Object value = this.model.get(id);
        this.context.addEvalValue(id, value);
        return value;
    }

    @Override
    public <T> void set(FieldId fieldId, T value) {
        this.model.set(fieldId, value);
        this.context.addSetValue(fieldId, value);
    }

    @Override
    public Stream<Map.Entry<FieldId, Object>> stream() {
        return this.model.stream();
    }

    @Override
    public Iterator<Map.Entry<FieldId, Object>> iterator() {
        return this.model.iterator();
    }

    @Override
    public Spliterator<Map.Entry<FieldId, Object>> spliterator() {
        return this.model.spliterator();
    }

    @Override
    public Stream<Map.Entry<FieldId, Object>> parallelStream() {
        return this.model.parallelStream();
    }

    @Override
    public List<FieldInfo> getFieldInfos() {
        return this.model.getFieldInfos();
    }

    @Override
    public TypeAdapterRegistry getTypeAdapterRegistry() {
        return this.model.getTypeAdapterRegistry();
    }
}

